/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import org.aoju.bus.image.metric.internal.hl7.HL7Segment;

public class ERRSegment
extends HL7Segment {
    public ERRSegment(char fieldSeparator, String encodingCharacters) {
        super(9, fieldSeparator, encodingCharacters);
        this.setField(0, "ERR");
        this.setHL7ErrorCode("207");
        this.setSeverity("E");
    }

    public ERRSegment() {
        this('|', "^~\\&");
    }

    public ERRSegment(HL7Segment msh) {
        this(msh.getFieldSeparator(), msh.getEncodingCharacters());
    }

    public ERRSegment setErrorLocation(String errorLocation) {
        this.setField(2, errorLocation.replace('^', this.getComponentSeparator()));
        return this;
    }

    public ERRSegment setHL7ErrorCode(String hl7ErrorCode) {
        this.setField(3, hl7ErrorCode);
        return this;
    }

    public ERRSegment setSeverity(String severity) {
        this.setField(4, severity);
        return this;
    }

    public ERRSegment setApplicationErrorCode(String applicationErrorCode) {
        this.setField(5, applicationErrorCode);
        return this;
    }

    public ERRSegment setApplicationErrorParameter(String applicationErrorParameter) {
        this.setField(6, applicationErrorParameter);
        return this;
    }

    public ERRSegment setDiagnosticInformation(String diagnosticInformation) {
        this.setField(7, diagnosticInformation);
        return this;
    }

    public ERRSegment setUserMessage(String userMessage) {
        this.setField(8, userMessage);
        return this;
    }
}

