/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MLLPOutputStream
extends FilterOutputStream {
    private static final int SOM = 11;
    private static final byte[] EOM = new byte[]{28, 13};
    private boolean somWritten;

    public MLLPOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.writeStartBlock();
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.writeStartBlock();
        this.out.write(b, off, len);
    }

    public void writeMessage(byte[] b) throws IOException {
        this.writeMessage(b, 0, b.length);
    }

    public synchronized void writeMessage(byte[] b, int off, int len) throws IOException {
        if (this.somWritten) {
            throw new IllegalStateException();
        }
        byte[] msg = new byte[len + 3];
        msg[0] = 11;
        System.arraycopy(b, off, msg, 1, len);
        System.arraycopy(EOM, 0, msg, len + 1, 2);
        this.out.write(msg);
        this.out.flush();
    }

    private void writeStartBlock() throws IOException {
        if (!this.somWritten) {
            this.out.write(11);
            this.somWritten = true;
        }
    }

    public synchronized void finish() throws IOException {
        if (!this.somWritten) {
            throw new IllegalStateException();
        }
        this.out.write(EOM);
        this.out.flush();
        this.somWritten = false;
    }
}

