/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.Serializable;
import java.text.ParsePosition;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.image.metric.internal.hl7.HL7Segment;

public class UnparsedHL7Message
implements Serializable {
    private static final AtomicInteger prevSerialNo = new AtomicInteger();
    private final int serialNo = prevSerialNo.incrementAndGet();
    private final byte[] data;
    private transient HL7Segment msh;
    private transient int mshLength;

    public UnparsedHL7Message(byte[] data) {
        this.data = data;
    }

    public HL7Segment msh() {
        this.init();
        return this.msh;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    private void init() {
        if (null == this.msh) {
            ParsePosition pos = new ParsePosition(0);
            this.msh = HL7Segment.parseMSH(this.data, this.data.length, pos);
            this.mshLength = pos.getIndex();
        }
    }

    public byte[] data() {
        return this.data;
    }
}

