/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.nimble.ColorSubsampling;
import org.aoju.bus.image.nimble.PaletteColorModel;
import org.aoju.bus.image.nimble.SampledColorModel;
import org.aoju.bus.image.nimble.YBR;
import org.aoju.bus.image.nimble.YBRColorSpace;

public class ColorModelFactory {
    public static ColorModel createMonochromeColorModel(int bits, int dataType) {
        return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bits}, false, false, 1, dataType);
    }

    public static ColorModel createPaletteColorModel(int bits, int dataType, Attributes ds) {
        return new PaletteColorModel(bits, dataType, ColorModelFactory.createRGBColorSpace(ds), ds);
    }

    public static ColorModel createRGBColorModel(int bits, int dataType, Attributes ds) {
        return new ComponentColorModel(ColorModelFactory.createRGBColorSpace(ds), new int[]{bits, bits, bits}, false, false, 1, dataType);
    }

    public static ColorModel createYBRFullColorModel(int bits, int dataType, Attributes ds) {
        return new ComponentColorModel(new YBRColorSpace(ColorModelFactory.createRGBColorSpace(ds), YBR.FULL), new int[]{bits, bits, bits}, false, false, 1, dataType);
    }

    public static ColorModel createYBRColorModel(int bits, int dataType, Attributes ds, YBR ybr, ColorSubsampling subsampling) {
        return new SampledColorModel(new YBRColorSpace(ColorModelFactory.createRGBColorSpace(ds), ybr), subsampling);
    }

    private static ColorSpace createRGBColorSpace(Attributes ds) {
        return ColorModelFactory.createRGBColorSpace(ds.getSafeBytes(0x282000));
    }

    private static ColorSpace createRGBColorSpace(byte[] iccProfile) {
        if (null != iccProfile && iccProfile.length > 0) {
            return new ICC_ColorSpace(ICC_Profile.getInstance(iccProfile));
        }
        return ColorSpace.getInstance(1000);
    }
}

