/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.nimble.Photometric;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageReaderFactory;
import org.aoju.bus.image.nimble.codec.TransferSyntaxType;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLSImageInputStream;
import org.aoju.bus.image.nimble.stream.SegmentedImageStream;
import org.aoju.bus.logger.Logger;

public class Decompressor {
    protected final Attributes dataset;
    protected final String tsuid;
    protected final TransferSyntaxType tstype;
    protected Fragments pixeldataFragments;
    protected File file;
    protected int rows;
    protected int cols;
    protected int samples;
    protected Photometric pmi;
    protected Photometric pmiAfterDecompression;
    protected int bitsAllocated;
    protected int bitsStored;
    protected boolean banded;
    protected boolean signed;
    protected int frames;
    protected int frameLength;
    protected int length;
    protected BufferedImage bi;
    protected ImageReader decompressor;
    protected ImageReadParam readParam;
    protected PatchJPEGLS patchJpegLS;
    protected ImageDescriptor imageDescriptor;

    public Decompressor(Attributes dataset, String tsuid) {
        if (null == tsuid) {
            throw new NullPointerException("tsuid");
        }
        this.dataset = dataset;
        this.tsuid = tsuid;
        this.tstype = TransferSyntaxType.forUID(tsuid);
        Object pixeldata = dataset.getValue(2145386512);
        if (null == pixeldata) {
            return;
        }
        if (null == this.tstype) {
            throw new IllegalArgumentException("Unknown Transfer Syntax: " + tsuid);
        }
        this.rows = dataset.getInt(2621456, 0);
        this.cols = dataset.getInt(2621457, 0);
        this.samples = dataset.getInt(0x280002, 0);
        this.pmiAfterDecompression = this.pmi = Photometric.fromString(dataset.getString(2621444, "MONOCHROME2"));
        this.bitsAllocated = dataset.getInt(2621696, 8);
        this.bitsStored = dataset.getInt(2621697, this.bitsAllocated);
        this.banded = dataset.getInt(2621446, 0) != 0;
        this.signed = dataset.getInt(2621699, 0) != 0;
        this.frames = dataset.getInt(0x280008, 1);
        this.frameLength = this.rows * this.cols * this.samples * this.bitsAllocated / 8;
        this.length = this.frameLength * this.frames;
        this.imageDescriptor = new ImageDescriptor(dataset);
        if (pixeldata instanceof Fragments) {
            if (!this.tstype.isPixeldataEncapsulated()) {
                throw new IllegalArgumentException("Encapusulated Pixel Datawith Transfer Syntax: " + tsuid);
            }
            this.pixeldataFragments = (Fragments)pixeldata;
            int numFragments = this.pixeldataFragments.size();
            if (this.frames == 1 ? numFragments < 2 : numFragments != this.frames + 1) {
                throw new IllegalArgumentException("Number of Pixel Data Fragments: " + numFragments + " does not match " + this.frames);
            }
            this.file = ((BulkData)this.pixeldataFragments.get(1)).getFile();
            ImageReaderFactory.ImageReaderParam param = ImageReaderFactory.getImageReaderParam(tsuid);
            if (null == param) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
            }
            this.decompressor = ImageReaderFactory.getImageReader(param);
            Logger.debug("Decompressor: {}", this.decompressor.getClass().getName());
            this.readParam = this.decompressor.getDefaultReadParam();
            this.patchJpegLS = param.patchJPEGLS;
            this.pmiAfterDecompression = this.pmi.isYBR() && TransferSyntaxType.isYBRCompression(tsuid) ? Photometric.RGB : this.pmi;
        } else {
            this.file = ((BulkData)pixeldata).getFile();
        }
    }

    public static boolean decompress(Attributes dataset, String tsuid) {
        return new Decompressor(dataset, tsuid).decompress();
    }

    static int sizeOf(BufferedImage bi) {
        DataBuffer db = bi.getData().getDataBuffer();
        return db.getSize() * db.getNumBanks() * (DataBuffer.getDataTypeSize(db.getDataType()) >>> 3);
    }

    private static void writeTo(Raster raster, OutputStream out) throws IOException {
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                Decompressor.writeTo(sm, ((DataBufferByte)db).getBankData(), out);
                break;
            }
            case 1: {
                Decompressor.writeTo(sm, ((DataBufferUShort)db).getData(), out);
                break;
            }
            case 2: {
                Decompressor.writeTo(sm, ((DataBufferShort)db).getData(), out);
                break;
            }
            case 3: {
                Decompressor.writeTo(sm, ((DataBufferInt)db).getData(), out);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
            }
        }
    }

    private static void writeTo(SampleModel sm, byte[][] bankData, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        ComponentSampleModel csm = (ComponentSampleModel)sm;
        int len = w * csm.getPixelStride();
        int stride = csm.getScanlineStride();
        if (csm.getBandOffsets()[0] != 0) {
            Decompressor.bgr2rgb(bankData[0]);
        }
        for (byte[] b : bankData) {
            int y = 0;
            int off = 0;
            while (y < h) {
                out.write(b, off, len);
                ++y;
                off += stride;
            }
        }
    }

    private static void bgr2rgb(byte[] bs) {
        int i = 0;
        for (int j = 2; j < bs.length; j += 3) {
            byte b = bs[i];
            bs[i] = bs[j];
            bs[j] = b;
            i += 3;
        }
    }

    private static void writeTo(SampleModel sm, short[] data, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((ComponentSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 2];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                short s = data[j++];
                b[i++] = (byte)s;
                b[i++] = (byte)(s >> 8);
            }
            out.write(b);
        }
    }

    private static void writeTo(SampleModel sm, int[] data, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 3];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                int s = data[j++];
                b[i++] = (byte)(s >> 16);
                b[i++] = (byte)(s >> 8);
                b[i++] = (byte)s;
            }
            out.write(b);
        }
    }

    public void dispose() {
        if (null != this.decompressor) {
            this.decompressor.dispose();
        }
        this.decompressor = null;
    }

    public boolean decompress() {
        if (null == this.decompressor) {
            return false;
        }
        if (this.tstype == TransferSyntaxType.RLE) {
            this.bi = this.createBufferedImage(this.bitsStored, true, this.signed);
        }
        this.dataset.setValue(2145386512, VR.OW, new Value(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public byte[] toBytes(VR vr, boolean bigEndian) throws IOException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Decompressor.this.writeTo(out);
                return out.toByteArray();
            }

            @Override
            public void writeTo(ImageOutputStream out, VR vr) throws IOException {
                Decompressor.this.writeTo(out);
            }

            @Override
            public int calcLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
                return this.getEncodedLength(encOpts, explicitVR, vr);
            }

            @Override
            public int getEncodedLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
                return Decompressor.this.length + 1 & 0xFFFFFFFE;
            }
        });
        if (this.samples > 1) {
            this.dataset.setString(2621444, VR.CS, this.pmiAfterDecompression.toString());
            this.dataset.setInt(2621446, VR.US, this.tstype.getPlanarConfiguration());
        }
        return true;
    }

    protected BufferedImage createBufferedImage(int bitsStored, boolean banded, boolean signed) {
        int dataType = this.bitsAllocated > 8 ? (signed ? 2 : 1) : 0;
        ComponentColorModel cm = this.samples == 1 ? new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bitsStored}, false, false, 1, dataType) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{bitsStored, bitsStored, bitsStored}, false, false, 1, dataType);
        ComponentSampleModel sm = banded ? new BandedSampleModel(dataType, this.cols, this.rows, this.samples) : new PixelInterleavedSampleModel(dataType, this.cols, this.rows, this.samples, this.cols * this.samples, this.bandOffsets());
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        return new BufferedImage(cm, raster, false, null);
    }

    private int[] bandOffsets() {
        int[] offsets = new int[this.samples];
        for (int i = 0; i < this.samples; ++i) {
            offsets[i] = i;
        }
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        FileImageInputStream iis = this.createImageInputStream();
        try {
            for (int i = 0; i < this.frames; ++i) {
                this.writeFrameTo(iis, i, out);
            }
            if ((this.length & 1) != 0) {
                out.write(0);
            }
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException iOException) {}
            this.decompressor.dispose();
        }
    }

    public FileImageInputStream createImageInputStream() throws IOException {
        return new FileImageInputStream(this.file);
    }

    public void writeFrameTo(ImageInputStream iis, int frameIndex, OutputStream out) throws IOException {
        Decompressor.writeTo(this.decompressFrame(iis, frameIndex).getRaster(), out);
    }

    protected BufferedImage decompressFrame(ImageInputStream iis, int index) throws IOException {
        SegmentedImageStream siis = new SegmentedImageStream(iis, this.pixeldataFragments, index);
        siis.setImageDescriptor(this.imageDescriptor);
        this.decompressor.setInput(null != this.patchJpegLS ? new PatchJPEGLSImageInputStream(siis, this.patchJpegLS) : siis);
        this.readParam.setDestination(this.bi);
        long start = System.currentTimeMillis();
        this.bi = this.decompressor.read(0, this.readParam);
        long end = System.currentTimeMillis();
        Logger.debug("Decompressed frame #{} 1:{} in {} ms", index + 1, Float.valueOf((float)Decompressor.sizeOf(this.bi) / (float)siis.getStreamPosition()), end - start);
        return this.bi;
    }
}

