/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class TiledProcessor {
    public Mat blur(Mat input, int numberOfTimes) {
        Mat destImage = input.clone();
        for (int i = 0; i < numberOfTimes; ++i) {
            Mat sourceImage = destImage.clone();
            this.process(sourceImage, destImage, 256);
        }
        return destImage;
    }

    public void process(Mat sourceImage, Mat resultImage, int tileSize) {
        if (sourceImage.rows() != resultImage.rows() || sourceImage.cols() != resultImage.cols()) {
            throw new IllegalStateException("");
        }
        int rowTiles = sourceImage.rows() / tileSize + (sourceImage.rows() % tileSize != 0 ? 1 : 0);
        int colTiles = sourceImage.cols() / tileSize + (sourceImage.cols() % tileSize != 0 ? 1 : 0);
        Mat tileInput = new Mat(tileSize, tileSize, sourceImage.type());
        Mat tileOutput = new Mat(tileSize, tileSize, sourceImage.type());
        int boderType = 4;
        int mPadding = 3;
        for (int rowTile = 0; rowTile < rowTiles; ++rowTile) {
            for (int colTile = 0; colTile < colTiles; ++colTile) {
                Rect srcTile = new Rect(colTile * tileSize - mPadding, rowTile * tileSize - mPadding, tileSize + 2 * mPadding, tileSize + 2 * mPadding);
                Rect dstTile = new Rect(colTile * tileSize, rowTile * tileSize, tileSize, tileSize);
                this.copyTileFromSource(sourceImage, tileInput, srcTile, boderType);
                this.processTileImpl(tileInput, tileOutput);
                this.copyTileToResultImage(tileOutput, resultImage, new Rect(mPadding, mPadding, tileSize, tileSize), dstTile);
            }
        }
    }

    private void copyTileToResultImage(Mat tileOutput, Mat resultImage, Rect srcTile, Rect dstTile) {
        Point br = dstTile.br();
        if (br.x >= (double)resultImage.cols()) {
            dstTile.width = (int)((double)dstTile.width - (br.x - (double)resultImage.cols()));
            srcTile.width = (int)((double)srcTile.width - (br.x - (double)resultImage.cols()));
        }
        if (br.y >= (double)resultImage.rows()) {
            dstTile.height = (int)((double)dstTile.height - (br.y - (double)resultImage.rows()));
            srcTile.height = (int)((double)srcTile.height - (br.y - (double)resultImage.rows()));
        }
        Mat tileView = tileOutput.submat(srcTile);
        Mat dstView = resultImage.submat(dstTile);
        assert (tileView.rows() == dstView.rows());
        assert (tileView.cols() == dstView.cols());
        tileView.copyTo(dstView);
    }

    private void processTileImpl(Mat tileInput, Mat tileOutput) {
        Imgproc.blur((Mat)tileInput, (Mat)tileOutput, (Size)new Size(7.0, 7.0));
    }

    private void copyTileFromSource(Mat sourceImage, Mat tileInput, Rect tile, int mBorderType) {
        Point tl = tile.tl();
        Point br = tile.br();
        Point tloffset = new Point();
        Point broffset = new Point();
        if (tile.x < 0) {
            tloffset.x = -tile.x;
            tile.x = 0;
        }
        if (tile.y < 0) {
            tloffset.y = -tile.y;
            tile.y = 0;
        }
        if (br.x >= (double)sourceImage.cols()) {
            broffset.x = br.x - (double)sourceImage.cols() + 1.0;
            tile.width = (int)((double)tile.width - broffset.x);
        }
        if (br.y >= (double)sourceImage.rows()) {
            broffset.y = br.y - (double)sourceImage.rows() + 1.0;
            tile.height = (int)((double)tile.height - broffset.y);
        }
        if (tloffset.x > 0.0 || tloffset.y > 0.0 || broffset.x > 0.0 || broffset.y > 0.0) {
            Rect paddedTile = new Rect(tile.tl(), tile.br());
            assert (paddedTile.x >= 0);
            assert (paddedTile.y >= 0);
            assert (paddedTile.br().x < (double)sourceImage.cols());
            assert (paddedTile.br().y < (double)sourceImage.rows());
            Core.copyMakeBorder((Mat)sourceImage.submat(paddedTile), (Mat)tileInput, (int)((int)tloffset.y), (int)((int)broffset.y), (int)((int)tloffset.x), (int)((int)broffset.x), (int)mBorderType);
        } else {
            sourceImage.submat(tile).copyTo(tileInput);
        }
    }
}

