/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Date;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.galaxy.io.SAXTransformer;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.acquire.HL7DeviceExtension;
import org.aoju.bus.image.metric.internal.hl7.ERRSegment;
import org.aoju.bus.image.metric.internal.hl7.HL7Application;
import org.aoju.bus.image.metric.internal.hl7.HL7Charset;
import org.aoju.bus.image.metric.internal.hl7.HL7ContentHandler;
import org.aoju.bus.image.metric.internal.hl7.HL7Exception;
import org.aoju.bus.image.metric.internal.hl7.HL7Message;
import org.aoju.bus.image.metric.internal.hl7.HL7MessageListener;
import org.aoju.bus.image.metric.internal.hl7.HL7Parser;
import org.aoju.bus.image.metric.internal.hl7.HL7Segment;
import org.aoju.bus.image.metric.internal.hl7.UnparsedHL7Message;
import org.aoju.bus.logger.Logger;

public class HL7Rcv {
    private static final SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
    private final Device device = new Device("hl7rcv");
    private final HL7DeviceExtension hl7Ext = new HL7DeviceExtension();
    private final HL7Application hl7App = new HL7Application("*");
    private final Connection conn = new Connection();
    private String storageDir;
    private String charset;
    private Templates tpls;
    private String[] xsltParams;
    private final HL7MessageListener handler = (hl7App, conn, s, msg) -> {
        try {
            return this.onMessage(msg);
        }
        catch (Exception e) {
            throw new HL7Exception(new ERRSegment(msg.msh()).setUserMessage(e.getMessage()), (Throwable)e);
        }
    };

    public HL7Rcv() {
        this.conn.setProtocol(Connection.Protocol.HL7);
        this.device.addDeviceExtension(this.hl7Ext);
        this.device.addConnection(this.conn);
        this.hl7Ext.addHL7Application(this.hl7App);
        this.hl7App.setAcceptedMessageTypes("*");
        this.hl7App.addConnection(this.conn);
        this.hl7App.setHL7MessageListener(this.handler);
    }

    public void setStorageDirectory(String storageDir) {
        this.storageDir = storageDir;
    }

    public void setXSLT(URL xslt) throws Exception {
        this.tpls = SAXTransformer.newTemplates(new StreamSource(xslt.openStream(), xslt.toExternalForm()));
    }

    public void setXSLTParameters(String[] xsltParams) {
        this.xsltParams = xsltParams;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    private UnparsedHL7Message onMessage(UnparsedHL7Message msg) throws Exception {
        if (null != this.storageDir) {
            this.storeToFile(msg.data(), new File(new File(this.storageDir, msg.msh().getMessageType()), msg.msh().getField(9, "_NULL_")));
        }
        return new UnparsedHL7Message(null == this.tpls ? HL7Message.makeACK(msg.msh(), "AA", null).getBytes(null) : this.xslt(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToFile(byte[] data, File f) throws IOException {
        Logger.info("M-WRITE {}", f);
        f.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(data);
        }
    }

    private byte[] xslt(UnparsedHL7Message msg) throws Exception {
        String charsetName = HL7Charset.toCharsetName(msg.msh().getField(17, this.charset));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerHandler th = factory.newTransformerHandler(this.tpls);
        Transformer t = th.getTransformer();
        t.setParameter("MessageControlID", HL7Segment.nextMessageControlID());
        t.setParameter("DateTimeOfMessage", HL7Segment.timeStamp(new Date()));
        if (null != this.xsltParams) {
            for (int i = 1; i < this.xsltParams.length; ++i) {
                t.setParameter(this.xsltParams[i - 1], this.xsltParams[i]);
                ++i;
            }
        }
        th.setResult(new SAXResult(new HL7ContentHandler(new OutputStreamWriter((OutputStream)out, charsetName))));
        new HL7Parser(th).parse(new InputStreamReader((InputStream)new ByteArrayInputStream(msg.data()), charsetName));
        return out.toByteArray();
    }

    public Device getDevice() {
        return this.device;
    }

    public Connection getConn() {
        return this.conn;
    }
}

