/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.generic;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Property;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.generic.GenericProperty;

public class GenericEmailProvider
extends AbstractProvider<GenericProperty, Context> {
    public GenericEmailProvider(Context properties) {
        super(properties);
    }

    @Override
    public org.aoju.bus.notify.magic.Message send(GenericProperty entity) {
        try {
            Transport.send((Message)this.build(entity));
        }
        catch (MessagingException e) {
            String message = e.getMessage();
            if (e instanceof SendFailedException) {
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                message = StringKit.format((CharSequence)"Invalid Addresses: {}", ArrayKit.toString(invalidAddresses));
            }
            Logger.error(message, new Object[0]);
        }
        return org.aoju.bus.notify.magic.Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }

    public InternetAddress[] getAddress(String address, Charset charset) {
        InternetAddress[] addresses;
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new InternalException(e);
        }
        if (ArrayKit.isNotEmpty(addresses)) {
            for (InternetAddress internetAddress : addresses) {
                try {
                    internetAddress.setPersonal(internetAddress.getPersonal(), charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException(e);
                }
            }
        }
        return addresses;
    }

    private InternetAddress[] getAddress(String[] address, Charset charset) {
        ArrayList<InternetAddress> resultList = new ArrayList<InternetAddress>(address.length);
        for (int i = 0; i < address.length; ++i) {
            InternetAddress[] addrs = this.getAddress(address[i], charset);
            if (!ArrayKit.isNotEmpty(addrs)) continue;
            for (int j = 0; j < addrs.length; ++j) {
                resultList.add(addrs[j]);
            }
        }
        return resultList.toArray(new InternetAddress[resultList.size()]);
    }

    private InternetAddress getFirstAddress(String address, Charset charset) {
        InternetAddress[] internetAddresses = this.getAddress(address, charset);
        if (ArrayKit.isEmpty(internetAddresses)) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException e) {
                throw new InternalException(e);
            }
        }
        return internetAddresses[0];
    }

    private MimeMessage build(GenericProperty entity) throws MessagingException {
        entity.defaultIfEmpty();
        Charset charset = entity.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession(entity));
        String from = entity.getSender();
        if (StringKit.isEmpty(from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)this.getFirstAddress(from, charset));
        }
        msg.setSubject(entity.getTitle(), charset.name());
        msg.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)entity.getContent(), StringKit.format((CharSequence)"text/{}; charset={}", Property.Type.HTML.equals((Object)entity.getType()) ? "html" : "plain", entity.getCharset()));
        mainPart.addBodyPart((BodyPart)body);
        if (ArrayKit.isNotEmpty(entity.getAttachments())) {
            for (File file : entity.getAttachments()) {
                FileDataSource dataSource = new FileDataSource(file);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                try {
                    bodyPart.setFileName(MimeUtility.encodeText((String)dataSource.getName(), (String)entity.getCharset().name(), null));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                mainPart.addBodyPart((BodyPart)bodyPart);
            }
        }
        msg.setContent((Multipart)mainPart);
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getReceive(), ","), charset));
        if (StringKit.isNotEmpty(entity.getCcs())) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getCcs(), ","), charset));
        }
        if (StringKit.isNotEmpty(entity.getBccs())) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])this.getAddress(StringKit.splitToArray((CharSequence)entity.getBccs(), ","), charset));
        }
        return msg;
    }

    private Session getSession(GenericProperty template) {
        UserPassAuthenticator authenticator = null;
        if (template.getAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(template.getUser(), template.getPass());
        }
        return template.isUseGlobalSession() ? Session.getDefaultInstance((Properties)template.getSmtpProps(), authenticator) : Session.getInstance((Properties)template.getSmtpProps(), authenticator);
    }

    class UserPassAuthenticator
    extends Authenticator {
        private final String user;
        private final String pass;

        public UserPassAuthenticator(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

