/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel.cell.setters;

import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.office.excel.cell.CellSetter;
import org.aoju.bus.office.excel.cell.setters.BooleanCellSetter;
import org.aoju.bus.office.excel.cell.setters.CalendarCellSetter;
import org.aoju.bus.office.excel.cell.setters.CharSequenceCellSetter;
import org.aoju.bus.office.excel.cell.setters.DateCellSetter;
import org.aoju.bus.office.excel.cell.setters.HyperlinkCellSetter;
import org.aoju.bus.office.excel.cell.setters.NullCellSetter;
import org.aoju.bus.office.excel.cell.setters.NumberCellSetter;
import org.aoju.bus.office.excel.cell.setters.RichTextCellSetter;
import org.aoju.bus.office.excel.cell.setters.TemporalAccessorCellSetter;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;

public class CellSetterFactory {
    public static CellSetter createCellSetter(Object value) {
        if (null == value) {
            return NullCellSetter.INSTANCE;
        }
        if (value instanceof CellSetter) {
            return (CellSetter)value;
        }
        if (value instanceof Date) {
            return new DateCellSetter((Date)value);
        }
        if (value instanceof TemporalAccessor) {
            return new TemporalAccessorCellSetter((TemporalAccessor)value);
        }
        if (value instanceof Calendar) {
            return new CalendarCellSetter((Calendar)value);
        }
        if (value instanceof Boolean) {
            return new BooleanCellSetter((Boolean)value);
        }
        if (value instanceof RichTextString) {
            return new RichTextCellSetter((RichTextString)value);
        }
        if (value instanceof Number) {
            return new NumberCellSetter((Number)value);
        }
        if (value instanceof Hyperlink) {
            return new HyperlinkCellSetter((Hyperlink)value);
        }
        return new CharSequenceCellSetter(value.toString());
    }
}

