/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel.reader;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.office.excel.reader.AbstractSheetReader;
import org.apache.poi.ss.usermodel.Sheet;

public class ListSheetReader
extends AbstractSheetReader<List<List<Object>>> {
    private final boolean aliasFirstLine;

    public ListSheetReader(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        super(startRowIndex, endRowIndex);
        this.aliasFirstLine = aliasFirstLine;
    }

    @Override
    public List<List<Object>> read(Sheet sheet) {
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        int startRowIndex = Math.max(this.startRowIndex, sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.endRowIndex, sheet.getLastRowNum());
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(sheet, i);
            if (!CollKit.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (this.aliasFirstLine && i == startRowIndex) {
                rowList = Convert.toList(Object.class, this.aliasHeader(rowList));
            }
            resultList.add(rowList);
        }
        return resultList;
    }
}

