/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider;

import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.PageException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.Builder;
import org.aoju.bus.pay.Context;
import org.aoju.bus.pay.Provider;
import org.aoju.bus.pay.Registry;
import org.aoju.bus.pay.metric.PayCache;

public abstract class AbstractProvider
implements Provider {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    protected Context context;
    protected Registry source;
    protected ExtendCache extendCache;

    public AbstractProvider(Context context, Registry source) {
        this(context, source, PayCache.INSTANCE);
    }

    public AbstractProvider(Context context, Registry source, ExtendCache extendCache) {
        this.context = context;
        this.source = source;
        this.extendCache = extendCache;
        if (!AbstractProvider.isSupport(context, source)) {
            throw new PageException(Builder.ErrorCode.PARAMETER_INCOMPLETE.getCode());
        }
        AbstractProvider.checkContext(context, source);
    }

    public static boolean isSupport(Context context, Registry source) {
        boolean isSupported = StringKit.isNotEmpty(context.getAppKey()) && StringKit.isNotEmpty(context.getAppSecret());
        return isSupported;
    }

    public static void checkContext(Context context, Registry source) {
    }

    public static void remove() {
        TL.remove();
    }

    public void put(Context context) {
        this.extendCache.cache(context.getAppId(), context);
    }

    public void remove(String appId) {
        this.extendCache.remove(appId);
    }

    public void setThread(Context context) {
        if (StringKit.isNotEmpty(Context.getAppId())) {
            this.setThread(Context.getAppId());
        }
        this.put(context);
    }

    public void setThread(String appId) {
        if (StringKit.isEmpty(appId)) {
            appId = (String)this.extendCache.get(appId);
        }
        TL.set(appId);
    }

    public String getAppId() {
        String appId = TL.get();
        if (StringKit.isEmpty(appId)) {
            this.context = this.getContext(appId);
        }
        AbstractProvider abstractProvider = this;
        return abstractProvider.context.getAppId();
    }

    public Context getContext(String appId) {
        Context context = (Context)this.extendCache.get(appId);
        if (context == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 AliPayApiConfigKit.putApiConfig(aliPayApiConfig) \u5c06 appId\u5bf9\u5e94\u7684 aliPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 AliPayApiConfigKit.getAliPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return context;
    }
}

