/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.UdpChannel;
import org.aoju.bus.socket.buffers.BufferPage;
import org.aoju.bus.socket.buffers.VirtualBuffer;
import org.aoju.bus.socket.buffers.WriteBuffer;

public class UdpAioSession
extends AioSession {
    private final UdpChannel udpChannel;
    private final SocketAddress remote;
    private final WriteBuffer writeBuffer;

    UdpAioSession(UdpChannel udpChannel, SocketAddress remote, BufferPage bufferPage) {
        this.udpChannel = udpChannel;
        this.remote = remote;
        Consumer<WriteBuffer> consumer = var -> {
            VirtualBuffer writeBuffer = var.poll();
            if (writeBuffer != null) {
                udpChannel.write(writeBuffer, this);
            }
        };
        this.writeBuffer = new WriteBuffer(bufferPage, consumer, udpChannel.config.getWriteBufferSize(), 1);
        udpChannel.config.getProcessor().stateEvent(this, SocketStatus.NEW_SESSION, null);
    }

    @Override
    public WriteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    public ByteBuffer readBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void signalRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(boolean immediate) {
        this.writeBuffer.flush();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.udpChannel.getChannel().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.remote;
    }
}

