/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.bridge;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import jakarta.annotation.Resource;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.bridge.BridgeProperties;
import org.aoju.bus.starter.bridge.Resolvable;

public class BridgeVerticleService
extends AbstractVerticle {
    @Resource
    Resolvable resolvable;
    @Resource
    Vertx vertx;
    private final BridgeProperties properties;

    public BridgeVerticleService(BridgeProperties properties) {
        this.properties = properties;
    }

    public void start() {
        if (this.properties.getPort() <= 0 || this.properties.getPort() > 65535) {
            return;
        }
        Router router = Router.router((Vertx)this.vertx);
        router.route("/profile/get").handler(context -> {
            String result;
            try {
                BridgeProperties properties = JsonKit.toPojo(context.getBodyAsString(), BridgeProperties.class);
                Message message = Message.builder().data(this.resolvable.find(properties)).build();
                Logger.info("request:{},response:{}", properties, message);
                result = JsonKit.toJsonString(message);
            }
            catch (Exception e) {
                Logger.error("get error", e);
                result = JsonKit.toJsonString(Message.builder().errcode("-1").build());
            }
            context.response().putHeader("Content-Type", "application/json").end(result);
        });
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(this.properties.getPort());
        Logger.info("Vert.x is listening {}", this.properties.getPort());
    }

    public void stop() {
        if (ObjectKit.isNotEmpty(this.vertx)) {
            this.vertx.close();
        }
    }
}

