/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.storage;

import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.starter.storage.StorageProperties;
import org.aoju.bus.starter.storage.StorageProviderService;
import org.aoju.bus.storage.metric.StorageCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    @Bean
    public StorageProviderService storageProviderFactory(StorageProperties properties, ExtendCache extendCache) {
        return new StorageProviderService(properties, extendCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExtendCache.class})
    @ConditionalOnProperty(name={"extend.storage.cache.type"}, havingValue="default", matchIfMissing=true)
    public ExtendCache storageCache() {
        return StorageCache.INSTANCE;
    }
}

