/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Platform;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Page;
import org.aoju.lancia.Puppeteer;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.EventHandler;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.browser.Context;
import org.aoju.lancia.kernel.browser.Fetcher;
import org.aoju.lancia.kernel.page.Target;
import org.aoju.lancia.kernel.page.TargetInfo;
import org.aoju.lancia.kernel.page.TaskQueue;
import org.aoju.lancia.kernel.page.Viewport;
import org.aoju.lancia.nimble.targets.TargetCreatedPayload;
import org.aoju.lancia.nimble.targets.TargetDestroyedPayload;
import org.aoju.lancia.nimble.targets.TargetInfoChangedPayload;
import org.aoju.lancia.option.ChromeArgOptions;
import org.aoju.lancia.option.LaunchOptions;
import org.aoju.lancia.option.LaunchOptionsBuilder;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.exception.TimeoutException;

public class Browser
extends EventEmitter {
    public static Browser INSTANCE;
    private final Connection connection;
    private final boolean ignoreHTTPSErrors;
    private final Viewport viewport;
    private final Map<String, Target> targets;
    private final Context defaultContext;
    private final Map<String, Context> contexts;
    private final Process process;
    private final TaskQueue<String> screenshotTaskQueue;
    private final Function<Object, Object> closeCallback;

    public Browser(Connection connection, List<String> contextIds, boolean ignoreHTTPSErrors, Viewport defaultViewport, Process process, Function<Object, Object> closeCallback) {
        this.ignoreHTTPSErrors = ignoreHTTPSErrors;
        this.viewport = defaultViewport;
        this.process = process;
        this.screenshotTaskQueue = new TaskQueue();
        this.connection = connection;
        if (closeCallback == null) {
            closeCallback = o -> null;
        }
        this.closeCallback = closeCallback;
        this.defaultContext = new Context(connection, this, "");
        this.contexts = new HashMap<String, Context>();
        if (CollKit.isNotEmpty(contextIds)) {
            for (String contextId : contextIds) {
                this.contexts.putIfAbsent(contextId, new Context(this.connection, this, contextId));
            }
        }
        this.targets = new ConcurrentHashMap<String, Target>();
        DefaultBrowserListener<Object> disconnectedLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Browser browser = (Browser)this.getTarget();
                browser.emit(Events.BROWSER_DISCONNECTED.getName(), null);
            }
        };
        disconnectedLis.setTarget(this);
        disconnectedLis.setMethod(Events.CONNECTION_DISCONNECTED.getName());
        this.connection.addListener(disconnectedLis.getMethod(), disconnectedLis);
        DefaultBrowserListener<TargetCreatedPayload> targetCreatedLis = new DefaultBrowserListener<TargetCreatedPayload>(){

            @Override
            public void onBrowserEvent(TargetCreatedPayload event) {
                Browser browser = (Browser)this.getTarget();
                browser.targetCreated(event);
            }
        };
        targetCreatedLis.setTarget(this);
        targetCreatedLis.setMethod("Target.targetCreated");
        this.connection.addListener(targetCreatedLis.getMethod(), targetCreatedLis);
        DefaultBrowserListener<TargetDestroyedPayload> targetDestroyedLis = new DefaultBrowserListener<TargetDestroyedPayload>(){

            @Override
            public void onBrowserEvent(TargetDestroyedPayload event) {
                Browser browser = (Browser)this.getTarget();
                browser.targetDestroyed(event);
            }
        };
        targetDestroyedLis.setTarget(this);
        targetDestroyedLis.setMethod("Target.targetDestroyed");
        this.connection.addListener(targetDestroyedLis.getMethod(), targetDestroyedLis);
        DefaultBrowserListener<TargetInfoChangedPayload> targetInfoChangedLis = new DefaultBrowserListener<TargetInfoChangedPayload>(){

            @Override
            public void onBrowserEvent(TargetInfoChangedPayload event) {
                Browser browser = (Browser)this.getTarget();
                browser.targetInfoChanged(event);
            }
        };
        targetInfoChangedLis.setTarget(this);
        targetInfoChangedLis.setMethod("Target.targetInfoChanged");
        this.connection.addListener(targetInfoChangedLis.getMethod(), targetInfoChangedLis);
    }

    public static Browser create(Connection connection, List<String> contextIds, boolean ignoreHTTPSErrors, Viewport viewport, Process process, Function<Object, Object> closeCallback) {
        Browser browser = new Browser(connection, contextIds, ignoreHTTPSErrors, viewport, process, closeCallback);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("discover", true);
        connection.send("Target.setDiscoverTargets", params, false);
        return browser;
    }

    public static Browser newInstance() {
        return Browser.newInstance("818858");
    }

    public static Browser newInstance(String version) {
        return Browser.newInstance(version, null);
    }

    public static synchronized Browser newInstance(String version, LaunchOptions options) {
        if (ObjectKit.isEmpty(INSTANCE)) {
            try {
                Fetcher.on(version);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (ObjectKit.isEmpty(options)) {
                options = new LaunchOptions();
                options.setArgs(CollKit.newArrayList("--disable-gpu", "--disable-dev-shm-usage", "--no-first-run", "--no-sandbox", "--disable-setuid-sandbox", "--no-zygote", "--proxy-server='direct://'", "--proxy-bypass-list=*"));
                options.setHeadless(true);
                options.setViewport(null);
                options.setIgnoreHTTPSErrors(true);
                options.setSlowMo(250);
            }
            options = new LaunchOptionsBuilder().args(options.getArgs()).headless(options.getHeadless()).viewport(options.getViewport()).ignoreHTTPSErrors(options.getIgnoreHTTPSErrors()).slowMo(options.getSlowMo()).build();
            try {
                INSTANCE = Puppeteer.launch(options);
                INSTANCE = Puppeteer.connect(INSTANCE.wsEndpoint(), null, null);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), new Object[0]);
                throw new RuntimeException(e);
            }
            LaunchOptions opts = options;
            INSTANCE.onDisconnected(b -> {
                String command = "ps -ef | grep chrome | grep -v \"grep\" | awk '{print $2}' | xargs kill -9";
                if (Platform.isWindows()) {
                    command = "taskkill /f /im chrome.exe";
                }
                try {
                    Process process = Runtime.getRuntime().exec(command);
                    process.waitFor();
                }
                catch (Exception e) {
                    Logger.error(e);
                }
                Browser.newInstance(version, opts);
            });
        }
        return INSTANCE;
    }

    private void targetDestroyed(TargetDestroyedPayload event) {
        Target target = this.targets.remove(event.getTargetId());
        target.initializedCallback(false);
        target.closedCallback();
        if (target.waitInitializedPromise()) {
            this.emit(Events.BROWSER_TARGETDESTROYED.getName(), target);
            target.browserContext().emit(Events.BROWSER_TARGETDESTROYED.getName(), target);
        }
    }

    private void targetInfoChanged(TargetInfoChangedPayload event) {
        Target target = this.targets.get(event.getTargetInfo().getTargetId());
        Assert.isTrue(target != null, "target should exist before targetInfoChanged", new Object[0]);
        String previousURL = target.url();
        boolean wasInitialized = target.getIsInitialized();
        target.targetInfoChanged(event.getTargetInfo());
        if (wasInitialized && !previousURL.equals(target.url())) {
            this.emit(Events.BROWSER_TARGETCHANGED.getName(), target);
            target.browserContext().emit(Events.BROWSERCONTEXT_TARGETCHANGED.getName(), target);
        }
    }

    public String wsEndpoint() {
        return this.connection.url();
    }

    public List<Target> targets() {
        return this.targets.values().stream().filter(Target::getIsInitialized).collect(Collectors.toList());
    }

    public Process process() {
        return this.process;
    }

    public Context createIncognitoBrowserContext() {
        JSONObject result = this.connection.send("Target.createBrowserContext", null, true);
        String browserContextId = result.getString("browserContextId");
        Context context = new Context(this.connection, this, browserContextId);
        this.contexts.put(browserContextId, context);
        return context;
    }

    public void disposeContext(String contextId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("browserContextId", contextId);
        this.connection.send("Target.disposeBrowserContext", params, true);
        this.contexts.remove(contextId);
    }

    protected void targetCreated(TargetCreatedPayload event) {
        TargetInfo targetInfo = event.getTargetInfo();
        Context context = StringKit.isNotEmpty(targetInfo.getBrowserContextId()) && this.contexts().containsKey(targetInfo.getBrowserContextId()) ? this.contexts().get(targetInfo.getBrowserContextId()) : this.defaultBrowserContext();
        Target target = new Target(targetInfo, context, () -> this.getConnection().createSession(targetInfo), this.getIgnoreHTTPSErrors(), this.getViewport(), this.screenshotTaskQueue);
        if (this.targets.get(targetInfo.getTargetId()) != null) {
            throw new RuntimeException("Target should not exist befor targetCreated");
        }
        this.targets.put(targetInfo.getTargetId(), target);
        if (target.waitInitializedPromise()) {
            this.emit(Events.BROWSER_TARGETCREATED.getName(), target);
            context.emit(Events.BROWSERCONTEXT_TARGETCREATED.getName(), target);
        }
    }

    public Target waitForTarget(Predicate<Target> predicate, ChromeArgOptions options) {
        long delay;
        int timeout = options.getTimeout();
        long base = System.currentTimeMillis();
        long now = 0L;
        while ((delay = (long)timeout - now) > 0L) {
            Target existingTarget = this.find(this.targets(), predicate);
            if (null != existingTarget) {
                return existingTarget;
            }
            now = System.currentTimeMillis() - base;
        }
        throw new TimeoutException("waiting for target failed: timeout " + options.getTimeout() + "ms exceeded");
    }

    public Target target() {
        for (Target target : this.targets()) {
            if (!"browser".equals(target.type())) continue;
            return target;
        }
        return null;
    }

    public Collection<Context> browserContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        contexts.add(this.defaultBrowserContext());
        contexts.addAll(this.contexts().values());
        return contexts;
    }

    public List<Page> pages() {
        return this.browserContexts().stream().flatMap(context -> context.pages().stream()).collect(Collectors.toList());
    }

    public String version() {
        JSONObject version = this.getVersion();
        return version.getString("product");
    }

    public String userAgent() {
        JSONObject version = this.getVersion();
        return version.getString("userAgent");
    }

    public void close() {
        this.closeCallback.apply(null);
        this.disconnect();
    }

    public void disconnect() {
        this.connection.dispose();
    }

    private JSONObject getVersion() {
        return this.connection.send("Browser.getVersion", null, true);
    }

    public boolean isConnected() {
        return !this.connection.getClosed();
    }

    private Target find(List<Target> targets, Predicate<Target> predicate) {
        if (CollKit.isNotEmpty(targets)) {
            for (Target target : targets) {
                if (!predicate.test(target)) continue;
                return target;
            }
        }
        return null;
    }

    public Page newPage() {
        return this.defaultContext.newPage();
    }

    public Page createPageInContext(String contextId) {
        JSONObject recevie;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", "about:blank");
        if (StringKit.isNotEmpty(contextId)) {
            params.put("browserContextId", contextId);
        }
        if ((recevie = this.connection.send("Target.createTarget", params, true)) != null) {
            Target target = this.targets.get(recevie.getString("targetId"));
            Assert.isTrue(target.waitInitializedPromise(), "Failed to create target for page", new Object[0]);
            return target.page();
        }
        throw new RuntimeException("can't create new page: ");
    }

    public void onDisconnected(EventHandler<Object> handler) {
        this.on(Events.BROWSER_DISCONNECTED.getName(), handler);
    }

    public void onTargetchanged(EventHandler<Target> handler) {
        this.on(Events.BROWSER_TARGETCHANGED.getName(), handler);
    }

    public void onTargetcreated(EventHandler<Target> handler) {
        this.on(Events.BROWSER_TARGETCREATED.getName(), handler);
    }

    public void onTargetdestroyed(EventHandler<Target> handler) {
        this.on(Events.BROWSER_TARGETDESTROYED.getName(), handler);
    }

    public Map<String, Target> getTargets() {
        return this.targets;
    }

    public Map<String, Context> contexts() {
        return this.contexts;
    }

    public Context defaultBrowserContext() {
        return this.defaultContext;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    private boolean getIgnoreHTTPSErrors() {
        return this.ignoreHTTPSErrors;
    }

    protected Viewport getViewport() {
        return this.viewport;
    }
}

