/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.thread.NamedThreadFactory;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.events.BrowserListenerWrapper;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.kernel.page.QueryHandler;
import org.aoju.lancia.kernel.page.QuerySelector;
import org.aoju.lancia.nimble.PageEvaluateType;
import org.aoju.lancia.nimble.runtime.CallFrame;
import org.aoju.lancia.nimble.runtime.ExceptionDetails;
import org.aoju.lancia.nimble.runtime.RemoteObject;
import org.aoju.lancia.worker.CDPSession;

public class Builder {
    public static final String VERSION = "818858";
    public static final String PROFILE_PREFIX = "puppeteer_dev_chrome_profile-";
    public static final String PUPPETEER_CHROMIUM_REVISION = "PUPPETEER_CHROMIUM_REVISION";
    public static final String[] PRODUCT_ENV = new String[]{"PUPPETEER_PRODUCT", "java_config_puppeteer_product", "java_package_config_puppeteer_product"};
    public static final String[] EXECUTABLE_ENV = new String[]{"PUPPETEER_EXECUTABLE_PATH", "java_config_puppeteer_executable_path", "java_package_config_puppeteer_executable_path"};
    public static final String[] PROBABLE_CHROME_EXECUTABLE_PATH = new String[]{"/usr/bin/chromium", "/usr/bin/chromium-browser", "/usr/bin/google-chrome-stable", "/usr/bin/google-chrome", "/Applications/Chromium.app/Contents/MacOS/Chromium", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary", "C:/Program Files (x86)/Google/Chrome/Application/chrome.exe", "C:/Program Files/Google/Chrome/Application/chrome.exe"};
    public static final List<String> DEFAULT_ARGS = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.addAll(Arrays.asList("--disable-background-networking", "--disable-background-timer-throttling", "--disable-breakpad", "--disable-browser-side-navigation", "--disable-client-side-phishing-detection", "--disable-default-apps", "--disable-dev-shm-usage", "--disable-extensions", "--disable-features=site-per-process", "--disable-hang-monitor", "--disable-popup-blocking", "--disable-prompt-on-repost", "--disable-sync", "--disable-translate", "--metrics-recording-only", "--no-first-run", "--safebrowsing-disable-auto-update", "--enable-automation", "--password-store=basic", "--use-mock-keychain"));
        }
    });
    public static final Set<String> SUPPORTED_METRICS = new HashSet<String>(){
        private static final long serialVersionUID = -5224857570151968464L;
        {
            this.add("Timestamp");
            this.add("Documents");
            this.add("Frames");
            this.add("JSEventListeners");
            this.add("Nodes");
            this.add("LayoutCount");
            this.add("RecalcStyleCount");
            this.add("LayoutDuration");
            this.add("RecalcStyleDuration");
            this.add("ScriptDuration");
            this.add("TaskDuration");
            this.add("JSHeapUsedSize");
            this.add("JSHeapTotalSize");
        }
    };
    public static final Set<String> DEFAULTCATEGORIES = new LinkedHashSet<String>(){
        private static final long serialVersionUID = -5224857570151968464L;
        {
            this.add("-*");
            this.add("devtools.timeline");
            this.add("v8.execute");
            this.add("disabled-by-default-devtools.timeline");
            this.add("disabled-by-default-devtools.timeline.frame");
            this.add("toplevel");
            this.add("blink.console");
            this.add("blink.user_timing");
            this.add("latencyInfo");
            this.add("disabled-by-default-devtools.timeline.stack");
            this.add("disabled-by-default-v8.cpu_profiler");
            this.add("disabled-by-default-v8.cpu_profiler.hires");
        }
    };
    public static final String RECV_MESSAGE_METHOD_PROPERTY = "method";
    public static final String RECV_MESSAGE_PARAMS_PROPERTY = "params";
    public static final String RECV_MESSAGE_ID_PROPERTY = "id";
    public static final String RECV_MESSAGE_RESULT_PROPERTY = "result";
    public static final String RECV_MESSAGE_SESSION_ID_PROPERTY = "sessionId";
    public static final String RECV_MESSAGE_TARGETINFO_PROPERTY = "targetInfo";
    public static final String RECV_MESSAGE_TYPE_PROPERTY = "type";
    public static final String RECV_MESSAGE_ERROR_PROPERTY = "error";
    public static final String RECV_MESSAGE_ERROR_MESSAGE_PROPERTY = "message";
    public static final String RECV_MESSAGE_ERROR_DATA_PROPERTY = "data";
    public static final String RECV_MESSAGE_TARFETINFO_TARGETID_PROPERTY = "targetId";
    public static final String RECV_MESSAGE_STREAM_PROPERTY = "stream";
    public static final String RECV_MESSAGE_STREAM_EOF_PROPERTY = "eof";
    public static final String RECV_MESSAGE_STREAM_DATA_PROPERTY = "data";
    public static final String RECV_MESSAGE_BASE64ENCODED_PROPERTY = "base64Encoded";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String NONE = "NONE";
    public static final String ONEWAY = "ONEWAY";
    public static final String TWOWAY = "TWOWAY";
    public static final String MATCHED = "MATCHED";
    public static final String NOT_MATCHED = "NOT_MATCHED";
    public static final String CONTINUOUS = "CONTINUOUS";
    public static final String TEXT = "TEXT";
    public static final String BINARY = "BINARY";
    public static final String PING = "PING";
    public static final String PONG = "PONG";
    public static final String CLOSING = "CLOSING";
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final String COMMONT_THREAD_POOL_NUM = "common_thread_number";
    public static final int READ_TIME_OUT = 10000;
    public static final int CONNECT_TIME_OUT = 10000;
    public static final Map<String, Map<String, String>> DOWNLOAD_URL = new HashMap<String, Map<String, String>>(){
        private static final long serialVersionUID = -6918778699407093058L;
        {
            this.put("chrome", new HashMap<String, String>(){
                private static final long serialVersionUID = 3441562966233820720L;
                {
                    this.put("host", "https://npm.taobao.org/mirrors");
                    this.put("linux", "%s/chromium-browser-snapshots/Linux_x64/%s/%s.zip");
                    this.put("mac", "%s/chromium-browser-snapshots/Mac/%s/%s.zip");
                    this.put("win32", "%s/chromium-browser-snapshots/Win/%s/%s.zip");
                    this.put("win64", "%s/chromium-browser-snapshots/Win_x64/%s/%s.zip");
                }
            });
            this.put("firefox", new HashMap<String, String>(){
                private static final long serialVersionUID = 2053771138227029401L;
                {
                    this.put("host", "https://github.com/puppeteer/juggler/releases");
                    this.put("linux", "%s/download/%s/%s.zip");
                    this.put("mac", "%s/download/%s/%s.zip");
                    this.put("win32", "%s/download/%s/%s.zip");
                    this.put("win64", "%s/download/%s/%s.zip");
                }
            });
        }
    };
    private static final int THREAD_COUNT = 5;
    private static final int CHUNK_SIZE = 0x500000;
    private static final int RETRY_TIMES = 5;
    private static final String FAIL_RESULT = "-1";
    private static final Map<String, QueryHandler> QUERY_HANDLER = new HashMap<String, QueryHandler>();
    private static ExecutorService COMMON_EXECUTOR = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toString(InputStream in) throws IOException {
        String string;
        StringWriter wirter = null;
        InputStreamReader reader = null;
        try {
            int perReadcount;
            reader = new InputStreamReader(in);
            int bufferSize = 4096;
            char[] buffer = new char[bufferSize];
            wirter = new StringWriter();
            while ((perReadcount = reader.read(buffer, 0, bufferSize)) != -1) {
                wirter.write(buffer, 0, perReadcount);
            }
            string = wirter.toString();
        }
        catch (Throwable throwable) {
            IoKit.close(wirter);
            IoKit.close(reader);
            throw throwable;
        }
        IoKit.close(wirter);
        IoKit.close(reader);
        return string;
    }

    public static boolean assertExecutable(String executablePath) {
        Path path = Paths.get(executablePath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) && Files.isExecutable(path);
    }

    public static void registerCustomQueryHandler(String name, QueryHandler handler) {
        if (QUERY_HANDLER.containsKey(name)) {
            throw new RuntimeException("A custom query handler named " + name + " already exists");
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z]+$");
        Matcher isValidName = pattern.matcher(name);
        if (!isValidName.matches()) {
            throw new IllegalArgumentException("Custom query handler names may only contain [a-zA-Z]");
        }
        QUERY_HANDLER.put(name, handler);
    }

    public static final void unregisterCustomQueryHandler(String name) {
        QUERY_HANDLER.remove(name);
    }

    public static Map<String, QueryHandler> customQueryHandlers() {
        return QUERY_HANDLER;
    }

    public static QuerySelector getQueryHandlerAndSelector(String selector, String defaultQueryHandler) {
        Pattern pattern = Pattern.compile("^[a-zA-Z]+\\/");
        Matcher hasCustomQueryHandler = pattern.matcher(selector);
        if (!hasCustomQueryHandler.find()) {
            return new QuerySelector(selector, new QueryHandler(){

                @Override
                public String queryOne() {
                    return "(element,selector) =>\n      element.querySelector(selector)";
                }

                @Override
                public String queryAll() {
                    return "(element,selector) =>\n      element.querySelectorAll(selector)";
                }
            });
        }
        int index = selector.indexOf("/");
        String name = selector.substring(0, index);
        String updatedSelector = selector.substring(index + 1);
        QueryHandler queryHandler = Builder.customQueryHandlers().get(name);
        if (queryHandler == null) {
            throw new RuntimeException("Query set to use " + name + ", but no query handler of that name was found");
        }
        return new QuerySelector(updatedSelector, queryHandler);
    }

    public static void download(String url, String filePath, BiConsumer<Integer, Integer> progressCallback) throws IOException, ExecutionException, InterruptedException {
        long contentLength = Builder.getContentLength(url);
        long taskCount = contentLength % 0x500000L == 0L ? contentLength / 0x500000L : contentLength / 0x500000L + 1L;
        Builder.createFile(filePath, contentLength);
        ThreadPoolExecutor executor = Builder.getExecutor();
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(executor);
        ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
        int downloadCount = 0;
        if (contentLength <= 0x500000L) {
            Future<String> future = completionService.submit(new DownloadCallable(0L, contentLength, filePath, url));
            futureList.add(future);
        } else {
            int i = 0;
            while ((long)i < taskCount) {
                if ((long)i == taskCount - 1L) {
                    future = completionService.submit(new DownloadCallable((long)i * 0x500000L, contentLength, filePath, url));
                    futureList.add(future);
                } else {
                    future = completionService.submit(new DownloadCallable((long)i * 0x500000L, (long)(i + 1) * 0x500000L, filePath, url));
                    futureList.add(future);
                }
                ++i;
            }
        }
        executor.shutdown();
        for (Future<String> future : futureList) {
            String result = (String)future.get();
            if (FAIL_RESULT.equals(result)) {
                Logger.error("download fail,url:" + url, new Object[0]);
                Files.delete(Paths.get(filePath, new String[0]));
                executor.shutdownNow();
                continue;
            }
            try {
                downloadCount += Integer.parseInt(result);
                if (progressCallback == null) continue;
                progressCallback.accept(downloadCount, (int)(contentLength >> 20));
            }
            catch (Exception e) {
                Logger.error("ProgressCallback has some problem", e);
            }
        }
    }

    public static final long getContentLength(String url) throws IOException {
        URL uuuRl = new URL(url);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)uuuRl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode <= 204) {
                long l = conn.getContentLengthLong();
                return l;
            }
            throw new RuntimeException(url + " responseCode: " + responseCode);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static ThreadPoolExecutor getExecutor() {
        return new ThreadPoolExecutor(5, 5, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static void createFile(String path, long length) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            Builder.createNewFile(file);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
        randomAccessFile.setLength(length);
        randomAccessFile.close();
    }

    public static final void createNewFile(File file) throws IOException {
        if (!file.exists()) {
            Builder.mkdir(file.getParentFile());
            file.createNewFile();
        }
    }

    public static final void mkdir(File parent) {
        if (parent != null && !parent.exists()) {
            Builder.mkdir(parent.getParentFile());
            parent.mkdir();
        }
    }

    public static String createProtocolError(JSONObject node) {
        JSONObject methodNode = node.getJSONObject(RECV_MESSAGE_METHOD_PROPERTY);
        JSONObject errNode = node.getJSONObject(RECV_MESSAGE_ERROR_PROPERTY);
        String errorMsg = errNode.getString(RECV_MESSAGE_ERROR_MESSAGE_PROPERTY);
        String method = "";
        if (methodNode != null) {
            method = methodNode.toJSONString();
        }
        String message = "Protocol error " + method + ": " + errorMsg;
        String dataNode = errNode.getString("data");
        if (dataNode != null) {
            message = message + " " + dataNode;
        }
        return message;
    }

    public static final void chmod(String path, String perms) throws IOException {
        if (StringKit.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        char[] chars = perms.toCharArray();
        if (chars.length != 3) {
            throw new IllegalArgumentException("perms length must be 3");
        }
        Path path1 = Paths.get(path, new String[0]);
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ('1' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('2' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('3' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('4' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
        } else if ('5' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('6' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('7' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ('1' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('2' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else if ('3' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('4' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
        } else if ('5' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('6' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else if ('7' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ('1' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('2' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        } else if ('3' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('4' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        } else if ('5' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('6' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('7' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        Files.setPosixFilePermissions(path1, permissions);
    }

    public static final String join(String root, String ... args) {
        return Paths.get(root, args).toString();
    }

    public static final Object readProtocolStream(CDPSession client, String handler, String path, boolean isSync) throws IOException {
        if (isSync) {
            return Builder.commonExecutor().submit(() -> {
                try {
                    Builder.printPDF(client, handler, path);
                }
                catch (IOException e) {
                    Logger.error("Method readProtocolStream error", e);
                }
            });
        }
        return Builder.printPDF(client, handler, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] printPDF(CDPSession client, String handler, String path) throws IOException {
        byte[] byArray;
        boolean eof = false;
        File file = null;
        BufferedOutputStream writer = null;
        BufferedInputStream reader = null;
        if (StringKit.isNotEmpty(path)) {
            file = new File(path);
            Builder.createNewFile(file);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("handle", handler);
        try {
            if (file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                writer = new BufferedOutputStream(fileOutputStream);
            }
            byte[] buffer = new byte[8192];
            ArrayList<byte[]> bufs = new ArrayList<byte[]>();
            int byteLength = 0;
            while (!eof) {
                JSONObject response = client.send("IO.read", params, true);
                String eofNode = response.getString(RECV_MESSAGE_STREAM_EOF_PROPERTY);
                Boolean base64EncodedNode = response.getBoolean(RECV_MESSAGE_BASE64ENCODED_PROPERTY);
                String dataText = response.getString("data");
                if (StringKit.isNotEmpty(dataText)) {
                    try {
                        byte[] bytes = base64EncodedNode != null && base64EncodedNode != false ? Base64.getDecoder().decode(dataText) : dataText.getBytes();
                        bufs.add(bytes);
                        byteLength += bytes.length;
                        if (file != null) {
                            int read;
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                            reader = new BufferedInputStream(byteArrayInputStream);
                            while ((read = reader.read(buffer, 0, 8192)) != -1) {
                                writer.write(buffer, 0, read);
                                writer.flush();
                            }
                        }
                    }
                    finally {
                        IoKit.close(reader);
                    }
                }
                eof = eofNode == null || Boolean.parseBoolean(eofNode);
            }
            client.send("IO.close", params, true);
            byArray = Builder.getBytes(bufs, byteLength);
        }
        catch (Throwable throwable) {
            IoKit.close(writer);
            IoKit.close(reader);
            throw throwable;
        }
        IoKit.close(writer);
        IoKit.close(reader);
        return byArray;
    }

    private static byte[] getBytes(List<byte[]> bufs, int byteLength) {
        byte[] resultBuf = new byte[byteLength];
        int destPos = 0;
        for (byte[] buf : bufs) {
            System.arraycopy(buf, 0, resultBuf, destPos, buf.length);
            destPos += buf.length;
        }
        return resultBuf;
    }

    public static String getExceptionMessage(ExceptionDetails exceptionDetails) {
        if (exceptionDetails.getException() != null) {
            return StringKit.isNotEmpty(exceptionDetails.getException().getDescription()) ? exceptionDetails.getException().getDescription() : (String)exceptionDetails.getException().getValue();
        }
        String message = exceptionDetails.getText();
        StringBuilder sb = new StringBuilder(message);
        if (exceptionDetails.getStackTrace() != null) {
            for (CallFrame callframe : exceptionDetails.getStackTrace().getCallFrames()) {
                String location = callframe.getUrl() + ":" + callframe.getColumnNumber() + ":" + callframe.getColumnNumber();
                String functionName = StringKit.isNotEmpty(callframe.getFunctionName()) ? callframe.getFunctionName() : "<anonymous>";
                sb.append("\n    at ").append(functionName).append("(").append(location).append(")");
            }
        }
        return sb.toString();
    }

    public static final Set<DefaultBrowserListener> getConcurrentSet() {
        return new CopyOnWriteArraySet<DefaultBrowserListener>();
    }

    public static final <T> BrowserListenerWrapper<T> addEventListener(EventEmitter emitter, String eventName, DefaultBrowserListener<T> handler) {
        emitter.addListener(eventName, handler);
        return new BrowserListenerWrapper<T>(emitter, eventName, handler);
    }

    public static final void removeEventListeners(List<BrowserListenerWrapper> eventListeners) {
        if (CollKit.isEmpty(eventListeners)) {
            return;
        }
        for (int i = 0; i < eventListeners.size(); ++i) {
            BrowserListenerWrapper wrapper = eventListeners.get(i);
            wrapper.getEmitter().removeListener(wrapper.getEventName(), wrapper.getHandler());
        }
    }

    public static final boolean isString(Object value) {
        if (value == null) {
            return false;
        }
        return value.getClass().equals(String.class);
    }

    public static final boolean isNumber(String s) {
        Pattern pattern = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static Object valueFromRemoteObject(RemoteObject remoteObject) {
        Assert.isTrue(StringKit.isEmpty(remoteObject.getObjectId()), "Cannot extract value when objectId is given", new Object[0]);
        if (StringKit.isNotEmpty(remoteObject.getUnserializableValue())) {
            if ("bigint".equals(remoteObject.getType())) {
                return new BigInteger(remoteObject.getUnserializableValue().replace("n", ""));
            }
            switch (remoteObject.getUnserializableValue()) {
                case "-0": {
                    return 0;
                }
                case "NaN": {
                    return "NaN";
                }
                case "Infinity": {
                    return "Infinity";
                }
                case "-Infinity": {
                    return "-Infinity";
                }
            }
            throw new IllegalArgumentException("Unsupported unserializable value: " + remoteObject.getUnserializableValue());
        }
        return remoteObject.getValue();
    }

    public static void releaseObject(CDPSession client, RemoteObject remoteObject, boolean isBlock) {
        if (StringKit.isEmpty(remoteObject.getObjectId())) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objectId", remoteObject.getObjectId());
        try {
            client.send("Runtime.releaseObject", params, isBlock);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object waitForEvent(EventEmitter eventEmitter, String eventName, final Predicate predicate, int timeout, String abortPromise) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final Object[] result = new Object[]{null};
        DefaultBrowserListener listener = new DefaultBrowserListener(){

            @Override
            public void onBrowserEvent(Object event) {
                if (!predicate.test(event)) {
                    return;
                }
                result[0] = event;
                latch.countDown();
            }
        };
        listener.setMethod(eventName);
        BrowserListenerWrapper wrapper = Builder.addEventListener(eventEmitter, eventName, listener);
        try {
            boolean await = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new RuntimeException(abortPromise);
            }
            Object object = result[0];
            return object;
        }
        finally {
            ArrayList<BrowserListenerWrapper> removes = new ArrayList<BrowserListenerWrapper>();
            removes.add(wrapper);
            Builder.removeEventListeners(removes);
        }
    }

    public static final String evaluationString(String fun, PageEvaluateType type, Object ... args) {
        if (PageEvaluateType.STRING.equals((Object)type)) {
            Assert.isTrue(args.length == 0, "Cannot evaluate a string with arguments", new Object[0]);
            return fun;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        for (Object arg : args) {
            if (arg == null) {
                argsList.add("Undefined");
                continue;
            }
            argsList.add(JSON.toJSONString((Object)arg));
        }
        return MessageFormat.format("({0})({1})", fun, String.join((CharSequence)",", argsList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ExecutorService commonExecutor() {
        if (COMMON_EXECUTOR != null) return COMMON_EXECUTOR;
        Class<Builder> clazz = Builder.class;
        synchronized (Builder.class) {
            if (COMMON_EXECUTOR != null) return COMMON_EXECUTOR;
            String customNum = System.getProperty(COMMONT_THREAD_POOL_NUM);
            int threadNum = 0;
            threadNum = StringKit.isNotEmpty(customNum) ? Integer.parseInt(customNum) : Math.max(1, Runtime.getRuntime().availableProcessors());
            COMMON_EXECUTOR = new ThreadPoolExecutor(threadNum, threadNum, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("common-pool-"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return COMMON_EXECUTOR;
        }
    }

    public static final CompletionService completionService() {
        return new ExecutorCompletionService(Builder.commonExecutor());
    }

    public static final boolean isFunction(String pageFunction) {
        return (pageFunction = pageFunction.trim()).startsWith("function") || pageFunction.startsWith("async") || pageFunction.contains("=>");
    }

    public void clearQueryHandlers() {
        QUERY_HANDLER.clear();
    }

    static class DownloadCallable
    implements Callable<String> {
        private final long startPosition;
        private final long endPosition;
        private final String filePath;
        private final String url;

        public DownloadCallable(long startPosition, long endPosition, String filePath, String url) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.filePath = filePath;
            this.url = url;
        }

        /*
         * Exception decompiling
         */
        @Override
        public String call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

