/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ProtocolException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Browser;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.EventHandler;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.browser.Context;
import org.aoju.lancia.kernel.page.Accessibility;
import org.aoju.lancia.kernel.page.Clip;
import org.aoju.lancia.kernel.page.ConsoleMessage;
import org.aoju.lancia.kernel.page.Coverage;
import org.aoju.lancia.kernel.page.Device;
import org.aoju.lancia.kernel.page.Dialog;
import org.aoju.lancia.kernel.page.ElementHandle;
import org.aoju.lancia.kernel.page.EmulationManager;
import org.aoju.lancia.kernel.page.ExecutionContext;
import org.aoju.lancia.kernel.page.FileChooser;
import org.aoju.lancia.kernel.page.Frame;
import org.aoju.lancia.kernel.page.FrameManager;
import org.aoju.lancia.kernel.page.JSHandle;
import org.aoju.lancia.kernel.page.Keyboard;
import org.aoju.lancia.kernel.page.Mouse;
import org.aoju.lancia.kernel.page.NetworkManager;
import org.aoju.lancia.kernel.page.PaperFormats;
import org.aoju.lancia.kernel.page.Request;
import org.aoju.lancia.kernel.page.Response;
import org.aoju.lancia.kernel.page.Target;
import org.aoju.lancia.kernel.page.TaskQueue;
import org.aoju.lancia.kernel.page.TimeoutSettings;
import org.aoju.lancia.kernel.page.Touchscreen;
import org.aoju.lancia.kernel.page.Tracing;
import org.aoju.lancia.kernel.page.Viewport;
import org.aoju.lancia.kernel.page.Worker;
import org.aoju.lancia.nimble.PageEvaluateType;
import org.aoju.lancia.nimble.console.Location;
import org.aoju.lancia.nimble.console.Payload;
import org.aoju.lancia.nimble.dom.Margin;
import org.aoju.lancia.nimble.emulation.MediaFeature;
import org.aoju.lancia.nimble.emulation.ScreenOrientation;
import org.aoju.lancia.nimble.log.DialogType;
import org.aoju.lancia.nimble.log.EntryAddedPayload;
import org.aoju.lancia.nimble.network.Cookie;
import org.aoju.lancia.nimble.network.CookieParam;
import org.aoju.lancia.nimble.network.DeleteCookiesParameters;
import org.aoju.lancia.nimble.page.FileChooserOpenedPayload;
import org.aoju.lancia.nimble.page.GetNavigationHistoryReturnValue;
import org.aoju.lancia.nimble.page.JavascriptDialogOpeningPayload;
import org.aoju.lancia.nimble.page.NavigationEntry;
import org.aoju.lancia.nimble.performance.Metric;
import org.aoju.lancia.nimble.performance.Metrics;
import org.aoju.lancia.nimble.performance.MetricsPayload;
import org.aoju.lancia.nimble.performance.PageMetrics;
import org.aoju.lancia.nimble.runtime.BindingCalledPayload;
import org.aoju.lancia.nimble.runtime.ConsoleAPICalledPayload;
import org.aoju.lancia.nimble.runtime.ExceptionDetails;
import org.aoju.lancia.nimble.runtime.RemoteObject;
import org.aoju.lancia.nimble.runtime.StackTrace;
import org.aoju.lancia.nimble.webAuthn.Credentials;
import org.aoju.lancia.option.ClickOptions;
import org.aoju.lancia.option.ClipOverwrite;
import org.aoju.lancia.option.PDFOptions;
import org.aoju.lancia.option.PageNavigateOptions;
import org.aoju.lancia.option.ScreenshotOptions;
import org.aoju.lancia.option.ScriptTagOptions;
import org.aoju.lancia.option.StyleTagOptions;
import org.aoju.lancia.option.VisionDeficiency;
import org.aoju.lancia.option.WaitForSelectorOptions;
import org.aoju.lancia.worker.CDPSession;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.exception.PageCrashException;
import org.aoju.lancia.worker.exception.TerminateException;
import org.aoju.lancia.worker.exception.TimeoutException;

public class Page
extends EventEmitter {
    private static final ExecutorService reloadExecutor = Executors.newSingleThreadExecutor();
    private static final String ABOUT_BLANK = "about:blank";
    private static final Map<String, Double> unitToPixels = new HashMap<String, Double>(){
        private static final long serialVersionUID = -4861220887908575532L;
        {
            this.put("px", 1.0);
            this.put("in", 96.0);
            this.put("cm", 37.8);
            this.put("mm", 3.78);
        }
    };
    private final Set<FileChooserCallBack> fileChooserInterceptors;
    private final CDPSession client;
    private final Target target;
    private final Keyboard keyboard;
    private final Mouse mouse;
    private final TimeoutSettings timeoutSettings;
    private final Touchscreen touchscreen;
    private final Accessibility accessibility;
    private final FrameManager frameManager;
    private final EmulationManager emulationManager;
    private final Tracing tracing;
    private final Map<String, Function<List<?>, Object>> pageBindings;
    private final Coverage coverage;
    private final TaskQueue<String> screenshotTaskQueue;
    private final Map<String, Worker> workers;
    private boolean closed = false;
    private boolean javascriptEnabled;
    private Viewport viewport;

    public Page(final CDPSession client, Target target, boolean ignoreHTTPSErrors, TaskQueue<String> screenshotTaskQueue) {
        this.client = client;
        this.target = target;
        this.keyboard = new Keyboard(client);
        this.mouse = new Mouse(client, this.keyboard);
        this.timeoutSettings = new TimeoutSettings();
        this.touchscreen = new Touchscreen(client, this.keyboard);
        this.accessibility = new Accessibility(client);
        this.frameManager = new FrameManager(client, this, ignoreHTTPSErrors, this.timeoutSettings);
        this.emulationManager = new EmulationManager(client);
        this.tracing = new Tracing(client);
        this.pageBindings = new HashMap();
        this.coverage = new Coverage(client);
        this.javascriptEnabled = true;
        this.viewport = null;
        this.screenshotTaskQueue = screenshotTaskQueue;
        this.workers = new HashMap<String, Worker>();
        DefaultBrowserListener<Target> attachedListener = new DefaultBrowserListener<Target>(){

            @Override
            public void onBrowserEvent(Target event) {
                Page page = (Page)this.getTarget();
                if (!"worker".equals(event.getTargetInfo().getType())) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("sessionId", event.getSessionId());
                    client.send("Target.detachFromTarget", params, false);
                    return;
                }
                CDPSession session = Connection.fromSession(page.client()).session(event.getSessionId());
                Worker worker = new Worker(session, event.getTargetInfo().getUrl(), page::addConsoleMessage, page::handleException);
                page.workers().putIfAbsent(event.getSessionId(), worker);
                page.emit(Events.PAGE_WORKERCREATED.getName(), worker);
            }
        };
        attachedListener.setMethod("Target.attachedToTarget");
        attachedListener.setTarget(this);
        attachedListener.setResolveType(Target.class);
        this.client.addListener(attachedListener.getMethod(), attachedListener);
        DefaultBrowserListener<Target> detachedListener = new DefaultBrowserListener<Target>(){

            @Override
            public void onBrowserEvent(Target event) {
                Page page = (Page)this.getTarget();
                Worker worker = page.workers().get(event.getSessionId());
                if (worker == null) {
                    return;
                }
                page.emit(Events.PAGE_WORKERDESTROYED.getName(), worker);
                page.workers().remove(event.getSessionId());
            }
        };
        detachedListener.setMethod("Target.detachedFromTarget");
        detachedListener.setTarget(this);
        detachedListener.setResolveType(Target.class);
        this.client.addListener(detachedListener.getMethod(), detachedListener);
        DefaultBrowserListener<Object> frameAttachedListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_FRAMEATTACHED.getName(), event);
            }
        };
        frameAttachedListener.setMethod(Events.FRAME_MANAGER_FRAME_ATTACHED.getName());
        frameAttachedListener.setTarget(this);
        this.frameManager.addListener(frameAttachedListener.getMethod(), frameAttachedListener);
        DefaultBrowserListener<Object> frameDetachedListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_FRAMEDETACHED.getName(), event);
            }
        };
        frameDetachedListener.setMethod(Events.FRAME_MANAGER_FRAME_DETACHED.getName());
        frameDetachedListener.setTarget(this);
        this.frameManager.addListener(frameDetachedListener.getMethod(), frameDetachedListener);
        DefaultBrowserListener<Object> frameNavigatedListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_FRAMENAVIGATED.getName(), event);
            }
        };
        frameNavigatedListener.setMethod(Events.FRAME_MANAGER_FRAME_NAVIGATED.getName());
        frameNavigatedListener.setTarget(this);
        this.frameManager.addListener(frameNavigatedListener.getMethod(), frameNavigatedListener);
        NetworkManager networkManager = this.frameManager.getNetworkManager();
        DefaultBrowserListener<Request> requestLis = new DefaultBrowserListener<Request>(){

            @Override
            public void onBrowserEvent(Request event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_REQUEST.getName(), event);
            }
        };
        requestLis.setMethod(Events.NETWORK_MANAGER_REQUEST.getName());
        requestLis.setTarget(this);
        networkManager.addListener(requestLis.getMethod(), requestLis);
        DefaultBrowserListener<Response> responseLis = new DefaultBrowserListener<Response>(){

            @Override
            public void onBrowserEvent(Response event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_RESPONSE.getName(), event);
            }
        };
        responseLis.setMethod(Events.NETWORK_MANAGER_RESPONSE.getName());
        responseLis.setTarget(this);
        networkManager.addListener(responseLis.getMethod(), responseLis);
        DefaultBrowserListener<Request> requestFailedLis = new DefaultBrowserListener<Request>(){

            @Override
            public void onBrowserEvent(Request event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_REQUESTFAILED.getName(), event);
            }
        };
        requestFailedLis.setMethod(Events.NETWORK_MANAGER_REQUEST_FAILED.getName());
        requestFailedLis.setTarget(this);
        networkManager.addListener(requestFailedLis.getMethod(), requestFailedLis);
        DefaultBrowserListener<Request> requestFinishedLis = new DefaultBrowserListener<Request>(){

            @Override
            public void onBrowserEvent(Request event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_REQUESTFINISHED.getName(), event);
            }
        };
        requestFinishedLis.setMethod(Events.NETWORK_MANAGER_REQUEST_FINISHED.getName());
        requestFinishedLis.setTarget(this);
        networkManager.addListener(requestFinishedLis.getMethod(), requestFinishedLis);
        this.fileChooserInterceptors = new CopyOnWriteArraySet<FileChooserCallBack>();
        DefaultBrowserListener<Object> domContentEventFiredLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_DOMContentLoaded.getName(), event);
            }
        };
        domContentEventFiredLis.setMethod("Page.domContentEventFired");
        domContentEventFiredLis.setTarget(this);
        this.client.addListener(domContentEventFiredLis.getMethod(), domContentEventFiredLis);
        DefaultBrowserListener<Object> loadEventFiredLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.emit(Events.PAGE_LOAD.getName(), event);
            }
        };
        loadEventFiredLis.setMethod("Page.loadEventFired");
        loadEventFiredLis.setTarget(this);
        this.client.addListener(loadEventFiredLis.getMethod(), loadEventFiredLis);
        DefaultBrowserListener<ConsoleAPICalledPayload> consoleAPICalledLis = new DefaultBrowserListener<ConsoleAPICalledPayload>(){

            @Override
            public void onBrowserEvent(ConsoleAPICalledPayload event) {
                Page page = (Page)this.getTarget();
                page.onConsoleAPI(event);
            }
        };
        consoleAPICalledLis.setMethod("Runtime.consoleAPICalled");
        consoleAPICalledLis.setTarget(this);
        this.client.addListener(consoleAPICalledLis.getMethod(), consoleAPICalledLis);
        DefaultBrowserListener<BindingCalledPayload> bindingCalledLis = new DefaultBrowserListener<BindingCalledPayload>(){

            @Override
            public void onBrowserEvent(BindingCalledPayload event) {
                Page page = (Page)this.getTarget();
                page.onBindingCalled(event);
            }
        };
        bindingCalledLis.setMethod("Runtime.bindingCalled");
        bindingCalledLis.setTarget(this);
        this.client.addListener(bindingCalledLis.getMethod(), bindingCalledLis);
        DefaultBrowserListener<JavascriptDialogOpeningPayload> javascriptDialogOpeningLis = new DefaultBrowserListener<JavascriptDialogOpeningPayload>(){

            @Override
            public void onBrowserEvent(JavascriptDialogOpeningPayload event) {
                Page page = (Page)this.getTarget();
                page.onDialog(event);
            }
        };
        javascriptDialogOpeningLis.setMethod("Page.javascriptDialogOpening");
        javascriptDialogOpeningLis.setTarget(this);
        this.client.addListener(javascriptDialogOpeningLis.getMethod(), javascriptDialogOpeningLis);
        DefaultBrowserListener<JSONObject> exceptionThrownLis = new DefaultBrowserListener<JSONObject>(){

            @Override
            public void onBrowserEvent(JSONObject event) {
                Page page = (Page)this.getTarget();
                JSONObject exceptionDetails = event.getJSONObject("exceptionDetails");
                if (exceptionDetails == null) {
                    return;
                }
                ExceptionDetails value = (ExceptionDetails)JSON.toJavaObject((JSON)exceptionDetails, ExceptionDetails.class);
                page.handleException(value);
            }
        };
        exceptionThrownLis.setMethod("Runtime.exceptionThrown");
        exceptionThrownLis.setTarget(this);
        this.client.addListener(exceptionThrownLis.getMethod(), exceptionThrownLis);
        DefaultBrowserListener<Object> targetCrashedLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Page page = (Page)this.getTarget();
                page.onTargetCrashed();
            }
        };
        targetCrashedLis.setMethod("Inspector.targetCrashed");
        targetCrashedLis.setTarget(this);
        this.client.addListener(targetCrashedLis.getMethod(), targetCrashedLis);
        DefaultBrowserListener<MetricsPayload> metricsLis = new DefaultBrowserListener<MetricsPayload>(){

            @Override
            public void onBrowserEvent(MetricsPayload event) {
                Page page = (Page)this.getTarget();
                try {
                    page.emitMetrics(event);
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        metricsLis.setMethod("Inspector.targetCrashed");
        metricsLis.setTarget(this);
        this.client.addListener(metricsLis.getMethod(), metricsLis);
        DefaultBrowserListener<EntryAddedPayload> entryAddedLis = new DefaultBrowserListener<EntryAddedPayload>(){

            @Override
            public void onBrowserEvent(EntryAddedPayload event) {
                Page page = (Page)this.getTarget();
                page.onLogEntryAdded(event);
            }
        };
        entryAddedLis.setMethod("Log.entryAdded");
        entryAddedLis.setTarget(this);
        this.client.addListener(entryAddedLis.getMethod(), entryAddedLis);
        DefaultBrowserListener<FileChooserOpenedPayload> fileChooserOpenedLis = new DefaultBrowserListener<FileChooserOpenedPayload>(){

            @Override
            public void onBrowserEvent(FileChooserOpenedPayload event) {
                Page page = (Page)this.getTarget();
                page.onFileChooser(event);
            }
        };
        fileChooserOpenedLis.setMethod("Page.fileChooserOpened");
        fileChooserOpenedLis.setTarget(this);
        this.client.addListener(fileChooserOpenedLis.getMethod(), fileChooserOpenedLis);
    }

    public static Page create(CDPSession client, Target target, boolean ignoreHTTPSErrors, Viewport viewport, TaskQueue<String> screenshotTaskQueue) throws ExecutionException, InterruptedException {
        Page page = new Page(client, target, ignoreHTTPSErrors, screenshotTaskQueue);
        page.initialize();
        if (viewport != null) {
            page.setViewport(viewport);
        }
        return page;
    }

    public void onClose(EventHandler<Object> handler) {
        this.on(Events.PAGE_CLOSE.getName(), handler);
    }

    public void onConsole(EventHandler<ConsoleMessage> handler) {
        this.on(Events.PAGE_CONSOLE.getName(), handler);
    }

    public void onDialog(EventHandler<Dialog> handler) {
        this.on(Events.PAGE_DIALOG.getName(), handler);
    }

    public void onError(EventHandler<Error> handler) {
        this.on(Events.PAGE_ERROR.getName(), handler);
    }

    public void onFrameattached(EventHandler<Frame> handler) {
        this.on(Events.PAGE_FRAMEATTACHED.getName(), handler);
    }

    public void onFramedetached(EventHandler<Frame> handler) {
        this.on(Events.PAGE_FRAMEDETACHED.getName(), handler);
    }

    public void onFramenavigated(EventHandler<Frame> handler) {
        this.on(Events.PAGE_FRAMENAVIGATED.getName(), handler);
    }

    public void onLoad(EventHandler<Object> handler) {
        this.on(Events.PAGE_LOAD.getName(), handler);
    }

    public void onMetrics(EventHandler<PageMetrics> handler) {
        this.on(Events.PAGE_METRICS.getName(), handler);
    }

    public void onPageerror(EventHandler<RuntimeException> handler) {
        this.on(Events.PAGE_ERROR.getName(), handler);
    }

    public void onPopup(EventHandler<Error> handler) {
        this.on(Events.PAGE_POPUP.getName(), handler);
    }

    public void onRequest(EventHandler<Request> handler) {
        this.on(Events.PAGE_REQUEST.getName(), handler);
    }

    public void onRequestfailed(EventHandler<Request> handler) {
        this.on(Events.PAGE_REQUESTFAILED.getName(), handler);
    }

    public void onRequestfinished(EventHandler<Request> handler) {
        this.on(Events.PAGE_REQUESTFINISHED.getName(), handler);
    }

    public void onResponse(EventHandler<Response> handler) {
        this.on(Events.PAGE_RESPONSE.getName(), handler);
    }

    public void onWorkercreated(EventHandler<Worker> handler) {
        this.on(Events.PAGE_WORKERCREATED.getName(), handler);
    }

    public void onWorkerdestroyed(EventHandler<Worker> handler) {
        this.on(Events.PAGE_WORKERDESTROYED.getName(), handler);
    }

    public ElementHandle $(String selector) {
        return this.mainFrame().$(selector);
    }

    public List<ElementHandle> $$(String selector) {
        return this.mainFrame().$$(selector);
    }

    public Object $$eval(String selector, String pageFunction) {
        return this.$$eval(selector, pageFunction, new ArrayList<Object>());
    }

    public Object $$eval(String selector, String pageFunction, List<Object> args) {
        return this.mainFrame().$$eval(selector, pageFunction, args);
    }

    public Frame mainFrame() {
        return this.frameManager.mainFrame();
    }

    public Object $eval(String selector, String pageFunction) {
        return this.$eval(selector, pageFunction, new ArrayList<Object>());
    }

    public Object $eval(String selector, String pageFunction, List<Object> args) {
        return this.mainFrame().$eval(selector, pageFunction, args);
    }

    public List<ElementHandle> $x(String expression) {
        return this.mainFrame().$x(expression);
    }

    public ElementHandle addScriptTag(ScriptTagOptions options) throws IOException {
        return this.mainFrame().addScriptTag(options);
    }

    public ElementHandle addStyleTag(StyleTagOptions options) throws IOException {
        return this.mainFrame().addStyleTag(options);
    }

    public void authenticate(Credentials credentials) {
        this.frameManager.networkManager().authenticate(credentials);
    }

    public void bringToFront() {
        this.client.send("Page.bringToFront", null, true);
    }

    public Browser browser() {
        return this.target.browser();
    }

    public Context browserContext() {
        return this.target.browserContext();
    }

    public void click(String selector, boolean isBlock) throws InterruptedException, ExecutionException {
        this.click(selector, new ClickOptions(), isBlock);
    }

    public void click(String selector) throws InterruptedException, ExecutionException {
        this.click(selector, new ClickOptions(), true);
    }

    public void click(String selector, ClickOptions options, boolean isBlock) throws InterruptedException, ExecutionException {
        this.mainFrame().click(selector, options, isBlock);
    }

    public void close() throws InterruptedException {
        this.close(false);
    }

    public void close(boolean runBeforeUnload) throws InterruptedException {
        Assert.isTrue(this.client.getConnection() != null, "Protocol error: Connection closed. Most likely the page has been closed.", new Object[0]);
        if (runBeforeUnload) {
            this.client.send("Page.close", null, false);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("targetId", this.target.getTargetId());
            this.client.getConnection().send("Target.closeTarget", params, true);
            this.target.WaiforisClosedPromise();
        }
    }

    public String screenshot(ScreenshotOptions options) throws IOException {
        String screenshotType = null;
        if (StringKit.isNotEmpty(options.getType())) {
            Assert.isTrue("png".equals(options.getType()) || "jpeg".equals(options.getType()), "Unknown options.type value: " + options.getType(), new Object[0]);
            screenshotType = options.getType();
        } else if (StringKit.isNotEmpty(options.getPath())) {
            String mimeType = Files.probeContentType(Paths.get(options.getPath(), new String[0]));
            if ("image/png".equals(mimeType)) {
                screenshotType = "png";
            } else if ("image/jpeg".equals(mimeType)) {
                screenshotType = "jpeg";
            }
            Assert.isTrue(StringKit.isNotEmpty(screenshotType), "Unsupported screenshot mime type: " + mimeType, new Object[0]);
        }
        if (StringKit.isEmpty(screenshotType)) {
            screenshotType = "png";
        }
        if (options.getQuality() > 0) {
            Assert.isTrue("jpeg".equals(screenshotType), "options.quality is unsupported for the " + screenshotType + " screenshots", new Object[0]);
            Assert.isTrue(options.getQuality() <= 100, "Expected options.quality to be between 0 and 100 (inclusive), got " + options.getQuality(), new Object[0]);
        }
        Assert.isTrue(options.getClip() == null || !options.getFullPage(), "options.clip and options.fullPage are exclusive", new Object[0]);
        if (options.getClip() != null) {
            Assert.isTrue(options.getClip().getWidth() != 0.0, "Expected options.clip.width not to be 0.", new Object[0]);
            Assert.isTrue(options.getClip().getHeight() != 0.0, "Expected options.clip.height not to be 0.", new Object[0]);
        }
        return (String)this.screenshotTaskQueue.postTask((type, op) -> {
            try {
                return this.screenshotTask((String)type, (ScreenshotOptions)op);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }, screenshotType, options);
    }

    public String screenshot(String path) throws IOException {
        return this.screenshot(new ScreenshotOptions(path));
    }

    public List<String> select(String selector, List<String> values) {
        return this.mainFrame().select(selector, values);
    }

    public String title() {
        return this.mainFrame().title();
    }

    public void setBypassCSP(boolean enabled) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", enabled);
        this.client.send("Page.setBypassCSP", params, true);
    }

    public void setCacheEnabled(boolean enabled) {
        this.frameManager.networkManager().setCacheEnabled(enabled);
    }

    public void setContent(String html) {
        this.setContent(html, new PageNavigateOptions());
    }

    public void setContent(String html, PageNavigateOptions options) {
        this.frameManager.mainFrame().setContent(html, options);
    }

    public List<Cookie> cookies(List<String> urls) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (urls == null) {
            urls = new ArrayList<String>();
        }
        if (urls.size() == 0) {
            urls.add(this.url());
        }
        params.put("urls", urls);
        JSONObject result = this.client.send("Network.getCookies", params, true);
        JSONArray cookiesNode = result.getJSONArray("cookies");
        Iterator elements = cookiesNode.iterator();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        while (elements.hasNext()) {
            JSONObject cookieNode = (JSONObject)elements.next();
            Cookie cookie = (Cookie)JSON.toJavaObject((JSON)cookieNode, Cookie.class);
            cookie.setPriority(null);
            cookies.add(cookie);
        }
        return cookies;
    }

    public List<Cookie> cookies() {
        return this.cookies(null);
    }

    public void setCookie(List<CookieParam> cookies) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        String pageURL = this.url();
        boolean startsWithHTTP = pageURL.startsWith("http");
        cookies.replaceAll(cookie -> {
            if (StringKit.isEmpty(cookie.getUrl()) && startsWithHTTP) {
                cookie.setUrl(pageURL);
            }
            Assert.isTrue(!ABOUT_BLANK.equals(cookie.getUrl()), "Blank page can not have cookie " + cookie.getName(), new Object[0]);
            if (StringKit.isNotEmpty(cookie.getUrl())) {
                Assert.isTrue(!cookie.getUrl().startsWith("data:"), "Data URL page can not have cookie " + cookie.getName(), new Object[0]);
            }
            return cookie;
        });
        ArrayList<DeleteCookiesParameters> deleteCookiesParameters = new ArrayList<DeleteCookiesParameters>();
        for (CookieParam cookie2 : cookies) {
            deleteCookiesParameters.add(new DeleteCookiesParameters(cookie2.getName(), cookie2.getUrl(), cookie2.getDomain(), cookie2.getPath()));
        }
        this.deleteCookie(deleteCookiesParameters);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cookies", cookies);
        this.client.send("Network.setCookies", params, true);
    }

    public void setDefaultNavigationTimeout(int timeout) {
        this.timeoutSettings.setDefaultNavigationTimeout(timeout);
    }

    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.frameManager.networkManager().setExtraHTTPHeaders(headers);
    }

    public void setGeolocation(double longitude, double latitude, int accuracy) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Invalid longitude " + longitude + ": precondition -180 <= LONGITUDE <= 180 failed.");
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Invalid latitude " + latitude + ": precondition -90 <= LATITUDE <= 90 failed.");
        }
        if (accuracy < 0) {
            throw new IllegalArgumentException("Invalid accuracy " + accuracy + ": precondition 0 <= ACCURACY failed.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("longitude", longitude);
        params.put("latitude", latitude);
        params.put("accuracy", accuracy);
        this.client.send("Emulation.setGeolocationOverride", params, true);
    }

    public void setGeolocation(double longitude, double latitude) {
        this.setGeolocation(longitude, latitude, 0);
    }

    public void setJavaScriptEnabled(boolean enabled) {
        if (this.javascriptEnabled == enabled) {
            return;
        }
        this.javascriptEnabled = enabled;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", !enabled);
        this.client.send("Emulation.setScriptExecutionDisabled", params, true);
    }

    public void setOfflineMode(boolean enabled) {
        this.frameManager.networkManager().setOfflineMode(enabled);
    }

    public void setRequestInterception(boolean value) {
        this.frameManager.networkManager().setRequestInterception(value);
    }

    private String screenshotTask(String format, ScreenshotOptions options) throws IOException, ExecutionException, InterruptedException {
        boolean shouldSetDefaultBackground;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", this.target.getTargetId());
        this.client.send("Target.activateTarget", params, true);
        ClipOverwrite clip = null;
        if (options.getClip() != null) {
            clip = this.processClip(options.getClip());
        }
        if (options.getFullPage()) {
            JSONObject metrics = this.client.send("Page.getLayoutMetrics", null, true);
            double width = Math.ceil(metrics.getJSONObject("contentSize").getDouble("width"));
            double height = Math.ceil(metrics.getJSONObject("contentSize").getDouble("height"));
            clip = new ClipOverwrite(0.0, 0.0, width, height, 1.0);
            ScreenOrientation screenOrientation = this.viewport.getIsLandscape() ? new ScreenOrientation(90, "landscapePrimary") : new ScreenOrientation(0, "portraitPrimary");
            params.clear();
            params.put("mobile", this.viewport.getIsMobile());
            params.put("width", width);
            params.put("height", height);
            params.put("deviceScaleFactor", this.viewport.getDeviceScaleFactor());
            params.put("screenOrientation", screenOrientation);
            this.client.send("Emulation.setDeviceMetricsOverride", params, true);
        }
        boolean bl = shouldSetDefaultBackground = options.getOmitBackground() && "png".equals(format);
        if (shouldSetDefaultBackground) {
            this.setTransparentBackgroundColor();
        }
        params.clear();
        params.put("format", format);
        params.put("quality", options.getQuality());
        params.put("clip", clip);
        JSONObject result = this.client.send("Page.captureScreenshot", params, true);
        if (shouldSetDefaultBackground) {
            this.client.send("Emulation.setDefaultBackgroundColorOverride", null, true);
        }
        if (options.getFullPage() && this.viewport != null) {
            this.setViewport(this.viewport);
        }
        String data = result.getString("data");
        byte[] buffer = Base64.getDecoder().decode(data);
        if (StringKit.isNotEmpty(options.getPath())) {
            Files.write(Paths.get(options.getPath(), new String[0]), buffer, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        return data;
    }

    private void setTransparentBackgroundColor() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
        colorMap.put("r", 0);
        colorMap.put("g", 0);
        colorMap.put("b", 0);
        colorMap.put("a", 0);
        params.put("color", colorMap);
        this.client.send("Emulation.setDefaultBackgroundColorOverride", params, true);
    }

    private ClipOverwrite processClip(Clip clip) {
        long x = Math.round(clip.getX());
        long y = Math.round(clip.getY());
        long width = Math.round(clip.getWidth() + clip.getX() - (double)x);
        long height = Math.round(clip.getHeight() + clip.getY() - (double)y);
        return new ClipOverwrite(x, y, width, height, 1.0);
    }

    private void onFileChooser(FileChooserOpenedPayload event) {
        Builder.commonExecutor().submit(() -> {
            if (CollKit.isEmpty(this.fileChooserInterceptors)) {
                return;
            }
            Frame frame = this.frameManager.frame(event.getFrameId());
            ExecutionContext context = frame.executionContext();
            ElementHandle element = context.adoptBackendNodeId(event.getBackendNodeId());
            HashSet<FileChooserCallBack> interceptors = new HashSet<FileChooserCallBack>(this.fileChooserInterceptors);
            this.fileChooserInterceptors.clear();
            FileChooser fileChooser = new FileChooser(this.client, element, event);
            for (FileChooserCallBack interceptor : interceptors) {
                interceptor.setFileChooser(fileChooser);
            }
        });
    }

    private void onLogEntryAdded(EntryAddedPayload event) {
        if (CollKit.isNotEmpty(event.getEntry().getArgs())) {
            event.getEntry().getArgs().forEach(arg -> Builder.releaseObject(this.client, arg, false));
        }
        if (!"worker".equals(event.getEntry().getSource())) {
            this.emit(Events.PAGE_CONSOLE.getName(), new ConsoleMessage(event.getEntry().getLevel(), event.getEntry().getText(), Collections.emptyList(), new Location(event.getEntry().getUrl(), event.getEntry().getLineNumber())));
        }
    }

    private void emitMetrics(MetricsPayload event) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        PageMetrics pageMetrics = new PageMetrics();
        Metrics metrics = this.buildMetricsObject(event.getMetrics());
        pageMetrics.setMetrics(metrics);
        pageMetrics.setTitle(event.getTitle());
        this.emit(Events.PAGE_METRICS.getName(), pageMetrics);
    }

    private void onTargetCrashed() {
        this.emit("error", new PageCrashException("Page crashed!"));
    }

    private void onDialog(JavascriptDialogOpeningPayload event) {
        DialogType dialogType = null;
        if ("alert".equals(event.getType())) {
            dialogType = DialogType.Alert;
        } else if ("confirm".equals(event.getType())) {
            dialogType = DialogType.Confirm;
        } else if ("prompt".equals(event.getType())) {
            dialogType = DialogType.Prompt;
        } else if ("beforeunload".equals(event.getType())) {
            dialogType = DialogType.BeforeUnload;
        }
        Assert.isTrue(dialogType != null, "Unknown javascript dialog type: " + event.getType(), new Object[0]);
        Dialog dialog = new Dialog(this.client, dialogType, event.getMessage(), event.getDefaultPrompt());
        this.emit(Events.PAGE_DIALOG.getName(), dialog);
    }

    private void onConsoleAPI(ConsoleAPICalledPayload event) {
        if (event.getExecutionContextId() == 0) {
            return;
        }
        ExecutionContext context = this.frameManager.executionContextById(event.getExecutionContextId());
        ArrayList<JSHandle> values = new ArrayList<JSHandle>();
        if (CollKit.isNotEmpty(event.getArgs())) {
            for (int i = 0; i < event.getArgs().size(); ++i) {
                RemoteObject arg = event.getArgs().get(i);
                values.add(JSHandle.createJSHandle(context, arg));
            }
        }
        this.addConsoleMessage(event.getType(), values, event.getStackTrace());
    }

    private void onBindingCalled(BindingCalledPayload event) {
        String expression;
        String payloadStr = event.getPayload();
        Payload payload = (Payload)JSON.parseObject((String)payloadStr, Payload.class);
        try {
            Object result = this.pageBindings.get(event.getName()).apply(payload.getArgs());
            expression = Builder.evaluationString(this.deliverResult(), PageEvaluateType.FUNCTION, payload.getName(), payload.getSeq(), result);
        }
        catch (Exception e) {
            expression = Builder.evaluationString(this.deliverError(), PageEvaluateType.FUNCTION, payload.getName(), payload.getSeq(), e, e.getMessage());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expression", expression);
        params.put("contextId", event.getExecutionContextId());
        this.client.send("Runtime.evaluate", params, false);
    }

    private String deliverError() {
        return "function deliverError(name, seq, message, stack) {\n      const error = new Error(message);\n      error.stack = stack;\n      window[name]['callbacks'].get(seq).reject(error);\n      window[name]['callbacks'].delete(seq);\n    }";
    }

    private String deliverResult() {
        return "function deliverResult(name, seq, result) {\n      window[name]['callbacks'].get(seq).resolve(result);\n      window[name]['callbacks'].delete(seq);\n    }";
    }

    public void setViewport(Viewport viewport) {
        boolean needsReload = this.emulationManager.emulateViewport(viewport);
        this.viewport = viewport;
        if (needsReload) {
            this.reload(null);
        }
    }

    protected void initialize() {
        this.frameManager.initialize();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("autoAttach", true);
        params.put("waitForDebuggerOnStart", false);
        params.put("flatten", true);
        this.client.send("Target.setAutoAttach", params, false);
        params.clear();
        this.client.send("Performance.enable", params, false);
        this.client.send("Log.enable", params, true);
    }

    private void addConsoleMessage(String type, List<JSHandle> args, StackTrace stackTrace) {
        if (this.getListenerCount(Events.PAGE_CONSOLE.getName()) == 0) {
            args.forEach(arg -> arg.dispose(false));
            return;
        }
        ArrayList<String> textTokens = new ArrayList<String>();
        for (JSHandle arg2 : args) {
            RemoteObject remoteObject = arg2.getRemoteObject();
            if (StringKit.isNotEmpty(remoteObject.getObjectId())) {
                textTokens.add(arg2.toString());
                continue;
            }
            textTokens.add(JSON.toJSONString((Object)Builder.valueFromRemoteObject(remoteObject)));
        }
        Location location = stackTrace != null && stackTrace.getCallFrames().size() > 0 ? new Location(stackTrace.getCallFrames().get(0).getUrl(), stackTrace.getCallFrames().get(0).getLineNumber(), stackTrace.getCallFrames().get(0).getColumnNumber()) : new Location();
        ConsoleMessage message = new ConsoleMessage(type, String.join((CharSequence)" ", textTokens), args, location);
        this.emit(Events.PAGE_CONSOLE.getName(), message);
    }

    private void handleException(ExceptionDetails exceptionDetails) {
        String message = Builder.getExceptionMessage(exceptionDetails);
        RuntimeException err = new RuntimeException(message);
        this.emit(Events.PAGE_PageError.getName(), err);
    }

    public String content() {
        return this.frameManager.getMainFrame().content();
    }

    public Response goTo(String url, boolean isBlock) throws InterruptedException {
        return this.goTo(url, new PageNavigateOptions(), isBlock);
    }

    public Response goTo(String url, PageNavigateOptions options) throws InterruptedException {
        return this.goTo(url, options, true);
    }

    public Response goTo(String url, PageNavigateOptions options, boolean isBlock) throws InterruptedException {
        return this.frameManager.getMainFrame().goTo(url, options, isBlock);
    }

    public Response goTo(String url) throws InterruptedException {
        return this.goTo(url, true);
    }

    public void deleteCookie(List<DeleteCookiesParameters> cookies) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        String pageURL = this.url();
        for (DeleteCookiesParameters cookie : cookies) {
            if (StringKit.isEmpty(cookie.getUrl()) && pageURL.startsWith("http")) {
                cookie.setUrl(pageURL);
            }
            Map<String, Object> params = this.getProperties(cookie);
            this.client.send("Network.deleteCookies", params, true);
        }
    }

    private Map<String, Object> getProperties(DeleteCookiesParameters cookie) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> params = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(cookie.getClass());
        for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            params.put(descriptor.getName(), descriptor.getReadMethod().invoke((Object)cookie, new Object[0]));
        }
        return params;
    }

    public void emulate(Device options) throws ExecutionException, InterruptedException {
        this.setViewport(options.getViewport());
        this.setUserAgent(options.getUserAgent());
    }

    public void setUserAgent(String userAgent) {
        this.frameManager.networkManager().setUserAgent(userAgent);
    }

    public void emulateMediaType(String type) {
        this.emulateMedia(type);
    }

    public void tap(String selector, boolean isBlock) {
        this.mainFrame().tap(selector, isBlock);
    }

    public void tap(String selector) {
        this.tap(selector, true);
    }

    public void emulateTimezone(String timezoneId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (timezoneId == null) {
                timezoneId = "";
            }
            params.put("timezoneId", timezoneId);
            this.client.send("Emulation.setTimezoneOverride", params, true);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Invalid timezone")) {
                throw new IllegalArgumentException("Invalid timezone ID: " + timezoneId);
            }
            throw e;
        }
    }

    public void emulateVisionDeficiency(VisionDeficiency type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type.getValue());
        this.client.send("Emulation.setEmulatedVisionDeficiency", params, true);
    }

    public void evaluateOnNewDocument(String pageFunction, Object ... args) {
        this.evaluateOnNewDocument(pageFunction, Builder.isFunction(pageFunction) ? PageEvaluateType.FUNCTION : PageEvaluateType.STRING, args);
    }

    public void evaluateOnNewDocument(String pageFunction, PageEvaluateType type, Object ... args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (Objects.equals((Object)PageEvaluateType.STRING, (Object)type)) {
            Assert.isTrue(args.length == 0, "Cannot evaluate a string with arguments", new Object[0]);
            params.put("source", pageFunction);
        } else {
            List<Object> objects = Arrays.asList(args);
            ArrayList argsList = new ArrayList();
            objects.forEach(arg -> {
                if (arg == null) {
                    argsList.add("undefined");
                } else {
                    argsList.add(JSON.toJSONString((Object)arg));
                }
            });
            String source = "(" + pageFunction + ")(" + String.join((CharSequence)",", argsList) + ")";
            params.put("source", source);
        }
        this.client.send("Page.addScriptToEvaluateOnNewDocument", params, true);
    }

    public void exposeFunction(String name, Function<List<?>, Object> puppeteerFunction) throws InterruptedException, ExecutionException {
        if (this.pageBindings.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format("Failed to add page binding with name {0}: window['{1}'] already exists!", name, name));
        }
        this.pageBindings.put(name, puppeteerFunction);
        String expression = Builder.evaluationString(this.addPageBinding(), PageEvaluateType.FUNCTION, name);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        this.client.send("Runtime.addBinding", params, true);
        params.clear();
        params.put("source", expression);
        this.client.send("Page.addScriptToEvaluateOnNewDocument", params, true);
        List<Frame> frames = this.frames();
        if (frames.isEmpty()) {
            return;
        }
        CompletionService completionService = Builder.completionService();
        frames.forEach(frame -> completionService.submit(() -> frame.evaluate(expression, null)));
        for (int i = 0; i < frames.size(); ++i) {
            completionService.take().get();
        }
    }

    private String addPageBinding() {
        return "function addPageBinding(bindingName) {\n      const win = (window);\n      const binding = (win[bindingName]);\n      win[bindingName] = (...args) => {\n        const me = window[bindingName];\n        let callbacks = me['callbacks'];\n        if (!callbacks) {\n          callbacks = new Map();\n          me['callbacks'] = callbacks;\n        }\n        const seq = (me['lastSeq'] || 0) + 1;\n        me['lastSeq'] = seq;\n        const promise = new Promise((resolve, reject) => callbacks.set(seq, {resolve, reject}));\n        binding(JSON.stringify({name: bindingName, seq, args}));\n        return promise;\n      };\n    }";
    }

    public void focus(String selector) {
        this.mainFrame().focus(selector);
    }

    public List<Frame> frames() {
        return this.frameManager.frames();
    }

    public Response goBack() {
        return this.go(-1, new PageNavigateOptions());
    }

    public Response goBack(PageNavigateOptions options) {
        return this.go(-1, options);
    }

    public Response goForward() {
        return this.go(1, new PageNavigateOptions());
    }

    public Response goForward(PageNavigateOptions options) {
        return this.go(1, options);
    }

    public void hover(String selector) {
        this.mainFrame().hover(selector);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Metrics metrics() throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        JSONObject responseNode = this.client.send("Performance.getMetrics", null, true);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        List list = (List)responseNode.getObject("metrics", (TypeReference)new TypeReference<List<JSONObject>>(){});
        for (JSONObject next : list) {
            Metric value = (Metric)JSON.toJavaObject((JSON)next, Metric.class);
            metrics.add(value);
        }
        return this.buildMetricsObject(metrics);
    }

    public void pdf(String path) throws IOException {
        this.pdf(new PDFOptions(path));
    }

    public byte[] pdf(PDFOptions options) throws IOException {
        Number marginRight;
        Number marginBottom;
        Number marginLeft;
        double paperWidth = 8.5;
        double paperHeight = 11.0;
        if (StringKit.isNotEmpty(options.getFormat())) {
            PaperFormats format = PaperFormats.valueOf(options.getFormat().toLowerCase());
            paperWidth = format.getWidth();
            paperHeight = format.getHeight();
        } else {
            Double height;
            Double width = this.convertPrintParameterToInches(options.getWidth());
            if (width != null) {
                paperWidth = width;
            }
            if ((height = this.convertPrintParameterToInches(options.getHeight())) != null) {
                paperHeight = height;
            }
        }
        Margin margin = options.getMargin();
        Number marginTop = this.convertPrintParameterToInches(margin.getTop());
        if (marginTop == null) {
            marginTop = 0;
        }
        if ((marginLeft = this.convertPrintParameterToInches(margin.getLeft())) == null) {
            marginLeft = 0;
        }
        if ((marginBottom = this.convertPrintParameterToInches(margin.getBottom())) == null) {
            marginBottom = 0;
        }
        if ((marginRight = this.convertPrintParameterToInches(margin.getRight())) == null) {
            marginRight = 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("transferMode", "ReturnAsStream");
        params.put("landscape", options.getLandscape());
        params.put("displayHeaderFooter", options.getDisplayHeaderFooter());
        params.put("headerTemplate", options.getHeaderTemplate());
        params.put("footerTemplate", options.getFooterTemplate());
        params.put("printBackground", options.getPrintBackground());
        params.put("scale", options.getScale());
        params.put("paperWidth", paperWidth);
        params.put("paperHeight", paperHeight);
        params.put("marginTop", marginTop);
        params.put("marginBottom", marginBottom);
        params.put("marginLeft", marginLeft);
        params.put("marginRight", marginRight);
        params.put("pageRanges", options.getPageRanges());
        params.put("preferCSSPageSize", options.getPreferCSSPageSize());
        JSONObject result = this.client.send("Page.printToPDF", params, true);
        if (result != null) {
            String handle = result.getString("stream");
            Assert.isTrue(handle != null, "Page.printToPDF result has no stream handle. Please check your chrome version. result=" + String.valueOf(result), new Object[0]);
            return (byte[])Builder.readProtocolStream(this.client, handle, options.getPath(), false);
        }
        throw new ProtocolException("Page.printToPDF no response");
    }

    public void setDefaultTimeout(int timeout) {
        this.timeoutSettings.setDefaultTimeout(timeout);
    }

    public JSHandle queryObjects(JSHandle prototypeHandle) {
        ExecutionContext context = this.mainFrame().executionContext();
        return context.queryObjects(prototypeHandle);
    }

    private Double convertPrintParameterToInches(String parameter) {
        double pixels;
        if (StringKit.isEmpty(parameter)) {
            return null;
        }
        if (Builder.isNumber(parameter)) {
            pixels = Double.parseDouble(parameter);
        } else if (parameter.endsWith("px") || parameter.endsWith("in") || parameter.endsWith("cm") || parameter.endsWith("mm")) {
            String valueText;
            String unit = parameter.substring(parameter.length() - 2).toLowerCase();
            if (unitToPixels.containsKey(unit)) {
                valueText = parameter.substring(0, parameter.length() - 2);
            } else {
                unit = "px";
                valueText = parameter;
            }
            double value = Double.parseDouble(valueText);
            Assert.isTrue(!Double.isNaN(value), "Failed to parse parameter value: " + parameter, new Object[0]);
            pixels = value * unitToPixels.get(unit);
        } else {
            throw new IllegalArgumentException("page.pdf() Cannot handle parameter type: " + parameter);
        }
        return pixels / 96.0;
    }

    public Response reload(PageNavigateOptions options) {
        CountDownLatch reloadLatch = new CountDownLatch(1);
        reloadExecutor.submit(() -> {
            try {
                reloadLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.client.send("Page.reload", null, true);
        });
        return this.waitForNavigation(options, reloadLatch);
    }

    private Metrics buildMetricsObject(List<Metric> metrics) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Metrics result = new Metrics();
        if (CollKit.isNotEmpty(metrics)) {
            for (Metric metric : metrics) {
                if (!Builder.SUPPORTED_METRICS.contains(metric.getName())) continue;
                PropertyDescriptor descriptor = new PropertyDescriptor(metric.getName(), Metrics.class);
                descriptor.getWriteMethod().invoke((Object)result, metric.getValue());
            }
        }
        return result;
    }

    private Response go(int delta, PageNavigateOptions options) {
        JSONObject historyNode = this.client.send("Page.getNavigationHistory", null, true);
        GetNavigationHistoryReturnValue history = (GetNavigationHistoryReturnValue)JSON.toJavaObject((JSON)historyNode, GetNavigationHistoryReturnValue.class);
        NavigationEntry entry = history.getEntries().get(history.getCurrentIndex() + delta);
        if (entry == null) {
            return null;
        }
        Response response = this.waitForNavigation(options, null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entryId", entry.getId());
        this.client.send("Page.navigateToHistoryEntry", params, true);
        return response;
    }

    public Response waitForNavigation() {
        return this.waitForNavigation(new PageNavigateOptions(), null);
    }

    public Response waitForNavigation(PageNavigateOptions options) {
        return this.frameManager.mainFrame().waitForNavigation(options, null);
    }

    private Response waitForNavigation(PageNavigateOptions options, CountDownLatch reloadLatch) {
        return this.frameManager.mainFrame().waitForNavigation(options, reloadLatch);
    }

    public Object evaluate(String pageFunction) {
        return this.evaluate(pageFunction, new ArrayList<Object>());
    }

    public Object evaluate(String pageFunction, List<Object> args) {
        return this.mainFrame().evaluate(pageFunction, args);
    }

    public JSHandle evaluateHandle(String pageFunction) {
        return this.evaluateHandle(pageFunction, new ArrayList<Object>());
    }

    private JSHandle evaluateHandle(String pageFunction, List<Object> args) {
        ExecutionContext context = this.mainFrame().executionContext();
        return (JSHandle)context.evaluateHandle(pageFunction, args);
    }

    public void emulateMedia(String type) {
        Assert.isTrue("screen".equals(type) || "print".equals(type) || type == null, "Unsupported media type: " + type, new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("media", type);
        this.client.send("Emulation.setEmulatedMedia", params, true);
    }

    public void emulateMediaFeatures(List<MediaFeature> features) {
        Pattern pattern = Pattern.compile("^prefers-(?:color-scheme|reduced-motion)$");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (features == null) {
            params.put("features", null);
            this.client.send("Emulation.setEmulatedMedia", params, true);
        }
        if (CollKit.isNotEmpty(features)) {
            features.forEach(mediaFeature -> {
                String name = mediaFeature.getName();
                Assert.isTrue(pattern.matcher(name).find(), "Unsupported media feature: " + name, new Object[0]);
            });
        }
        params.put("features", features);
        this.client.send("Emulation.setEmulatedMedia", params, true);
    }

    public JSHandle waitFor(String selectorOrFunctionOrTimeout) throws InterruptedException {
        return this.waitFor(selectorOrFunctionOrTimeout, new WaitForSelectorOptions(), new ArrayList<Object>());
    }

    public JSHandle waitFor(String selectorOrFunctionOrTimeout, WaitForSelectorOptions options, List<Object> args) throws InterruptedException {
        return this.mainFrame().waitFor(selectorOrFunctionOrTimeout, options, args);
    }

    public Future<FileChooser> waitForFileChooser() {
        return this.waitForFileChooser(this.timeoutSettings.timeout());
    }

    public Future<FileChooser> waitForFileChooser(int timeout) {
        if (timeout <= 0) {
            timeout = this.timeoutSettings.timeout();
        }
        int finalTimeout = timeout;
        return Builder.commonExecutor().submit(() -> {
            if (CollKit.isEmpty(this.fileChooserInterceptors)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("enabled", true);
                this.client.send("Page.setInterceptFileChooserDialog", params, true);
            }
            CountDownLatch latch = new CountDownLatch(1);
            FileChooserCallBack callback = new FileChooserCallBack(latch);
            this.fileChooserInterceptors.add(callback);
            try {
                callback.waitForFileChooser(finalTimeout);
                return callback.getFileChooser();
            }
            catch (InterruptedException e) {
                this.fileChooserInterceptors.remove(callback);
                throw new RuntimeException(e);
            }
        });
    }

    public JSHandle waitForFunction(String pageFunction) throws InterruptedException {
        return this.waitForFunction(pageFunction, new WaitForSelectorOptions());
    }

    public JSHandle waitForFunction(String pageFunction, List<Object> args) throws InterruptedException {
        return this.waitForFunction(pageFunction, new WaitForSelectorOptions(), args);
    }

    public JSHandle waitForFunction(String pageFunction, WaitForSelectorOptions options) throws InterruptedException {
        return this.waitForFunction(pageFunction, options, new ArrayList<Object>());
    }

    public JSHandle waitForFunction(String pageFunction, WaitForSelectorOptions options, List<Object> args) throws InterruptedException {
        return this.mainFrame().waitForFunction(pageFunction, options, args);
    }

    public Request waitForRequest(Predicate<Request> predicate) throws InterruptedException {
        Assert.notNull(predicate, "waitForRequest predicate must not be null", new Object[0]);
        return this.waitForRequest(null, predicate, this.timeoutSettings.timeout());
    }

    public Request waitForRequest(String url) throws InterruptedException {
        Assert.isTrue(StringKit.isNotEmpty(url), "waitForRequest url must not be empty", new Object[0]);
        return this.waitForRequest(url, null, this.timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request waitForRequest(String url, Predicate<Request> predicate, int timeout) throws InterruptedException {
        if (timeout <= 0) {
            timeout = this.timeoutSettings.timeout();
        }
        Predicate<Request> predi = request -> {
            if (StringKit.isNotEmpty(url)) {
                return url.equals(request.url());
            }
            if (predicate != null) {
                return predicate.test((Request)request);
            }
            return false;
        };
        DefaultBrowserListener<Object> listener = null;
        try {
            listener = this.sessionClosePromise();
            Request request2 = (Request)Builder.waitForEvent(this.frameManager.networkManager(), Events.NETWORK_MANAGER_REQUEST.getName(), predi, timeout, "Wait for request timeout");
            return request2;
        }
        finally {
            if (listener != null) {
                this.client.removeListener(Events.CDPSESSION_DISCONNECTED.getName(), listener);
            }
        }
    }

    private DefaultBrowserListener<Object> sessionClosePromise() {
        DefaultBrowserListener<Object> disConnectLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                throw new TerminateException("Target closed");
            }
        };
        disConnectLis.setMethod(Events.CDPSESSION_DISCONNECTED.getName());
        this.client.addListener(disConnectLis.getMethod(), disConnectLis, true);
        return disConnectLis;
    }

    public Response waitForResponse(Predicate<Response> predicate) throws InterruptedException {
        return this.waitForResponse(null, predicate);
    }

    public Response waitForResponse(String url) throws InterruptedException {
        return this.waitForResponse(url, null);
    }

    public Response waitForResponse(String url, Predicate<Response> predicate) throws InterruptedException {
        return this.waitForResponse(url, predicate, this.timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(String url, Predicate<Response> predicate, int timeout) throws InterruptedException {
        if (timeout <= 0) {
            timeout = this.timeoutSettings.timeout();
        }
        Predicate<Response> predi = response -> {
            if (StringKit.isNotEmpty(url)) {
                return url.equals(response.url());
            }
            if (predicate != null) {
                return predicate.test((Response)response);
            }
            return false;
        };
        DefaultBrowserListener<Object> listener = null;
        try {
            listener = this.sessionClosePromise();
            Response response2 = (Response)Builder.waitForEvent(this.frameManager.networkManager(), Events.NETWORK_MANAGER_RESPONSE.getName(), predi, timeout, "Wait for response timeout");
            return response2;
        }
        finally {
            if (listener != null) {
                this.client.removeListener(Events.CDPSESSION_DISCONNECTED.getName(), listener);
            }
        }
    }

    public ElementHandle waitForSelector(String selector) throws InterruptedException {
        return this.waitForSelector(selector, new WaitForSelectorOptions());
    }

    public ElementHandle waitForSelector(String selector, WaitForSelectorOptions options) throws InterruptedException {
        return this.mainFrame().waitForSelector(selector, options);
    }

    public JSHandle waitForXPath(String xpath) throws InterruptedException {
        return this.mainFrame().waitForXPath(xpath, new WaitForSelectorOptions());
    }

    public JSHandle waitForXPath(String xpath, WaitForSelectorOptions options) throws InterruptedException {
        return this.mainFrame().waitForXPath(xpath, options);
    }

    private String url() {
        return this.mainFrame().url();
    }

    public CDPSession client() {
        return this.client;
    }

    public Map<String, Worker> workers() {
        return this.workers;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public Target target() {
        return this.target;
    }

    public Touchscreen touchscreen() {
        return this.touchscreen;
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public Accessibility accessibility() {
        return this.accessibility;
    }

    public void type(String selector, String text) throws InterruptedException {
        this.mainFrame().type(selector, text, 0);
    }

    public void type(String selector, String text, int delay) throws InterruptedException {
        this.mainFrame().type(selector, text, delay);
    }

    public boolean getJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Viewport viewport() {
        return this.viewport;
    }

    public Coverage coverage() {
        return this.coverage;
    }

    static class FileChooserCallBack {
        private CountDownLatch latch;
        private FileChooser fileChooser;

        public FileChooserCallBack() {
        }

        public FileChooserCallBack(CountDownLatch latch) {
            this.latch = latch;
        }

        public FileChooser getFileChooser() {
            return this.fileChooser;
        }

        public void setFileChooser(FileChooser fileChooser) {
            this.fileChooser = fileChooser;
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void waitForFileChooser(int finalTimeout) throws InterruptedException {
            boolean await;
            if (this.latch != null && !(await = this.latch.await(finalTimeout, TimeUnit.MILLISECONDS))) {
                throw new TimeoutException("Waiting for file chooser failed: timeout " + finalTimeout + "ms exceeded");
            }
        }
    }
}

