/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia;

import java.io.IOException;
import java.util.List;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Browser;
import org.aoju.lancia.Builder;
import org.aoju.lancia.Launcher;
import org.aoju.lancia.kernel.Variables;
import org.aoju.lancia.kernel.browser.Fetcher;
import org.aoju.lancia.launch.ChromeLauncher;
import org.aoju.lancia.launch.FirefoxLauncher;
import org.aoju.lancia.option.BrowserOptions;
import org.aoju.lancia.option.ChromeArgOptions;
import org.aoju.lancia.option.FetcherOptions;
import org.aoju.lancia.option.LaunchOptions;
import org.aoju.lancia.option.LaunchOptionsBuilder;
import org.aoju.lancia.worker.Transport;

public class Puppeteer {
    private String productName = null;
    private Launcher launcher;
    private Variables variables = null;
    private String projectRoot = System.getProperty("user.dir");
    private String preferredRevision = "818858";
    private boolean isPuppeteerCore;

    public Puppeteer() {
    }

    public Puppeteer(String projectRoot, String preferredRevision, boolean isPuppeteerCore, String productName) {
        this.projectRoot = projectRoot;
        this.preferredRevision = StringKit.isEmpty(preferredRevision) ? "818858" : preferredRevision;
        this.isPuppeteerCore = isPuppeteerCore;
        this.productName = productName;
    }

    public static Browser launch() throws IOException {
        return Puppeteer.rawLaunch();
    }

    public static Browser launch(boolean headless) throws IOException {
        return Puppeteer.rawLaunch(headless);
    }

    public static Browser launch(LaunchOptions options) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(options, puppeteer);
    }

    private static Browser rawLaunch() throws IOException {
        return Puppeteer.rawLaunch(true);
    }

    private static Browser rawLaunch(boolean headless) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(new LaunchOptionsBuilder().headless(headless).build(), puppeteer);
    }

    private static Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, Transport transport, String product) {
        Puppeteer puppeteer = new Puppeteer();
        if (StringKit.isNotEmpty(product)) {
            puppeteer.setProductName(product);
        }
        Puppeteer.adapterLauncher(puppeteer);
        return puppeteer.getLauncher().connect(options, browserWSEndpoint, browserURL, transport);
    }

    public static Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, Transport transport) {
        return Puppeteer.connect(options, browserWSEndpoint, browserURL, transport, null);
    }

    public static Browser connect(String browserWSEndpoint, String browserURL, Transport transport) {
        return Puppeteer.connect(new BrowserOptions(), browserWSEndpoint, browserURL, transport, null);
    }

    public static Browser connect(String browserWSEndpointOrURL) {
        if (browserWSEndpointOrURL.contains(":")) {
            return Puppeteer.connect(null, browserWSEndpointOrURL, null);
        }
        return Puppeteer.connect(browserWSEndpointOrURL, null, null);
    }

    public static Browser connect(Transport transport) {
        return Puppeteer.connect(null, null, transport);
    }

    private static Browser rawLaunch(LaunchOptions options, Puppeteer puppeteer) throws IOException {
        if (StringKit.isNotBlank(options.getProduct())) {
            puppeteer.setProductName(options.getProduct());
        }
        Puppeteer.adapterLauncher(puppeteer);
        return puppeteer.getLauncher().launch(options);
    }

    private static void adapterLauncher(Puppeteer puppeteer) {
        String productName = puppeteer.getProductName();
        if (StringKit.isEmpty(productName) && !puppeteer.getIsPuppeteerCore()) {
            Variables variables = puppeteer.getContext();
            if (variables == null) {
                variables = System::getenv;
                puppeteer.setContext(variables);
            }
            for (int i = 0; i < Builder.PRODUCT_ENV.length; ++i) {
                String envProductName = Builder.PRODUCT_ENV[i];
                productName = variables.getEnv(envProductName);
                if (!StringKit.isNotEmpty(productName)) continue;
                puppeteer.setProductName(productName);
                break;
            }
        }
        if (StringKit.isEmpty(productName)) {
            productName = "chrome";
            puppeteer.setProductName(productName);
        }
        switch (productName) {
            case "firefox": {
                FirefoxLauncher i = new FirefoxLauncher(puppeteer.getIsPuppeteerCore());
            }
        }
        ChromeLauncher launcher = new ChromeLauncher(puppeteer.getProjectRoot(), puppeteer.getPreferredRevision(), puppeteer.getIsPuppeteerCore());
        puppeteer.setLauncher(launcher);
    }

    public List<String> defaultArgs(ChromeArgOptions options) {
        return this.getLauncher().defaultArgs(options);
    }

    public String executablePath() throws IOException {
        return this.getLauncher().executablePath();
    }

    public Fetcher createBrowserFetcher() {
        return new Fetcher(this.getProjectRoot(), new FetcherOptions());
    }

    public Fetcher createBrowserFetcher(FetcherOptions options) {
        return new Fetcher(this.getProjectRoot(), options);
    }

    private String getProductName() {
        return this.productName;
    }

    private void setProductName(String productName) {
        this.productName = productName;
    }

    private boolean getIsPuppeteerCore() {
        return this.isPuppeteerCore;
    }

    private Launcher getLauncher() {
        return this.launcher;
    }

    private void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    private Variables getContext() {
        return this.variables;
    }

    private void setContext(Variables variables) {
        this.variables = variables;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getPreferredRevision() {
        return this.preferredRevision;
    }

    public void setPreferredRevision(String preferredRevision) {
        this.preferredRevision = preferredRevision;
    }
}

