/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.events;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.BrowserListener;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.Event;
import org.aoju.lancia.events.EventHandler;

public class EventEmitter
implements Event {
    private final Map<String, Set<DefaultBrowserListener>> listenerMap = new ConcurrentHashMap<String, Set<DefaultBrowserListener>>();
    private final AtomicInteger listenerCount = new AtomicInteger(0);

    @Override
    public Event addListener(String method, BrowserListener<?> blistener, boolean isOnce) {
        DefaultBrowserListener listener = (DefaultBrowserListener)blistener;
        if (!method.equals(listener.getMethod())) {
            Logger.error("addListener fail:{} is not equals listener.getMothod()[{}]", method, listener.getMethod());
            return this;
        }
        listener.setIsOnce(isOnce);
        Set<DefaultBrowserListener> browserListeners = this.listenerMap.get(method);
        if (browserListeners == null) {
            Set<DefaultBrowserListener> listeners = Builder.getConcurrentSet();
            this.listenerMap.putIfAbsent(method, listeners);
            listeners.add(listener);
        } else {
            browserListeners.add(listener);
        }
        this.listenerCount.incrementAndGet();
        return this;
    }

    @Override
    public Event removeListener(String method, BrowserListener<?> listener) {
        Set<DefaultBrowserListener> listeners = this.listenerMap.get(method);
        if (CollKit.isNotEmpty(listeners)) {
            listeners.remove(listener);
            this.listenerCount.decrementAndGet();
        }
        return this;
    }

    @Override
    public void emit(String method, Object params) {
        Assert.notNull(method, "method must not be null", new Object[0]);
        Set<DefaultBrowserListener> listeners = this.listenerMap.get(method);
        if (CollKit.isEmpty(listeners)) {
            return;
        }
        for (DefaultBrowserListener listener : listeners) {
            if (!listener.getIsAvaliable()) {
                listeners.remove(listener);
                this.listenerCount.decrementAndGet();
                continue;
            }
            if (listener.getIsOnce()) {
                listeners.remove(listener);
                this.listenerCount.decrementAndGet();
            }
            try {
                Object event;
                if (params != null) {
                    Class resolveType = null;
                    Type genericSuperclass = listener.getClass().getGenericSuperclass();
                    if (genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        if (actualTypeArguments.length == 1) {
                            resolveType = (Class)actualTypeArguments[0];
                        }
                    } else {
                        resolveType = listener.getResolveType();
                    }
                    event = JSONObject.class.isAssignableFrom(params.getClass()) ? this.readJsonObject(resolveType, (JSONObject)params) : params;
                } else {
                    event = null;
                }
                this.invokeListener(listener, event);
            }
            catch (IOException e) {
                Logger.error("publish event error:", e);
                return;
            }
        }
    }

    private void invokeListener(DefaultBrowserListener listener, Object event) {
        try {
            if (listener.getIsSync()) {
                Builder.commonExecutor().submit(() -> listener.onBrowserEvent(event));
            } else {
                listener.onBrowserEvent(event);
            }
        }
        finally {
            if (listener.getIsOnce()) {
                listener.setIsAvaliable(false);
            }
        }
    }

    private <T> T readJsonObject(Class<T> clazz, JSONObject params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Failed converting null response to clazz " + clazz.getName());
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return (T)params;
        }
        return (T)JSON.toJavaObject((JSON)params, clazz);
    }

    public int getListenerCount(String method) {
        Set<DefaultBrowserListener> listeners = this.listenerMap.get(method);
        int i = 0;
        if (CollKit.isEmpty(listeners)) {
            return 0;
        }
        for (DefaultBrowserListener listener : listeners) {
            if (!listener.getIsAvaliable()) continue;
            ++i;
        }
        return i;
    }

    public Event on(String method, EventHandler<?> handler) {
        DefaultBrowserListener listener = new DefaultBrowserListener();
        listener.setIsSync(true);
        listener.setMethod(method);
        listener.setHandler(handler);
        return this.addListener(method, listener);
    }

    public Event once(String method, EventHandler<?> handler) {
        DefaultBrowserListener listener = new DefaultBrowserListener();
        listener.setIsSync(true);
        listener.setMethod(method);
        listener.setHandler(handler);
        return this.addListener(method, listener, true);
    }

    public Event off(String method, BrowserListener<?> listener) {
        return this.removeListener(method, listener);
    }
}

