/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.kernel.Variables;

public class Standard
implements Variables {
    private static final Map<String, String> SYSTEM_PROPERTIES_SOURCEMAP = new HashMap<String, String>();
    private static final Map<String, String> SYSTEM_ENV_SOURCEMAP = new HashMap<String, String>();

    @Override
    public String getEnv(String name) {
        String value = this.getPropertyValue(name, SYSTEM_PROPERTIES_SOURCEMAP, "XSystemProperties");
        if (value == null) {
            value = this.getPropertyValue(name, SYSTEM_ENV_SOURCEMAP, "XSystemEnv");
        }
        return value;
    }

    private String getPropertyValue(String name, Map<String, String> source, String sourceName) {
        String actualName = this.resolvePropertyName(name, source);
        if (actualName == null && (actualName = this.resolvePropertyName(name.toUpperCase(), source)) == null) {
            if (Logger.isDebug()) {
                Logger.debug("PropertySource ' " + sourceName + " ' does not contain property '" + name, new Object[0]);
            }
            return null;
        }
        if (Logger.isDebug() && !name.equals(actualName)) {
            Logger.debug("PropertySource ' " + sourceName + " ' does not contain property '" + name + "', but found equivalent '" + actualName + "'", new Object[0]);
        }
        return source.get(actualName);
    }

    private final String resolvePropertyName(String name, Map<String, String> source) {
        if (source.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace(".", "_");
        if (!name.equals(noDotName) && source.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace("-", "_");
        if (!name.equals(noHyphenName) && source.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotAndHyphenName = noDotName.replace("-", "_");
        if (!name.equals(noDotAndHyphenName) && source.containsKey(noDotAndHyphenName)) {
            return noDotAndHyphenName;
        }
        return null;
    }

    static {
        Properties systemProperties = System.getProperties();
        systemProperties.entrySet().forEach(systemPropertiesEntry -> {
            String key = systemPropertiesEntry.getKey().toString();
            String value = systemPropertiesEntry.getValue() == null ? null : systemPropertiesEntry.getValue().toString();
            SYSTEM_PROPERTIES_SOURCEMAP.put(key, value);
        });
        SYSTEM_ENV_SOURCEMAP.putAll(System.getenv());
    }
}

