/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.browser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Browser;
import org.aoju.lancia.Page;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.EventHandler;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.page.Target;
import org.aoju.lancia.option.ChromeArgOptions;
import org.aoju.lancia.worker.Connection;

public class Context
extends EventEmitter {
    private static final Map<String, String> webPermissionToProtocol = new HashMap<String, String>(32);
    private Connection connection;
    private Browser browser;
    private String id;

    public Context() {
    }

    public Context(Connection connection, Browser browser, String contextId) {
        this.connection = connection;
        this.browser = browser;
        this.id = contextId;
    }

    public void onTargetchanged(EventHandler<Target> handler) {
        this.on(Events.BROWSERCONTEXT_TARGETCHANGED.getName(), handler);
    }

    public void onTrgetcreated(EventHandler<Target> handler) {
        this.on(Events.BROWSERCONTEXT_TARGETCREATED.getName(), handler);
    }

    public void clearPermissionOverrides() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("browserContextId", this.id);
        this.connection.send("Browser.resetPermissions", params, true);
    }

    public void close() {
        Assert.isTrue(StringKit.isNotEmpty(this.id), "Non-incognito profiles cannot be closed!", new Object[0]);
        this.browser.disposeContext(this.id);
    }

    public boolean isIncognito() {
        return StringKit.isNotEmpty(this.id);
    }

    public void overridePermissions(String origin, List<String> permissions) {
        permissions.replaceAll(item -> {
            String protocolPermission = webPermissionToProtocol.get(item);
            Assert.isTrue(protocolPermission != null, "Unknown permission: " + item, new Object[0]);
            return protocolPermission;
        });
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("origin", origin);
        params.put("browserContextId", this.id);
        params.put("permissions", permissions);
        this.connection.send("Browser.grantPermissions", params, true);
    }

    public List<Page> pages() {
        return this.targets().stream().filter(target -> "page".equals(target.type())).map(Target::page).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Target> targets() {
        return this.browser.targets().stream().filter(target -> target.browserContext() == this).collect(Collectors.toList());
    }

    public Target waitForTarget(Predicate<Target> predicate, ChromeArgOptions options) {
        return this.browser.waitForTarget(target -> target.browserContext() == this && predicate.test((Target)target), options);
    }

    public Browser browser() {
        return this.browser;
    }

    public Page newPage() {
        return this.browser.createPageInContext(this.id);
    }

    static {
        webPermissionToProtocol.put("geolocation", "geolocation");
        webPermissionToProtocol.put("midi", "midi");
        webPermissionToProtocol.put("notifications", "notifications");
        webPermissionToProtocol.put("push", "push");
        webPermissionToProtocol.put("camera", "videoCapture");
        webPermissionToProtocol.put("microphone", "audioCapture");
        webPermissionToProtocol.put("background-sync", "backgroundSync");
        webPermissionToProtocol.put("ambient-light-sensor", "sensors");
        webPermissionToProtocol.put("accelerometer", "sensors");
        webPermissionToProtocol.put("gyroscope", "sensors");
        webPermissionToProtocol.put("magnetometer", "sensors");
        webPermissionToProtocol.put("accessibility-events", "accessibilityEvents");
        webPermissionToProtocol.put("clipboard-read", "clipboardRead");
        webPermissionToProtocol.put("payment-handler", "paymentHandler");
        webPermissionToProtocol.put("midi-sysex", "midiSysex");
    }
}

