/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.browser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Platform;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.BrowserListenerWrapper;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.option.ConnectionOptions;
import org.aoju.lancia.option.LaunchOptions;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.Transport;
import org.aoju.lancia.worker.TransportFactory;
import org.aoju.lancia.worker.exception.LaunchException;
import org.aoju.lancia.worker.exception.TimeoutException;

public class Runner
extends EventEmitter
implements AutoCloseable {
    private static final Pattern WS_ENDPOINT_PATTERN = Pattern.compile("^DevTools listening on (ws://.*)$");
    private static final List<Runner> runners = new ArrayList<Runner>();
    private static boolean isRegisterShutdownHook = false;
    private final String executablePath;
    private final List<String> processArguments;
    private final String tempDirectory;
    private final List<BrowserListenerWrapper> listeners = new ArrayList<BrowserListenerWrapper>();
    private Process process;
    private Connection connection;
    private boolean closed;

    public Runner(String executablePath, List<String> processArguments, String tempDirectory) {
        this.executablePath = executablePath;
        this.processArguments = processArguments;
        this.tempDirectory = tempDirectory;
        this.closed = true;
    }

    public void start(LaunchOptions options) throws IOException {
        if (this.process != null) {
            throw new RuntimeException("This process has previously been started.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executablePath);
        arguments.addAll(this.processArguments);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(arguments).redirectErrorStream(true);
        this.process = processBuilder.start();
        this.closed = false;
        this.registerHook();
        this.addProcessListener(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerHook() {
        runners.add(this);
        if (isRegisterShutdownHook) return;
        Class<Runner> clazz = Runner.class;
        synchronized (Runner.class) {
            if (isRegisterShutdownHook) return;
            RuntimeShutdownHookRegistry hook = new RuntimeShutdownHookRegistry();
            hook.register(new Thread(this::close));
            isRegisterShutdownHook = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addProcessListener(LaunchOptions options) {
        DefaultBrowserListener<Object> exitListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                Runner runner = (Runner)this.getTarget();
                runner.kill();
            }
        };
        exitListener.setMethod("exit");
        exitListener.setTarget(this);
        this.listeners.add(Builder.addEventListener(this, exitListener.getMethod(), exitListener));
        if (options.getHandleSIGINT()) {
            DefaultBrowserListener<Object> sigintListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    Runner runner = (Runner)this.getTarget();
                    runner.kill();
                }
            };
            sigintListener.setMethod("SIGINT");
            sigintListener.setTarget(this);
            this.listeners.add(Builder.addEventListener(this, sigintListener.getMethod(), sigintListener));
        }
        if (options.getHandleSIGTERM()) {
            DefaultBrowserListener<Object> sigtermListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    Runner runner = (Runner)this.getTarget();
                    runner.close();
                }
            };
            sigtermListener.setMethod("SIGTERM");
            sigtermListener.setTarget(this);
            this.listeners.add(Builder.addEventListener(this, sigtermListener.getMethod(), sigtermListener));
        }
        if (options.getHandleSIGHUP()) {
            DefaultBrowserListener<Object> sighubListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    Runner runner = (Runner)this.getTarget();
                    runner.close();
                }
            };
            sighubListener.setMethod("SIGHUP");
            sighubListener.setTarget(this);
            this.listeners.add(Builder.addEventListener(this, sighubListener.getMethod(), sighubListener));
        }
    }

    public void kill() {
        this.destroyForcibly();
        try {
            if (StringKit.isNotEmpty(this.tempDirectory)) {
                this.removeFolderByCmd(this.tempDirectory);
            }
        }
        catch (Exception e) {
            Logger.error("kill chrome process error ", e);
        }
    }

    public void destroyForcibly() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    private void removeFolderByCmd(String path) throws IOException, InterruptedException {
        if (StringKit.isEmpty(path) || "*".equals(path)) {
            return;
        }
        Process delProcess = null;
        if (Platform.isWindows()) {
            delProcess = Runtime.getRuntime().exec("cmd /c rd /s /q " + path);
        } else if (Platform.isLinux() || Platform.isMac()) {
            String[] cmd = new String[]{"/bin/sh", "-c", "rm -rf " + path};
            delProcess = Runtime.getRuntime().exec(cmd);
        }
        if (!delProcess.waitFor(10000L, TimeUnit.MILLISECONDS)) {
            delProcess.destroyForcibly();
        }
    }

    public Connection setUpConnection(boolean usePipe, int timeout, int slowMo, boolean dumpio, ConnectionOptions connectionOptions) throws InterruptedException {
        Connection connection = this.setUpConnection(usePipe, timeout, slowMo, dumpio);
        connection.setConnectionOptions(connectionOptions);
        return connection;
    }

    public Connection setUpConnection(boolean usePipe, int timeout, int slowMo, boolean dumpio) throws InterruptedException {
        if (!usePipe) {
            String waitForWSEndpoint = this.waitForWSEndpoint(timeout, dumpio);
            Transport transport = TransportFactory.create(waitForWSEndpoint);
            this.connection = new Connection(waitForWSEndpoint, transport, slowMo);
            Logger.info("Connect to browser by websocket url: " + waitForWSEndpoint, new Object[0]);
        }
        return this.connection;
    }

    private String waitForWSEndpoint(int timeout, boolean dumpio) {
        StreamReader reader = new StreamReader(timeout, dumpio, this.process.getInputStream());
        reader.start();
        return reader.getResult();
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void close() {
        Runner runner;
        for (int i = 0; i < runners.size() && !(runner = runners.get(i)).getClosed(); ++i) {
            if (runner.getConnection() != null && !runner.getConnection().getClosed()) {
                runner.getConnection().send("Browser.close", null, false);
            }
            if (!StringKit.isNotEmpty(runner.getTempDirectory())) continue;
            runner.kill();
        }
    }

    public void closeQuietly() {
        if (this.getClosed()) {
            return;
        }
        Builder.removeEventListeners(this.listeners);
        if (this.connection != null && !this.connection.getClosed()) {
            this.connection.send("Browser.close", null, false);
        }
        if (StringKit.isNotEmpty(this.tempDirectory)) {
            this.kill();
        }
        this.closed = true;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static class RuntimeShutdownHookRegistry
    implements ShutdownHookRegistry {
    }

    static class StreamReader {
        private final StringBuilder ws = new StringBuilder();
        private final AtomicBoolean success = new AtomicBoolean(false);
        private final AtomicReference<String> chromeOutput = new AtomicReference<String>("");
        private final int timeout;
        private final boolean dumpio;
        private final InputStream inputStream;
        private Thread readThread;

        public StreamReader(int timeout, boolean dumpio, InputStream inputStream) {
            this.timeout = timeout;
            this.dumpio = dumpio;
            this.inputStream = inputStream;
        }

        public void start() {
            this.readThread = new Thread(() -> {
                StringBuilder chromeOutputBuilder = new StringBuilder();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.inputStream));
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher;
                        if (this.dumpio) {
                            System.out.println(line);
                        }
                        if ((matcher = WS_ENDPOINT_PATTERN.matcher(line)).find()) {
                            this.ws.append(matcher.group(1));
                            this.success.set(true);
                            break;
                        }
                        if (chromeOutputBuilder.length() != 0) {
                            chromeOutputBuilder.append(System.lineSeparator());
                        }
                        chromeOutputBuilder.append(line);
                        this.chromeOutput.set(chromeOutputBuilder.toString());
                    }
                }
                catch (Exception e) {
                    try {
                        Logger.error("Failed to launch the browser process!please see TROUBLESHOOTING: https://github.com/puppeteer/puppeteer/blob/master/docs/troubleshooting.md:", e);
                    }
                    catch (Throwable throwable) {
                        IoKit.close(reader);
                        throw throwable;
                    }
                    IoKit.close(reader);
                }
                IoKit.close(reader);
            });
            this.readThread.start();
        }

        public String getResult() {
            try {
                this.readThread.join(this.timeout);
                if (!this.success.get()) {
                    if (this.readThread != null) {
                        this.readThread = null;
                    }
                    throw new TimeoutException("Timed out after " + this.timeout + " ms while trying to connect to the browser!Chrome output: " + this.chromeOutput.get());
                }
            }
            catch (InterruptedException e) {
                if (this.readThread != null) {
                    this.readThread = null;
                }
                throw new RuntimeException("Interrupted while waiting for dev tools server.", e);
            }
            String url = this.ws.toString();
            if (StringKit.isEmpty(url)) {
                throw new LaunchException("Can't get WSEndpoint");
            }
            return url;
        }
    }

    public static interface ShutdownHookRegistry {
        default public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
        }

        default public void remove(Thread thread) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }
}

