/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.kernel.page.AXNode;
import org.aoju.lancia.kernel.page.ElementHandle;
import org.aoju.lancia.nimble.accessbility.SerializedAXNode;
import org.aoju.lancia.worker.CDPSession;

public class Accessibility {
    private final CDPSession client;

    public Accessibility(CDPSession client) {
        this.client = client;
    }

    public SerializedAXNode snapshot(boolean interestingOnly, ElementHandle root) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        String finalBackendNodeId;
        AXNode defaultRoot;
        JSONObject nodes = this.client.send("Accessibility.getFullAXTree", null, false);
        String backendNodeId = null;
        if (root != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objectId", root.getRemoteObject().getObjectId());
            JSONObject node = this.client.send("DOM.describeNode", params, true);
            backendNodeId = node.getString("backendNodeId");
        }
        List list = (List)nodes.toJavaObject((TypeReference)new TypeReference<List<JSONObject>>(){});
        Iterator elements = list.iterator();
        ArrayList<org.aoju.lancia.nimble.accessbility.AXNode> payloads = new ArrayList<org.aoju.lancia.nimble.accessbility.AXNode>();
        while (elements.hasNext()) {
            payloads.add((org.aoju.lancia.nimble.accessbility.AXNode)JSON.toJavaObject((JSON)((JSON)elements.next()), org.aoju.lancia.nimble.accessbility.AXNode.class));
        }
        AXNode needle = defaultRoot = AXNode.createTree(payloads);
        if (StringKit.isNotEmpty(backendNodeId) && (needle = defaultRoot.find(arg_0 -> Accessibility.lambda$snapshot$0(finalBackendNodeId = backendNodeId, arg_0))) == null) {
            return null;
        }
        if (!interestingOnly) {
            return this.serializeTree(needle, null).get(0);
        }
        HashSet<AXNode> interestingNodes = new HashSet<AXNode>();
        this.collectInterestingNodes(interestingNodes, defaultRoot, false);
        if (!interestingNodes.contains(needle)) {
            return null;
        }
        return this.serializeTree(needle, interestingNodes).get(0);
    }

    private void collectInterestingNodes(Set<AXNode> collection, AXNode node, boolean insideControl) {
        if (node.isInteresting(insideControl)) {
            collection.add(node);
        }
        if (node.isLeafNode()) {
            return;
        }
        insideControl = insideControl || node.isControl();
        for (AXNode child : node.getChildren()) {
            this.collectInterestingNodes(collection, child, insideControl);
        }
    }

    public List<SerializedAXNode> serializeTree(AXNode node, Set<AXNode> whitelistedNodes) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        ArrayList<SerializedAXNode> children = new ArrayList<SerializedAXNode>();
        for (AXNode child : node.getChildren()) {
            children.addAll(this.serializeTree(child, whitelistedNodes));
        }
        if (CollKit.isNotEmpty(whitelistedNodes) && !whitelistedNodes.contains(node)) {
            return children;
        }
        SerializedAXNode serializedNode = node.serialize();
        if (CollKit.isNotEmpty(children)) {
            serializedNode.setChildren(children);
        }
        ArrayList<SerializedAXNode> result = new ArrayList<SerializedAXNode>();
        result.add(serializedNode);
        return result;
    }

    private static /* synthetic */ boolean lambda$snapshot$0(String finalBackendNodeId, AXNode node) {
        return finalBackendNodeId.equals("" + node.getPayload().getBackendDOMNodeId());
    }
}

