/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.BrowserListenerWrapper;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.kernel.page.Coverage;
import org.aoju.lancia.nimble.css.CSSStyleSheetHeader;
import org.aoju.lancia.nimble.css.Range;
import org.aoju.lancia.nimble.css.StyleSheetAddedPayload;
import org.aoju.lancia.nimble.profiler.CoverageEntry;
import org.aoju.lancia.nimble.profiler.CoverageRange;
import org.aoju.lancia.worker.CDPSession;

public class CSSCoverage {
    private final CDPSession client;
    private final HashMap<String, String> stylesheetURLs;
    private final HashMap<String, String> stylesheetSources;
    private final List<BrowserListenerWrapper> eventListeners;
    private boolean enabled;
    private boolean resetOnNavigation;

    public CSSCoverage(CDPSession client) {
        this.client = client;
        this.enabled = false;
        this.stylesheetURLs = new HashMap();
        this.stylesheetSources = new HashMap();
        this.eventListeners = new ArrayList<BrowserListenerWrapper>();
        this.resetOnNavigation = false;
    }

    public void start(boolean resetOnNavigation) {
        Assert.isTrue(!this.enabled, "CSSCoverage is already enabled", new Object[0]);
        this.resetOnNavigation = resetOnNavigation;
        this.enabled = true;
        this.stylesheetURLs.clear();
        this.stylesheetSources.clear();
        DefaultBrowserListener<StyleSheetAddedPayload> addLis = new DefaultBrowserListener<StyleSheetAddedPayload>(){

            @Override
            public void onBrowserEvent(StyleSheetAddedPayload event) {
                CSSCoverage cssCoverage = (CSSCoverage)this.getTarget();
                cssCoverage.onStyleSheet(event);
            }
        };
        addLis.setMethod("CSS.styleSheetAdded");
        addLis.setTarget(this);
        DefaultBrowserListener<Object> clearLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                CSSCoverage cssCoverage = (CSSCoverage)this.getTarget();
                cssCoverage.onExecutionContextsCleared();
            }
        };
        clearLis.setMethod("Runtime.executionContextsCleared");
        clearLis.setTarget(this);
        this.eventListeners.add(Builder.addEventListener(this.client, addLis.getMethod(), addLis));
        this.eventListeners.add(Builder.addEventListener(this.client, clearLis.getMethod(), clearLis));
        this.client.send("DOM.enable", null, false);
        this.client.send("CSS.enable", null, false);
        this.client.send("CSS.startRuleUsageTracking", null, true);
    }

    private void onExecutionContextsCleared() {
        if (!this.resetOnNavigation) {
            return;
        }
        this.stylesheetURLs.clear();
        this.stylesheetSources.clear();
    }

    private void onStyleSheet(StyleSheetAddedPayload event) {
        CSSStyleSheetHeader header = event.getHeader();
        if (StringKit.isEmpty(header.getSourceURL())) {
            return;
        }
        Builder.commonExecutor().submit(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("styleSheetId", header.getStyleSheetId());
            JSONObject response = this.client.send("CSS.getStyleSheetText", params, true);
            this.stylesheetURLs.put(header.getStyleSheetId(), header.getSourceURL());
            this.stylesheetSources.put(header.getStyleSheetId(), response.getString("text"));
        });
    }

    public List<CoverageEntry> stop() {
        Assert.isTrue(this.enabled, "CSSCoverage is not enabled", new Object[0]);
        this.enabled = false;
        JSONObject ruleTrackingResponse = this.client.send("CSS.stopRuleUsageTracking", null, true);
        this.client.send("CSS.disable", null, false);
        this.client.send("DOM.disable", null, false);
        Builder.removeEventListeners(this.eventListeners);
        HashMap styleSheetIdToCoverage = new HashMap();
        JSONObject ruleUsageNode = ruleTrackingResponse.getJSONObject("ruleUsage");
        for (String key : ruleUsageNode.keySet()) {
            boolean used;
            JSONObject entry = ruleUsageNode.getJSONObject(key);
            ArrayList<CoverageRange> ranges = (ArrayList<CoverageRange>)styleSheetIdToCoverage.get(entry.getString("styleSheetId"));
            if (ranges == null) {
                ranges = new ArrayList<CoverageRange>();
                styleSheetIdToCoverage.put(entry.getString("styleSheetId"), ranges);
            }
            if (used = entry.getBoolean("used").booleanValue()) {
                ranges.add(new CoverageRange(entry.getInteger("startOffset"), entry.getInteger("endOffset"), 1));
                continue;
            }
            ranges.add(new CoverageRange(entry.getInteger("startOffset"), entry.getInteger("endOffset"), 0));
        }
        ArrayList<CoverageEntry> coverage = new ArrayList<CoverageEntry>();
        for (String styleSheetId : this.stylesheetURLs.keySet()) {
            String url = this.stylesheetURLs.get(styleSheetId);
            String text = this.stylesheetSources.get(styleSheetId);
            List<Range> ranges = Coverage.convertToDisjointRanges((List)styleSheetIdToCoverage.get(styleSheetId));
            coverage.add(new CoverageEntry(url, ranges, text));
        }
        return coverage;
    }
}

