/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.lancia.kernel.page.CSSCoverage;
import org.aoju.lancia.kernel.page.JSCoverage;
import org.aoju.lancia.nimble.css.Point;
import org.aoju.lancia.nimble.css.Range;
import org.aoju.lancia.nimble.profiler.CoverageEntry;
import org.aoju.lancia.nimble.profiler.CoverageRange;
import org.aoju.lancia.worker.CDPSession;

public class Coverage {
    private final CSSCoverage cssCoverage;
    private final JSCoverage jsCoverage;

    public Coverage(CDPSession client) {
        this.cssCoverage = new CSSCoverage(client);
        this.jsCoverage = new JSCoverage(client);
    }

    public static List<Range> convertToDisjointRanges(List<CoverageRange> nestedRanges) {
        ArrayList<Point> points = new ArrayList<Point>();
        if (CollKit.isNotEmpty(nestedRanges)) {
            for (CoverageRange range2 : nestedRanges) {
                points.add(Coverage.createPoint(range2.getStartOffset(), 0, range2));
                points.add(Coverage.createPoint(range2.getStartOffset(), 1, range2));
            }
        }
        points.sort((a, b) -> {
            if (a.getOffset() != b.getOffset()) {
                return a.getOffset() - b.getOffset();
            }
            if (a.getType() != b.getType()) {
                return b.getType() - a.getType();
            }
            int aLength = a.getRange().getEndOffset() - a.getRange().getStartOffset();
            int bLength = b.getRange().getEndOffset() - b.getRange().getStartOffset();
            if (a.getType() == 0) {
                return bLength - aLength;
            }
            return aLength - bLength;
        });
        LinkedList<Integer> hitCountStack = new LinkedList<Integer>();
        ArrayList<Range> results = new ArrayList<Range>();
        int lastOffset = 0;
        for (Point point : points) {
            if (hitCountStack.size() > 0 && lastOffset < point.getOffset() && (Integer)hitCountStack.get(hitCountStack.size() - 1) > 0) {
                Range lastResult;
                Range range3 = lastResult = results.size() > 0 ? (Range)results.get(results.size() - 1) : null;
                if (lastResult != null && lastResult.getEnd() == lastOffset) {
                    lastResult.setEnd(point.getOffset());
                } else {
                    results.add(Coverage.createRange(lastOffset, point.getOffset()));
                }
            }
            lastOffset = point.getOffset();
            if (point.getType() == 0) {
                hitCountStack.addLast(point.getRange().getCount());
                continue;
            }
            hitCountStack.poll();
        }
        return results.stream().filter(range -> range.getEnd() - range.getStart() > 1).collect(Collectors.toList());
    }

    private static Point createPoint(int startOffset, int type, CoverageRange range) {
        return new Point(startOffset, type, range);
    }

    private static Range createRange(int start, int end) {
        return new Range(start, end);
    }

    public void startJSCoverage() {
        this.jsCoverage.start(true, false);
    }

    public void startJSCoverage(boolean resetOnNavigation, boolean reportAnonymousScripts) {
        this.jsCoverage.start(resetOnNavigation, reportAnonymousScripts);
    }

    public List<CoverageEntry> stopJSCoverage() {
        return this.jsCoverage.stop();
    }

    public void startCSSCoverage() {
        this.cssCoverage.start(true);
    }

    public void startCSSCoverage(boolean resetOnNavigation) {
        this.cssCoverage.start(resetOnNavigation);
    }

    public List<CoverageEntry> stopCSSCoverage() {
        return this.cssCoverage.stop();
    }
}

