/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import java.util.HashMap;
import java.util.concurrent.Future;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Builder;
import org.aoju.lancia.nimble.log.DialogType;
import org.aoju.lancia.worker.CDPSession;

public class Dialog {
    private CDPSession client;
    private String type;
    private String message;
    private String defaultValue = "";
    private boolean handled;

    public Dialog() {
    }

    public Dialog(CDPSession client, DialogType type, String message, String defaultValue) {
        this.client = client;
        this.type = type.getType();
        this.message = message;
        this.handled = false;
        if (StringKit.isNotEmpty(defaultValue)) {
            this.defaultValue = defaultValue;
        }
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Future<Boolean> accept(String promptText) {
        return Builder.commonExecutor().submit(() -> {
            try {
                Assert.isTrue(!this.handled, "Cannot accept dialog which is already handled!", new Object[0]);
                this.handled = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("accept", true);
                params.put("promptText", promptText);
                this.client.send("Page.handleJavaScriptDialog", params, true);
            }
            catch (Exception e) {
                Logger.error("Dialog accept error ", e);
                return false;
            }
            return true;
        });
    }

    public Future<Boolean> dismiss() {
        return Builder.commonExecutor().submit(() -> {
            try {
                Assert.isTrue(!this.handled, "Cannot dismiss dialog which is already handled!", new Object[0]);
                this.handled = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("accept", false);
                this.client.send("Page.handleJavaScriptDialog", params, true);
            }
            catch (Exception e) {
                Logger.error("Dialog dismiss error ", e);
                return false;
            }
            return true;
        });
    }

    public String toString() {
        return "Dialog{type='" + this.type + "', message='" + this.message + "', defaultValue='" + this.defaultValue + "', handled=" + this.handled + "}";
    }
}

