/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import java.util.HashMap;
import org.aoju.lancia.kernel.page.Viewport;
import org.aoju.lancia.nimble.emulation.ScreenOrientation;
import org.aoju.lancia.worker.CDPSession;

public class EmulationManager {
    private final CDPSession client;
    private boolean emulatingMobile;
    private boolean hasTouch;

    public EmulationManager(CDPSession client) {
        this.client = client;
    }

    public boolean emulateViewport(Viewport viewport) {
        boolean mobile = viewport.getIsMobile();
        int width = viewport.getWidth();
        int height = viewport.getHeight();
        Number deviceScaleFactor = 1;
        if (viewport.getDeviceScaleFactor() != null && viewport.getDeviceScaleFactor().intValue() != 0) {
            deviceScaleFactor = viewport.getDeviceScaleFactor();
        }
        ScreenOrientation screenOrientation = new ScreenOrientation();
        if (viewport.getIsLandscape()) {
            screenOrientation.setAngle(90);
            screenOrientation.setType("'landscapePrimary");
        } else {
            screenOrientation.setAngle(0);
            screenOrientation.setType("portraitPrimary");
        }
        boolean hasTouch = viewport.getHasTouch();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mobile", mobile);
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("screenOrientation", screenOrientation);
        this.client.send("Emulation.setDeviceMetricsOverride", params, false);
        params.clear();
        params.put("enabled", hasTouch);
        this.client.send("Emulation.setTouchEmulationEnabled", params, true);
        boolean reloadNeeded = this.emulatingMobile != mobile || this.hasTouch != hasTouch;
        this.emulatingMobile = mobile;
        this.hasTouch = hasTouch;
        return reloadNeeded;
    }
}

