/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.kernel.page.DOMWorld;
import org.aoju.lancia.kernel.page.ElementHandle;
import org.aoju.lancia.kernel.page.Frame;
import org.aoju.lancia.kernel.page.JSHandle;
import org.aoju.lancia.nimble.PageEvaluateType;
import org.aoju.lancia.nimble.runtime.ExceptionDetails;
import org.aoju.lancia.nimble.runtime.ExecutionContextDescription;
import org.aoju.lancia.nimble.runtime.RemoteObject;
import org.aoju.lancia.worker.CDPSession;

public class ExecutionContext {
    public static final String EVALUATION_SCRIPT_URL = "__puppeteer_evaluation_script__";
    public static final Pattern SOURCE_URL_REGEX = Pattern.compile("^[\\040\\t]*//[@#] sourceURL=\\s*(\\S*?)\\s*$", 8);
    private final int contextId;
    private CDPSession client;
    private DOMWorld world;

    public ExecutionContext(CDPSession client, ExecutionContextDescription contextPayload, DOMWorld world) {
        this.client = client;
        this.world = world;
        this.contextId = contextPayload.getId();
    }

    public Frame frame() {
        return this.world != null ? this.world.frame() : null;
    }

    public DOMWorld getWorld() {
        return this.world;
    }

    public void setWorld(DOMWorld world) {
        this.world = world;
    }

    public ElementHandle adoptElementHandle(ElementHandle elementHandle) {
        Assert.isTrue(elementHandle.executionContext() != this, "Cannot adopt handle that already belongs to this execution context", new Object[0]);
        Assert.isTrue(this.world != null, "Cannot adopt handle without DOMWorld", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objectId", elementHandle.getRemoteObject().getObjectId());
        JSONObject nodeInfo = this.client.send("DOM.describeNode", params, true);
        return this.adoptBackendNodeId(nodeInfo.getJSONObject("node").getInteger("backendNodeId"));
    }

    public Object evaluateHandle(String pageFunction, List<Object> args) {
        return this.evaluateInternal(false, pageFunction, Builder.isFunction(pageFunction) ? PageEvaluateType.FUNCTION : PageEvaluateType.STRING, args);
    }

    public Object evaluate(String pageFunction, List<Object> args) {
        return this.evaluateInternal(true, pageFunction, Builder.isFunction(pageFunction) ? PageEvaluateType.FUNCTION : PageEvaluateType.STRING, args);
    }

    private Object evaluateInternal(boolean returnByValue, String pageFunction, PageEvaluateType type, List<Object> args) {
        JSONObject callFunctionOnPromise;
        String suffix = "//# sourceURL=__puppeteer_evaluation_script__";
        if (PageEvaluateType.STRING.equals((Object)type)) {
            int contextId = this.contextId;
            String expression = pageFunction;
            String expressionWithSourceUrl = SOURCE_URL_REGEX.matcher(expression).find() ? expression : expression + "\n" + suffix;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("expression", expressionWithSourceUrl);
            params.put("contextId", contextId);
            params.put("returnByValue", returnByValue);
            params.put("awaitPromise", true);
            params.put("userGesture", true);
            JSONObject result = this.client.send("Runtime.evaluate", params, true);
            JSONObject exceptionDetails = result.getJSONObject("exceptionDetails");
            if (exceptionDetails != null) {
                throw new RuntimeException("Evaluation failed: " + Builder.getExceptionMessage((ExceptionDetails)JSON.toJavaObject((JSON)exceptionDetails, ExceptionDetails.class)));
            }
            RemoteObject remoteObject = (RemoteObject)JSON.toJavaObject((JSON)result.getJSONObject("result"), RemoteObject.class);
            return returnByValue ? Builder.valueFromRemoteObject(remoteObject) : this.createJSHandle(this, remoteObject);
        }
        if (!PageEvaluateType.FUNCTION.equals((Object)type)) {
            throw new IllegalArgumentException("Expected to get |string| or |function| as the first argument, but got " + type.name() + " instead.");
        }
        String functionText = pageFunction;
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> argList = new ArrayList<Object>();
        if (CollKit.isNotEmpty(args)) {
            for (Object arg : args) {
                argList.add(this.convertArgument(this, arg));
            }
        }
        params.put("functionDeclaration", functionText + "\n" + suffix + "\n");
        params.put("executionContextId", this.contextId);
        params.put("arguments", argList);
        params.put("returnByValue", returnByValue);
        params.put("awaitPromise", true);
        params.put("userGesture", true);
        try {
            callFunctionOnPromise = this.client.send("Runtime.callFunctionOn", params, true);
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Converting circular structure to JSON")) {
                throw new RuntimeException(e.getMessage() + " Are you passing a nested JSHandle?");
            }
            throw new RuntimeException(e);
        }
        if (callFunctionOnPromise == null) {
            return null;
        }
        JSONObject exceptionDetails = callFunctionOnPromise.getJSONObject("exceptionDetails");
        if (exceptionDetails != null) {
            throw new RuntimeException("Evaluation failed: " + Builder.getExceptionMessage((ExceptionDetails)JSON.toJavaObject((JSON)exceptionDetails, ExceptionDetails.class)));
        }
        RemoteObject remoteObject = (RemoteObject)JSON.toJavaObject((JSON)callFunctionOnPromise.getJSONObject("result"), RemoteObject.class);
        return returnByValue ? Builder.valueFromRemoteObject(remoteObject) : this.createJSHandle(this, remoteObject);
    }

    public JSHandle queryObjects(JSHandle prototypeHandle) {
        Assert.isTrue(!prototypeHandle.getDisposed(), "Prototype JSHandle is disposed!", new Object[0]);
        Assert.isTrue(StringKit.isNotEmpty(prototypeHandle.getRemoteObject().getObjectId()), "Prototype JSHandle must not be referencing primitive value", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prototypeObjectId", prototypeHandle.getRemoteObject().getObjectId());
        JSONObject response = this.client.send("Runtime.queryObjects", params, true);
        return this.createJSHandle(this, (RemoteObject)JSON.toJavaObject((JSON)response.getJSONObject("objects"), RemoteObject.class));
    }

    public Object convertArgument(ExecutionContext th, Object arg) {
        JSHandle objectHandle;
        JSONObject objectNode = new JSONObject();
        if (arg == null) {
            return null;
        }
        if (arg instanceof BigInteger) {
            return objectNode.put("unserializableValue", (Object)(String.valueOf(arg) + "n"));
        }
        if ("-0".equals(arg)) {
            return objectNode.put("unserializableValue", (Object)"-0");
        }
        if ("Infinity".equals(arg)) {
            return objectNode.put("unserializableValue", (Object)"Infinity");
        }
        if ("-Infinity".equals(arg)) {
            return objectNode.put("unserializableValue", (Object)"-Infinity");
        }
        if ("NaN".equals(arg)) {
            return objectNode.put("unserializableValue", (Object)"NaN");
        }
        JSHandle jSHandle = objectHandle = arg instanceof JSHandle ? (JSHandle)arg : null;
        if (objectHandle != null) {
            if (objectHandle.getContext() != this) {
                throw new IllegalArgumentException("JSHandles can be evaluated only in the context they were created!");
            }
            if (objectHandle.getDisposed()) {
                throw new IllegalArgumentException("JSHandle is disposed!");
            }
            if (objectHandle.getRemoteObject().getUnserializableValue() != null) {
                return objectNode.put("unserializableValue", (Object)objectHandle.getRemoteObject().getUnserializableValue());
            }
            if (StringKit.isEmpty(objectHandle.getRemoteObject().getObjectId())) {
                return objectNode.put("value", objectHandle.getRemoteObject().getValue());
            }
            return objectNode.put("objectId", (Object)objectHandle.getRemoteObject().getObjectId());
        }
        return objectNode.put("value", arg);
    }

    private JSHandle createJSHandle(ExecutionContext executionContext, RemoteObject remoteObject) {
        return JSHandle.createJSHandle(executionContext, remoteObject);
    }

    public ElementHandle adoptBackendNodeId(int backendNodeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("backendNodeId", backendNodeId);
        params.put("executionContextId", this.contextId);
        JSONObject object = this.client.send("DOM.resolveNode", params, true);
        return (ElementHandle)this.createJSHandle(this, (RemoteObject)JSON.toJavaObject((JSON)object.getJSONObject("object"), RemoteObject.class));
    }

    public CDPSession getClient() {
        return this.client;
    }

    public void setClient(CDPSession client) {
        this.client = client;
    }

    public int getContextId() {
        return this.contextId;
    }
}

