/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.lancia.kernel.page.ElementHandle;
import org.aoju.lancia.nimble.page.FileChooserOpenedPayload;
import org.aoju.lancia.worker.CDPSession;

public class FileChooser {
    private CDPSession client;
    private ElementHandle element;
    private boolean handled;
    private boolean multiple;

    public FileChooser() {
    }

    public FileChooser(CDPSession client, ElementHandle element, FileChooserOpenedPayload event) {
        this.client = client;
        this.element = element;
        this.multiple = !"selectSingle".equals(event.getMode());
        this.handled = false;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void accept(List<String> filePaths) {
        Assert.isTrue(!this.handled, "Cannot accept FileChooser which is already handled!", new Object[0]);
        this.handled = true;
        this.element.uploadFile(filePaths);
    }

    public void cancel() {
        Assert.isTrue(!this.handled, "Cannot cancel FileChooser which is already handled!", new Object[0]);
        this.handled = true;
    }
}

