/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Page;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.page.DOMWorld;
import org.aoju.lancia.kernel.page.ExecutionContext;
import org.aoju.lancia.kernel.page.Frame;
import org.aoju.lancia.kernel.page.FrameTree;
import org.aoju.lancia.kernel.page.LifecycleWatcher;
import org.aoju.lancia.kernel.page.NavigateResult;
import org.aoju.lancia.kernel.page.NetworkManager;
import org.aoju.lancia.kernel.page.Response;
import org.aoju.lancia.kernel.page.TimeoutSettings;
import org.aoju.lancia.nimble.page.FrameAttachedPayload;
import org.aoju.lancia.nimble.page.FrameDetachedPayload;
import org.aoju.lancia.nimble.page.FrameNavigatedPayload;
import org.aoju.lancia.nimble.page.FramePayload;
import org.aoju.lancia.nimble.page.FrameStoppedLoadingPayload;
import org.aoju.lancia.nimble.page.LifecycleEventPayload;
import org.aoju.lancia.nimble.page.NavigatedWithinDocumentPayload;
import org.aoju.lancia.nimble.runtime.ExecutionContextCreatedPayload;
import org.aoju.lancia.nimble.runtime.ExecutionContextDescription;
import org.aoju.lancia.nimble.runtime.ExecutionContextDestroyedPayload;
import org.aoju.lancia.option.PageNavigateOptions;
import org.aoju.lancia.worker.CDPSession;
import org.aoju.lancia.worker.exception.NavigateException;
import org.aoju.lancia.worker.exception.TimeoutException;

public class FrameManager
extends EventEmitter {
    private static final String UTILITY_WORLD_NAME = "__puppeteer_utility_world__";
    private final CDPSession client;
    private final TimeoutSettings timeoutSettings;
    private final NetworkManager networkManager;
    private final Map<String, Frame> frames;
    private final Map<Integer, ExecutionContext> contextIdToContext;
    private final Set<String> isolatedWorlds;
    private Page page;
    private Frame mainFrame;
    private CountDownLatch documentLatch;
    private CountDownLatch contentLatch;
    private String navigateResult;
    private boolean ensureNewDocumentNavigation;
    private String documentNavigationPromiseType = null;

    public FrameManager(CDPSession client, Page page, boolean ignoreHTTPSErrors, TimeoutSettings timeoutSettings) {
        this.client = client;
        this.page = page;
        this.networkManager = new NetworkManager(client, ignoreHTTPSErrors, this);
        this.timeoutSettings = timeoutSettings;
        this.frames = new HashMap<String, Frame>();
        this.contextIdToContext = new HashMap<Integer, ExecutionContext>();
        this.isolatedWorlds = new HashSet<String>();
        DefaultBrowserListener<FrameAttachedPayload> frameAttachedListener = new DefaultBrowserListener<FrameAttachedPayload>(){

            @Override
            public void onBrowserEvent(FrameAttachedPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onFrameAttached(event.getFrameId(), event.getParentFrameId());
            }
        };
        frameAttachedListener.setTarget(this);
        frameAttachedListener.setMethod("Page.frameAttached");
        this.client.addListener(frameAttachedListener.getMethod(), frameAttachedListener);
        DefaultBrowserListener<FrameNavigatedPayload> frameNavigatedListener = new DefaultBrowserListener<FrameNavigatedPayload>(){

            @Override
            public void onBrowserEvent(FrameNavigatedPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onFrameNavigated(event.getFrame());
            }
        };
        frameNavigatedListener.setTarget(this);
        frameNavigatedListener.setMethod("Page.frameNavigated");
        this.client.addListener(frameNavigatedListener.getMethod(), frameNavigatedListener);
        DefaultBrowserListener<NavigatedWithinDocumentPayload> navigatedWithinDocumentListener = new DefaultBrowserListener<NavigatedWithinDocumentPayload>(){

            @Override
            public void onBrowserEvent(NavigatedWithinDocumentPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onFrameNavigatedWithinDocument(event.getFrameId(), event.getUrl());
            }
        };
        navigatedWithinDocumentListener.setTarget(this);
        navigatedWithinDocumentListener.setMethod("Page.navigatedWithinDocument");
        this.client.addListener(navigatedWithinDocumentListener.getMethod(), navigatedWithinDocumentListener);
        DefaultBrowserListener<FrameDetachedPayload> frameDetachedListener = new DefaultBrowserListener<FrameDetachedPayload>(){

            @Override
            public void onBrowserEvent(FrameDetachedPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onFrameDetached(event.getFrameId());
            }
        };
        frameDetachedListener.setTarget(this);
        frameDetachedListener.setMethod("Page.frameDetached");
        this.client.addListener(frameDetachedListener.getMethod(), frameDetachedListener);
        DefaultBrowserListener<FrameStoppedLoadingPayload> frameStoppedLoadingListener = new DefaultBrowserListener<FrameStoppedLoadingPayload>(){

            @Override
            public void onBrowserEvent(FrameStoppedLoadingPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onFrameStoppedLoading(event.getFrameId());
            }
        };
        frameStoppedLoadingListener.setTarget(this);
        frameStoppedLoadingListener.setMethod("Page.frameStoppedLoading");
        this.client.addListener(frameStoppedLoadingListener.getMethod(), frameStoppedLoadingListener);
        DefaultBrowserListener<ExecutionContextCreatedPayload> executionContextCreatedListener = new DefaultBrowserListener<ExecutionContextCreatedPayload>(){

            @Override
            public void onBrowserEvent(ExecutionContextCreatedPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onExecutionContextCreated(event.getContext());
            }
        };
        executionContextCreatedListener.setTarget(this);
        executionContextCreatedListener.setMethod("Runtime.executionContextCreated");
        this.client.addListener(executionContextCreatedListener.getMethod(), executionContextCreatedListener);
        DefaultBrowserListener<ExecutionContextDestroyedPayload> executionContextDestroyedListener = new DefaultBrowserListener<ExecutionContextDestroyedPayload>(){

            @Override
            public void onBrowserEvent(ExecutionContextDestroyedPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onExecutionContextDestroyed(event.getExecutionContextId());
            }
        };
        executionContextDestroyedListener.setTarget(this);
        executionContextDestroyedListener.setMethod("Runtime.executionContextDestroyed");
        this.client.addListener(executionContextDestroyedListener.getMethod(), executionContextDestroyedListener);
        DefaultBrowserListener<Object> executionContextsClearedListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onExecutionContextsCleared();
            }
        };
        executionContextsClearedListener.setTarget(this);
        executionContextsClearedListener.setMethod("Runtime.executionContextsCleared");
        this.client.addListener(executionContextsClearedListener.getMethod(), executionContextsClearedListener);
        DefaultBrowserListener<LifecycleEventPayload> lifecycleEventListener = new DefaultBrowserListener<LifecycleEventPayload>(){

            @Override
            public void onBrowserEvent(LifecycleEventPayload event) {
                FrameManager frameManager = (FrameManager)this.getTarget();
                frameManager.onLifecycleEvent(event);
            }
        };
        lifecycleEventListener.setTarget(this);
        lifecycleEventListener.setMethod("Page.lifecycleEvent");
        this.client.addListener(lifecycleEventListener.getMethod(), lifecycleEventListener);
    }

    private void onLifecycleEvent(LifecycleEventPayload event) {
        Frame frame = this.frames.get(event.getFrameId());
        if (frame == null) {
            return;
        }
        frame.onLifecycleEvent(event.getLoaderId(), event.getName());
        this.emit(Events.FRAME_MANAGER_LIFECYCLE_EVENT.getName(), frame);
    }

    private void onExecutionContextsCleared() {
        for (ExecutionContext context : this.contextIdToContext.values()) {
            if (context.getWorld() == null) continue;
            context.getWorld().setContext(null);
        }
        this.contextIdToContext.clear();
    }

    private void onExecutionContextDestroyed(int executionContextId) {
        ExecutionContext context = this.contextIdToContext.get(executionContextId);
        if (context == null) {
            return;
        }
        this.contextIdToContext.remove(executionContextId);
        if (context.getWorld() != null) {
            context.getWorld().setContext(null);
        }
    }

    public ExecutionContext executionContextById(int contextId) {
        ExecutionContext context = this.contextIdToContext.get(contextId);
        Assert.isTrue(context != null, "INTERNAL ERROR: missing context with id = " + contextId, new Object[0]);
        return context;
    }

    private void onExecutionContextCreated(ExecutionContextDescription contextPayload) {
        String frameId = contextPayload.getAuxData() != null ? contextPayload.getAuxData().getFrameId() : null;
        Frame frame = this.frames.get(frameId);
        DOMWorld world = null;
        if (frame != null) {
            if (contextPayload.getAuxData() != null && contextPayload.getAuxData().getIsDefault()) {
                world = frame.getMainWorld();
            } else if (contextPayload.getName().equals(UTILITY_WORLD_NAME) && !frame.getSecondaryWorld().hasContext()) {
                world = frame.getSecondaryWorld();
            }
        }
        if (contextPayload.getAuxData() != null && "isolated".equals(contextPayload.getAuxData().getType())) {
            this.isolatedWorlds.add(contextPayload.getName());
        }
        ExecutionContext context = new ExecutionContext(this.client, contextPayload, world);
        if (world != null) {
            world.setContext(context);
        }
        this.contextIdToContext.put(contextPayload.getId(), context);
    }

    private void onFrameStoppedLoading(String frameId) {
        Frame frame = this.frames.get(frameId);
        if (frame == null) {
            return;
        }
        frame.onLoadingStopped();
        this.emit(Events.FRAME_MANAGER_LIFECYCLE_EVENT.getName(), frame);
    }

    private void onFrameDetached(String frameId) {
        Frame frame = this.frames.get(frameId);
        if (frame != null) {
            this.removeFramesRecursively(frame);
        }
    }

    private void onFrameNavigatedWithinDocument(String frameId, String url) {
        Frame frame = this.frames.get(frameId);
        if (frame == null) {
            return;
        }
        frame.navigatedWithinDocument(url);
        this.emit(Events.FRAME_MANAGER_FRAME_NAVIGATED_WITHIN_DOCUMENT.getName(), frame);
        this.emit(Events.FRAME_MANAGER_FRAME_NAVIGATED.getName(), frame);
    }

    public void initialize() {
        this.client.send("Page.enable", null, false);
        JSONObject result = this.client.send("Page.getFrameTree", null, true);
        FrameTree frameTree = (FrameTree)JSON.toJavaObject((JSON)result.getJSONObject("frameTree"), FrameTree.class);
        this.handleFrameTree(frameTree);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", true);
        this.client.send("Page.setLifecycleEventsEnabled", params, false);
        this.client.send("Runtime.enable", null, true);
        this.ensureIsolatedWorld(UTILITY_WORLD_NAME);
        this.networkManager.initialize();
    }

    private void ensureIsolatedWorld(String name) {
        if (this.isolatedWorlds.contains(name)) {
            return;
        }
        this.isolatedWorlds.add(name);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("source", "//# sourceURL=__puppeteer_evaluation_script__");
        params.put("worldName", name);
        this.client.send("Page.addScriptToEvaluateOnNewDocument", params, true);
        this.frames().forEach(frame -> {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("frameId", frame.getId());
            param.put("grantUniveralAccess", true);
            param.put("worldName", name);
            this.client.send("Page.createIsolatedWorld", param, true);
        });
    }

    private void handleFrameTree(FrameTree frameTree) {
        if (StringKit.isNotEmpty(frameTree.getFrame().getParentId())) {
            this.onFrameAttached(frameTree.getFrame().getId(), frameTree.getFrame().getParentId());
        }
        this.onFrameNavigated(frameTree.getFrame());
        if (CollKit.isEmpty(frameTree.getChildFrames())) {
            return;
        }
        for (FrameTree child : frameTree.getChildFrames()) {
            this.handleFrameTree(child);
        }
    }

    private void onFrameAttached(String frameId, String parentFrameId) {
        if (this.frames.get(frameId) != null) {
            return;
        }
        Assert.isTrue(StringKit.isNotEmpty(parentFrameId), "parentFrameId is null", new Object[0]);
        Frame parentFrame = this.frames.get(parentFrameId);
        Frame frame = new Frame(this, this.client, parentFrame, frameId);
        this.frames.put(frame.getId(), frame);
        this.emit(Events.FRAME_MANAGER_FRAME_ATTACHED.getName(), frame);
    }

    private void onFrameNavigated(FramePayload framePayload) {
        boolean isMainFrame = StringKit.isEmpty(framePayload.getParentId());
        Frame frame = isMainFrame ? this.mainFrame : this.frames.get(framePayload.getId());
        Assert.isTrue(isMainFrame || frame != null, "We either navigate top level or have old version of the navigated frame", new Object[0]);
        if (frame != null && CollKit.isNotEmpty(frame.getChildFrames())) {
            for (Frame childFrame : frame.getChildFrames()) {
                this.removeFramesRecursively(childFrame);
            }
        }
        if (isMainFrame) {
            if (frame != null) {
                this.frames.remove(frame.getId());
                frame.setId(framePayload.getId());
            } else {
                frame = new Frame(this, this.client, null, framePayload.getId());
            }
            this.frames.put(framePayload.getId(), frame);
            this.mainFrame = frame;
        }
        frame.navigated(framePayload);
        this.emit(Events.FRAME_MANAGER_FRAME_NAVIGATED.getName(), frame);
    }

    public List<Frame> frames() {
        if (this.frames.isEmpty()) {
            return new ArrayList<Frame>();
        }
        return new ArrayList<Frame>(this.frames.values());
    }

    private void removeFramesRecursively(Frame childFrame) {
        if (CollKit.isNotEmpty(childFrame.getChildFrames())) {
            for (Frame frame : childFrame.getChildFrames()) {
                this.removeFramesRecursively(frame);
            }
        }
        childFrame.detach();
        this.frames.remove(childFrame.getId());
        this.emit(Events.FRAME_MANAGER_FRAME_DETACHED.getName(), childFrame);
    }

    public CDPSession getClient() {
        return this.client;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public Map<String, Frame> getFrames() {
        return this.frames;
    }

    public Map<Integer, ExecutionContext> getContextIdToContext() {
        return this.contextIdToContext;
    }

    public Set<String> getIsolatedWorlds() {
        return this.isolatedWorlds;
    }

    public Frame getMainFrame() {
        return this.mainFrame;
    }

    public Response navigateFrame(Frame frame, String url, PageNavigateOptions options, boolean isBlock) throws InterruptedException {
        int timeout;
        List<String> waitUntil;
        String referrer;
        if (options == null) {
            referrer = this.networkManager.extraHTTPHeaders().get("referer");
            waitUntil = new ArrayList<String>();
            waitUntil.add("load");
            timeout = this.timeoutSettings.navigationTimeout();
        } else {
            referrer = options.getReferer();
            if (StringKit.isEmpty(referrer)) {
                referrer = this.networkManager.extraHTTPHeaders().get("referer");
            }
            if (CollKit.isEmpty(waitUntil = options.getWaitUntil())) {
                waitUntil = new ArrayList<String>();
                waitUntil.add("load");
            }
            if ((timeout = options.getTimeout()) <= 0) {
                timeout = this.timeoutSettings.navigationTimeout();
            }
            this.assertNoLegacyNavigationOptions(waitUntil);
        }
        if (!isBlock) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("url", url);
            if (referrer != null) {
                params.put("referrer", referrer);
            }
            params.put("frameId", frame.getId());
            this.client.send("Page.navigate", params, false);
            return null;
        }
        LifecycleWatcher watcher = new LifecycleWatcher(this, frame, waitUntil, timeout);
        long start = System.currentTimeMillis();
        try {
            this.ensureNewDocumentNavigation = this.navigate(this.client, url, referrer, frame.getId(), timeout);
            if (NavigateResult.SUCCESS.getResult().equals(this.navigateResult)) {
                if (this.ensureNewDocumentNavigation) {
                    this.documentNavigationPromiseType = "new";
                    if (watcher.newDocumentNavigationPromise() != null) {
                        Response response = watcher.navigationResponse();
                        return response;
                    }
                } else {
                    this.documentNavigationPromiseType = "same";
                    if (watcher.sameDocumentNavigationPromise() != null) {
                        Response response = watcher.navigationResponse();
                        return response;
                    }
                }
                this.navigateResult = "";
                this.documentLatch = new CountDownLatch(1);
                long end = System.currentTimeMillis();
                boolean await = this.documentLatch.await((long)timeout - (end - start), TimeUnit.MILLISECONDS);
                if (!await) {
                    throw new TimeoutException("Navigation timeout of " + timeout + " ms exceeded at " + url);
                }
                if (NavigateResult.SUCCESS.getResult().equals(this.navigateResult)) {
                    Response response = watcher.navigationResponse();
                    return response;
                }
            }
            if (NavigateResult.TIMEOUT.getResult().equals(this.navigateResult)) {
                throw new TimeoutException("Navigation timeout of " + timeout + " ms exceeded at " + url);
            }
            if (NavigateResult.TERMINATION.getResult().equals(this.navigateResult)) {
                throw new NavigateException("Navigating frame was detached");
            }
            throw new NavigateException("Unkown result " + this.navigateResult);
        }
        finally {
            watcher.dispose();
        }
    }

    private boolean navigate(CDPSession client, String url, String referrer, String frameId, int timeout) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        if (referrer != null) {
            params.put("referrer", referrer);
        }
        params.put("frameId", frameId);
        try {
            JSONObject response = client.send("Page.navigate", params, true, null, timeout);
            this.setNavigateResult("success");
            if (response == null) {
                return false;
            }
            if (response.get((Object)"errorText") != null) {
                throw new InternalException(response.get((Object)"errorText").toString() + " at " + url);
            }
            if (response.get((Object)"loaderId") != null) {
                return true;
            }
        }
        catch (InternalException e) {
            this.setNavigateResult("timeout");
            Logger.error(e.getMessage(), new Object[0]);
        }
        return false;
    }

    public String getNavigateResult() {
        return this.navigateResult;
    }

    public void setNavigateResult(String navigateResult) {
        this.navigateResult = navigateResult;
    }

    public Frame getFrame(String frameId) {
        return this.frames.get(frameId);
    }

    public Frame frame(String frameId) {
        return this.frames.get(frameId);
    }

    public Response waitForFrameNavigation(Frame frame, PageNavigateOptions options, CountDownLatch reloadLatch) {
        int timeout;
        List<Object> waitUntil;
        if (options == null) {
            waitUntil = new ArrayList();
            waitUntil.add("load");
            timeout = this.timeoutSettings.navigationTimeout();
        } else {
            waitUntil = options.getWaitUntil();
            if (CollKit.isEmpty(waitUntil)) {
                waitUntil = new ArrayList();
                waitUntil.add("load");
            }
            if ((timeout = options.getTimeout()) <= 0) {
                timeout = this.timeoutSettings.navigationTimeout();
            }
            this.assertNoLegacyNavigationOptions(waitUntil);
        }
        this.documentNavigationPromiseType = "all";
        this.setNavigateResult(null);
        LifecycleWatcher watcher = new LifecycleWatcher(this, frame, waitUntil, timeout);
        if (watcher.newDocumentNavigationPromise() != null) {
            return watcher.navigationResponse();
        }
        if (watcher.sameDocumentNavigationPromise() != null) {
            return watcher.navigationResponse();
        }
        try {
            boolean await;
            this.documentLatch = new CountDownLatch(1);
            if (reloadLatch != null) {
                reloadLatch.countDown();
            }
            if (!(await = this.documentLatch.await(timeout, TimeUnit.MILLISECONDS))) {
                throw new TimeoutException("Navigation timeout of " + timeout + " ms exceeded");
            }
            if (NavigateResult.SUCCESS.getResult().equals(this.navigateResult)) {
                Response response = watcher.navigationResponse();
                return response;
            }
            try {
                if (NavigateResult.TIMEOUT.getResult().equals(this.navigateResult)) {
                    throw new TimeoutException("Navigation timeout of " + timeout + " ms exceeded");
                }
                if (NavigateResult.TERMINATION.getResult().equals(this.navigateResult)) {
                    throw new NavigateException("Navigating frame was detached");
                }
                throw new NavigateException("UnNokwn result " + this.navigateResult);
            }
            catch (InterruptedException e) {
                throw new NavigateException("UnNokwn result " + e.getMessage());
            }
        }
        finally {
            watcher.dispose();
        }
    }

    private void assertNoLegacyNavigationOptions(List<String> waitUtil) {
        Assert.isTrue(!"networkidle".equals(waitUtil.get(0)), "ERROR: \"networkidle\" option is no longer supported. Use \"networkidle2\" instead", new Object[0]);
    }

    public Frame mainFrame() {
        return this.mainFrame;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public String getDocumentNavigationPromiseType() {
        return this.documentNavigationPromiseType;
    }

    public void setDocumentNavigationPromiseType(String documentNavigationPromiseType) {
        this.documentNavigationPromiseType = documentNavigationPromiseType;
    }

    public CountDownLatch getDocumentLatch() {
        return this.documentLatch;
    }

    public void setDocumentLatch(CountDownLatch documentLatch) {
        this.documentLatch = documentLatch;
    }

    public CountDownLatch getContentLatch() {
        return this.contentLatch;
    }

    public void setContentLatch(CountDownLatch contentLatch) {
        this.contentLatch = contentLatch;
    }
}

