/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.BrowserListenerWrapper;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.kernel.page.Coverage;
import org.aoju.lancia.nimble.css.Range;
import org.aoju.lancia.nimble.debugger.ScriptParsedPayload;
import org.aoju.lancia.nimble.profiler.CoverageEntry;
import org.aoju.lancia.nimble.profiler.CoverageRange;
import org.aoju.lancia.nimble.profiler.FunctionCoverage;
import org.aoju.lancia.nimble.profiler.ScriptCoverage;
import org.aoju.lancia.nimble.profiler.TakePreciseCoverageReturnValue;
import org.aoju.lancia.worker.CDPSession;

public class JSCoverage {
    private final CDPSession client;
    private final Map<String, String> scriptSources;
    private final Map<String, String> scriptURLs;
    private final List<BrowserListenerWrapper> eventListeners;
    private boolean enabled;
    private boolean resetOnNavigation;
    private boolean reportAnonymousScripts;

    public JSCoverage(CDPSession client) {
        this.client = client;
        this.enabled = false;
        this.scriptURLs = new HashMap<String, String>();
        this.scriptSources = new HashMap<String, String>();
        this.eventListeners = new ArrayList<BrowserListenerWrapper>();
        this.resetOnNavigation = false;
    }

    public void start(boolean resetOnNavigation, boolean reportAnonymousScripts) {
        Assert.isTrue(!this.enabled, "JSCoverage is already enabled", new Object[0]);
        this.resetOnNavigation = resetOnNavigation;
        this.reportAnonymousScripts = reportAnonymousScripts;
        this.enabled = true;
        this.scriptURLs.clear();
        this.scriptSources.clear();
        DefaultBrowserListener<ScriptParsedPayload> scriptParsedLis = new DefaultBrowserListener<ScriptParsedPayload>(){

            @Override
            public void onBrowserEvent(ScriptParsedPayload event) {
                JSCoverage jsCoverage = (JSCoverage)this.getTarget();
                jsCoverage.onScriptParsed(event);
            }
        };
        scriptParsedLis.setTarget(this);
        scriptParsedLis.setMethod("Debugger.scriptParsed");
        this.eventListeners.add(Builder.addEventListener(this.client, scriptParsedLis.getMethod(), scriptParsedLis));
        DefaultBrowserListener<Object> clearedLis = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                JSCoverage jsCoverage = (JSCoverage)this.getTarget();
                jsCoverage.onExecutionContextsCleared();
            }
        };
        clearedLis.setTarget(this);
        clearedLis.setMethod("Runtime.executionContextsCleared");
        this.eventListeners.add(Builder.addEventListener(this.client, clearedLis.getMethod(), clearedLis));
        this.client.send("Profiler.enable", null, false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callCount", false);
        params.put("detailed", true);
        this.client.send("Profiler.startPreciseCoverage", params, false);
        this.client.send("Debugger.enable", null, false);
        params.clear();
        params.put("skip", true);
        this.client.send("Debugger.setSkipAllPauses", params, true);
    }

    private void onExecutionContextsCleared() {
        if (!this.resetOnNavigation) {
            return;
        }
        this.scriptURLs.clear();
        this.scriptSources.clear();
    }

    private void onScriptParsed(ScriptParsedPayload event) {
        if ("__puppeteer_evaluation_script__".equals(event.getUrl())) {
            return;
        }
        if (StringKit.isEmpty(event.getUrl()) && !this.reportAnonymousScripts) {
            return;
        }
        Builder.commonExecutor().submit(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scriptId", event.getScriptId());
            JSONObject response = this.client.send("Debugger.getScriptSource", params, true);
            this.scriptURLs.put(event.getScriptId(), event.getUrl());
            this.scriptSources.put(event.getScriptId(), response.getString("scriptSource"));
        });
    }

    public List<CoverageEntry> stop() {
        Assert.isTrue(this.enabled, "JSCoverage is not enabled", new Object[0]);
        this.enabled = false;
        JSONObject result = this.client.send("Profiler.takePreciseCoverage", null, true);
        this.client.send("Profiler.stopPreciseCoverage", null, false);
        this.client.send("Profiler.disable", null, false);
        this.client.send("Debugger.disable", null, false);
        Builder.removeEventListeners(this.eventListeners);
        ArrayList<CoverageEntry> coverage = new ArrayList<CoverageEntry>();
        TakePreciseCoverageReturnValue profileResponse = (TakePreciseCoverageReturnValue)JSON.toJavaObject((JSON)result, TakePreciseCoverageReturnValue.class);
        if (CollKit.isEmpty(profileResponse.getResult())) {
            return coverage;
        }
        for (ScriptCoverage entry : profileResponse.getResult()) {
            Object url = this.scriptURLs.get(entry.getScriptId());
            if (StringKit.isEmpty((CharSequence)url) && this.reportAnonymousScripts) {
                url = "debugger://VM" + entry.getScriptId();
            }
            String text = this.scriptSources.get(entry.getScriptId());
            if (StringKit.isEmpty((CharSequence)url) || StringKit.isEmpty(text)) continue;
            ArrayList<CoverageRange> flattenRanges = new ArrayList<CoverageRange>();
            for (FunctionCoverage func : entry.getFunctions()) {
                flattenRanges.addAll(func.getRanges());
            }
            List<Range> ranges = Coverage.convertToDisjointRanges(flattenRanges);
            coverage.add(this.createCoverageEntry((String)url, ranges, text));
        }
        return coverage;
    }

    private CoverageEntry createCoverageEntry(String url, List<Range> ranges, String text) {
        CoverageEntry coverageEntity = new CoverageEntry();
        coverageEntity.setUrl(url);
        coverageEntity.setRanges(ranges);
        coverageEntity.setText(text);
        return coverageEntity;
    }
}

