/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.kernel.page.ElementHandle;
import org.aoju.lancia.kernel.page.ExecutionContext;
import org.aoju.lancia.kernel.page.Frame;
import org.aoju.lancia.kernel.page.FrameManager;
import org.aoju.lancia.nimble.runtime.RemoteObject;
import org.aoju.lancia.worker.CDPSession;

public class JSHandle {
    private final CDPSession client;
    private final RemoteObject remoteObject;
    private ExecutionContext context;
    private boolean disposed = false;

    public JSHandle(ExecutionContext context, CDPSession client, RemoteObject remoteObject) {
        this.context = context;
        this.client = client;
        this.remoteObject = remoteObject;
    }

    public static JSHandle createJSHandle(ExecutionContext context, RemoteObject remoteObject) {
        Frame frame = context.frame();
        if ("node".equals(remoteObject.getSubtype()) && frame != null) {
            FrameManager frameManager = frame.getFrameManager();
            return new ElementHandle(context, context.getClient(), remoteObject, frameManager.getPage(), frameManager);
        }
        return new JSHandle(context, context.getClient(), remoteObject);
    }

    public ExecutionContext executionContext() {
        return this.context;
    }

    public Object evaluate(String pageFunction, List<Object> args) {
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        argsArray.addAll(args);
        return this.executionContext().evaluate(pageFunction, argsArray);
    }

    public Object evaluateHandle(String pageFunction, List<Object> args) {
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        argsArray.addAll(args);
        return this.executionContext().evaluateHandle(pageFunction, argsArray);
    }

    public JSHandle getProperty(String propertyName) {
        String pageFunction = "(object, propertyName) => {\n            const result = { __proto__: null };\n            result[propertyName] = object[propertyName];\n            return result;\n        }";
        JSHandle objectHandle = (JSHandle)this.evaluateHandle(pageFunction, Collections.singletonList(propertyName));
        Map<String, JSHandle> properties = objectHandle.getProperties();
        JSHandle result = properties.get(propertyName);
        objectHandle.dispose();
        return result;
    }

    public Map<String, JSHandle> getProperties() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objectId", this.remoteObject.getObjectId());
        params.put("ownProperties", true);
        JSONObject response = this.client.send("Runtime.getProperties", params, true);
        HashMap<String, JSHandle> result = new HashMap<String, JSHandle>();
        List list = (List)response.getObject("result", (TypeReference)new TypeReference<List<JSONObject>>(){});
        for (JSONObject property : list) {
            if (!property.getBoolean("enumerable").booleanValue()) continue;
            result.put(property.getString("name"), JSHandle.createJSHandle(this.context, (RemoteObject)JSON.toJavaObject((JSON)property.getJSONObject("value"), RemoteObject.class)));
        }
        return result;
    }

    public Object jsonValue() {
        if (StringKit.isNotEmpty(this.remoteObject.getObjectId())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("functionDeclaration", "function() { return this; }");
            params.put("objectId", this.remoteObject.getObjectId());
            params.put("returnByValue", true);
            params.put("awaitPromise", true);
            JSONObject response = this.client.send("Runtime.callFunctionOn", params, true);
            return Builder.valueFromRemoteObject((RemoteObject)JSON.parseObject((String)JSON.toJSONString((Object)response.get((Object)"result")), RemoteObject.class));
        }
        return Builder.valueFromRemoteObject(this.remoteObject);
    }

    public ElementHandle asElement() {
        return null;
    }

    public void dispose() {
        this.dispose(true);
    }

    public void dispose(boolean isBlock) {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Builder.releaseObject(this.client, this.remoteObject, isBlock);
    }

    public String toString() {
        if (StringKit.isNotEmpty(this.remoteObject.getObjectId())) {
            String type = StringKit.isNotEmpty(this.remoteObject.getSubtype()) ? this.remoteObject.getSubtype() : this.remoteObject.getType();
            return "JSHandle@" + type;
        }
        return "JSHandle:" + String.valueOf(Builder.valueFromRemoteObject(this.remoteObject));
    }

    protected ExecutionContext getContext() {
        return this.context;
    }

    protected void setContext(ExecutionContext context) {
        this.context = context;
    }

    protected boolean getDisposed() {
        return this.disposed;
    }

    protected void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public RemoteObject getRemoteObject() {
        return this.remoteObject;
    }
}

