/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.page.Frame;
import org.aoju.lancia.kernel.page.FrameManager;
import org.aoju.lancia.kernel.page.Request;
import org.aoju.lancia.kernel.page.Response;
import org.aoju.lancia.nimble.fetch.AuthRequiredPayload;
import org.aoju.lancia.nimble.fetch.RequestPausedPayload;
import org.aoju.lancia.nimble.network.LoadingFailedPayload;
import org.aoju.lancia.nimble.network.LoadingFinishedPayload;
import org.aoju.lancia.nimble.network.RequestServedFromCachePayload;
import org.aoju.lancia.nimble.network.RequestWillBeSentPayload;
import org.aoju.lancia.nimble.network.ResponsePayload;
import org.aoju.lancia.nimble.network.ResponseReceivedPayload;
import org.aoju.lancia.nimble.webAuthn.Credentials;
import org.aoju.lancia.worker.CDPSession;

public class NetworkManager
extends EventEmitter {
    private final CDPSession client;
    private final boolean ignoreHTTPSErrors;
    private final FrameManager frameManager;
    private final Map<String, Request> requestIdToRequest;
    private final Map<String, RequestWillBeSentPayload> requestIdToRequestWillBeSentEvent;
    private final Set<String> attemptedAuthentications;
    private final Map<String, String> requestIdToInterceptionId;
    private Map<String, String> extraHTTPHeaders;
    private boolean offline;
    private Credentials credentials;
    private boolean userRequestInterceptionEnabled;
    private boolean protocolRequestInterceptionEnabled;
    private boolean userCacheDisabled;

    public NetworkManager(CDPSession client, boolean ignoreHTTPSErrors, FrameManager frameManager) {
        this.client = client;
        this.ignoreHTTPSErrors = ignoreHTTPSErrors;
        this.frameManager = frameManager;
        this.requestIdToRequest = new HashMap<String, Request>();
        this.requestIdToRequestWillBeSentEvent = new HashMap<String, RequestWillBeSentPayload>();
        this.extraHTTPHeaders = new HashMap<String, String>();
        this.offline = false;
        this.credentials = null;
        this.attemptedAuthentications = new HashSet<String>();
        this.userRequestInterceptionEnabled = false;
        this.protocolRequestInterceptionEnabled = false;
        this.userCacheDisabled = false;
        this.requestIdToInterceptionId = new HashMap<String, String>();
        DefaultBrowserListener<RequestPausedPayload> requestPausedListener = new DefaultBrowserListener<RequestPausedPayload>(){

            @Override
            public void onBrowserEvent(RequestPausedPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onRequestPaused(event);
            }
        };
        requestPausedListener.setMethod("Fetch.requestPaused");
        requestPausedListener.setTarget(this);
        this.client.addListener(requestPausedListener.getMethod(), requestPausedListener);
        DefaultBrowserListener<AuthRequiredPayload> authRequiredListener = new DefaultBrowserListener<AuthRequiredPayload>(){

            @Override
            public void onBrowserEvent(AuthRequiredPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onAuthRequired(event);
            }
        };
        authRequiredListener.setMethod("Fetch.authRequired");
        authRequiredListener.setTarget(this);
        this.client.addListener(authRequiredListener.getMethod(), authRequiredListener);
        DefaultBrowserListener<RequestWillBeSentPayload> requestWillBeSentListener = new DefaultBrowserListener<RequestWillBeSentPayload>(){

            @Override
            public void onBrowserEvent(RequestWillBeSentPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onRequestWillBeSent(event);
            }
        };
        requestWillBeSentListener.setMethod("Network.requestWillBeSent");
        requestWillBeSentListener.setTarget(this);
        this.client.addListener(requestWillBeSentListener.getMethod(), requestWillBeSentListener);
        DefaultBrowserListener<RequestServedFromCachePayload> requestServedFromCacheListener = new DefaultBrowserListener<RequestServedFromCachePayload>(){

            @Override
            public void onBrowserEvent(RequestServedFromCachePayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onRequestServedFromCache(event);
            }
        };
        requestServedFromCacheListener.setMethod("Network.requestServedFromCache");
        requestServedFromCacheListener.setTarget(this);
        this.client.addListener(requestServedFromCacheListener.getMethod(), requestServedFromCacheListener);
        DefaultBrowserListener<ResponseReceivedPayload> responseReceivedListener = new DefaultBrowserListener<ResponseReceivedPayload>(){

            @Override
            public void onBrowserEvent(ResponseReceivedPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onResponseReceived(event);
            }
        };
        responseReceivedListener.setMethod("Network.responseReceived");
        responseReceivedListener.setTarget(this);
        this.client.addListener(responseReceivedListener.getMethod(), responseReceivedListener);
        DefaultBrowserListener<LoadingFinishedPayload> loadingFinishedListener = new DefaultBrowserListener<LoadingFinishedPayload>(){

            @Override
            public void onBrowserEvent(LoadingFinishedPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onLoadingFinished(event);
            }
        };
        loadingFinishedListener.setMethod("Network.loadingFinished");
        loadingFinishedListener.setTarget(this);
        this.client.addListener(loadingFinishedListener.getMethod(), loadingFinishedListener);
        DefaultBrowserListener<LoadingFailedPayload> loadingFailedListener = new DefaultBrowserListener<LoadingFailedPayload>(){

            @Override
            public void onBrowserEvent(LoadingFailedPayload event) {
                NetworkManager manager = (NetworkManager)this.getTarget();
                manager.onLoadingFailed(event);
            }
        };
        loadingFailedListener.setMethod("Network.loadingFailed");
        loadingFailedListener.setTarget(this);
        this.client.addListener(loadingFailedListener.getMethod(), loadingFailedListener);
    }

    public void setExtraHTTPHeaders(Map<String, String> extraHTTPHeaders) {
        this.extraHTTPHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : extraHTTPHeaders.entrySet()) {
            String value = entry.getValue();
            Assert.isTrue(Builder.isString(value), "Expected value of header " + entry.getKey() + " to be String, but " + value.getClass().getCanonicalName() + " is found.", new Object[0]);
            this.extraHTTPHeaders.put(entry.getKey(), value);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("headers", this.extraHTTPHeaders);
        this.client.send("Network.setExtraHTTPHeaders", params, true);
    }

    public void initialize() {
        this.client.send("Network.enable", null, true);
        if (this.ignoreHTTPSErrors) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ignore", true);
            this.client.send("Security.setIgnoreCertificateErrors", params, true);
        }
    }

    public void authenticate(Credentials credentials) {
        this.credentials = credentials;
        this.updateProtocolRequestInterception();
    }

    public Map<String, String> extraHTTPHeaders() {
        return new HashMap<String, String>(this.extraHTTPHeaders);
    }

    public void setOfflineMode(boolean value) {
        if (this.offline == value) {
            return;
        }
        this.offline = value;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offline", this.offline);
        params.put("latency", 0);
        params.put("downloadThroughput", -1);
        params.put("uploadThroughput", -1);
        this.client.send("Network.emulateNetworkConditions", params, true);
    }

    public void setUserAgent(String userAgent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userAgent", userAgent);
        this.client.send("Network.setUserAgentOverride", params, true);
    }

    public void setCacheEnabled(boolean enabled) {
        this.userCacheDisabled = !enabled;
        this.updateProtocolCacheDisabled();
    }

    public void setRequestInterception(boolean value) {
        this.userRequestInterceptionEnabled = value;
        this.updateProtocolRequestInterception();
    }

    private void updateProtocolCacheDisabled() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean cacheDisabled = this.userCacheDisabled || this.protocolRequestInterceptionEnabled;
        params.put("cacheDisabled", cacheDisabled);
        this.client.send("Network.setCacheDisabled", params, true);
    }

    public void updateProtocolRequestInterception() {
        boolean enabled;
        boolean bl = enabled = this.userRequestInterceptionEnabled || this.credentials != null;
        if (enabled == this.protocolRequestInterceptionEnabled) {
            return;
        }
        this.protocolRequestInterceptionEnabled = enabled;
        this.updateProtocolCacheDisabled();
        if (enabled) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("handleAuthRequests", true);
            ArrayList<Object> patterns = new ArrayList<Object>();
            patterns.add(new JSONObject().put("urlPattern", (Object)"*"));
            params.put("patterns", patterns);
            this.client.send("Fetch.enable", params, true);
        } else {
            this.client.send("Fetch.disable", null, true);
        }
    }

    public void onRequestWillBeSent(RequestWillBeSentPayload event) {
        if (this.protocolRequestInterceptionEnabled && !event.getRequest().url().startsWith("data:")) {
            String requestId = event.getRequestId();
            String interceptionId = this.requestIdToInterceptionId.get(requestId);
            if (StringKit.isNotEmpty(interceptionId)) {
                this.onRequest(event, interceptionId);
                this.requestIdToInterceptionId.remove(requestId);
            } else {
                this.requestIdToRequestWillBeSentEvent.put(event.getRequestId(), event);
            }
            return;
        }
        this.onRequest(event, null);
    }

    public void onAuthRequired(AuthRequiredPayload event) {
        String response = "Default";
        if (this.attemptedAuthentications.contains(event.getRequestId())) {
            response = "CancelAuth";
        } else if (this.credentials != null) {
            response = "ProvideCredentials";
            this.attemptedAuthentications.add(event.getRequestId());
        }
        JSONObject respParams = new JSONObject();
        respParams.put("response", (Object)response);
        if (this.credentials != null) {
            String password;
            String username = this.credentials.getUsername();
            if (StringKit.isNotEmpty(username)) {
                respParams.put("username", (Object)username);
            }
            if (StringKit.isNotEmpty(password = this.credentials.getPassword())) {
                respParams.put("password", (Object)password);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("response", "Default");
        params.put("requestId", event.getRequestId());
        params.put("authChallengeResponse", respParams);
        this.client.send("Fetch.continueWithAuth", params, false);
    }

    public void onRequestPaused(RequestPausedPayload event) {
        if (!this.userRequestInterceptionEnabled && this.protocolRequestInterceptionEnabled) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("requestId", event.getRequestId());
            this.client.send("Fetch.continueRequest", params, false);
        }
        String requestId = event.getNetworkId();
        String interceptionId = event.getRequestId();
        if (StringKit.isNotEmpty(requestId) && this.requestIdToRequestWillBeSentEvent.containsKey(requestId)) {
            RequestWillBeSentPayload requestWillBeSentEvent = this.requestIdToRequestWillBeSentEvent.get(requestId);
            this.onRequest(requestWillBeSentEvent, interceptionId);
            this.requestIdToRequestWillBeSentEvent.remove(requestId);
        } else {
            this.requestIdToInterceptionId.put(requestId, interceptionId);
        }
    }

    public void onRequest(RequestWillBeSentPayload event, String interceptionId) {
        Request request;
        List<Request> redirectChain = new ArrayList<Request>();
        if (event.getRedirectResponse() != null && (request = this.requestIdToRequest.get(event.getRequestId())) != null) {
            this.handleRequestRedirect(request, event.getRedirectResponse());
            redirectChain = request.redirectChain();
        }
        Frame frame = StringKit.isNotEmpty(event.getFrameId()) ? this.frameManager.getFrame(event.getFrameId()) : null;
        Request request2 = new Request(this.client, frame, interceptionId, this.userRequestInterceptionEnabled, event, redirectChain);
        this.requestIdToRequest.put(event.getRequestId(), request2);
        this.emit(Events.NETWORK_MANAGER_REQUEST.getName(), request2);
    }

    private void handleRequestRedirect(Request request, ResponsePayload responsePayload) {
        Response response = new Response(this.client, request, responsePayload);
        request.setResponse(response);
        request.redirectChain().add(request);
        response.resolveBody("Response body is unavailable for redirect responses");
        this.requestIdToRequest.remove(request.requestId());
        this.attemptedAuthentications.remove(request.interceptionId());
        this.emit(Events.NETWORK_MANAGER_RESPONSE.getName(), response);
        this.emit(Events.NETWORK_MANAGER_REQUEST_FINISHED.getName(), request);
    }

    public void onLoadingFinished(LoadingFinishedPayload event) {
        Request request = this.requestIdToRequest.get(event.getRequestId());
        if (request == null) {
            return;
        }
        if (request.response() != null) {
            request.response().bodyLoadedPromiseFulfill(null);
        }
        this.requestIdToRequest.remove(request.requestId());
        this.attemptedAuthentications.remove(request.interceptionId());
        this.emit(Events.NETWORK_MANAGER_REQUEST_FINISHED.getName(), request);
    }

    public void onResponseReceived(ResponseReceivedPayload event) {
        Request request = this.requestIdToRequest.get(event.getRequestId());
        if (request == null) {
            return;
        }
        Response response = new Response(this.client, request, event.getResponse());
        request.setResponse(response);
        this.emit(Events.NETWORK_MANAGER_RESPONSE.getName(), response);
    }

    public void onLoadingFailed(LoadingFailedPayload event) {
        Request request = this.requestIdToRequest.get(event.getRequestId());
        if (request == null) {
            return;
        }
        request.setFailureText(event.getErrorText());
        Response response = request.response();
        if (response != null) {
            response.bodyLoadedPromiseFulfill(null);
        }
        this.requestIdToRequest.remove(request.requestId());
        this.attemptedAuthentications.remove(request.interceptionId());
        this.emit(Events.NETWORK_MANAGER_REQUEST_FAILED.getName(), request);
    }

    public void onRequestServedFromCache(RequestServedFromCachePayload event) {
        Request request = this.requestIdToRequest.get(event.getRequestId());
        if (request != null) {
            request.setFromMemoryCache(true);
        }
    }
}

