/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.aoju.bus.core.lang.Assert;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.worker.CDPSession;

public class Tracing {
    private CDPSession client;
    private boolean recording;
    private String path;

    public Tracing(CDPSession client) {
        this.client = client;
        this.recording = false;
        this.path = "";
    }

    public void start(String path) {
        this.start(path, false, null);
    }

    public void start(String path, boolean screenshots, Set<String> categories) {
        Assert.isTrue(!this.recording, "Cannot start recording trace while already recording trace.", new Object[0]);
        if (categories == null) {
            categories = new HashSet<String>(Builder.DEFAULTCATEGORIES);
        }
        if (screenshots) {
            categories.add("disabled-by-default-devtools.screenshot");
        }
        this.path = path;
        this.recording = true;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("transferMode", "ReturnAsStream");
        params.put("categories", String.join((CharSequence)",", categories));
        this.client.send("Tracing.start", params, true);
    }

    public void stop() {
        DefaultBrowserListener<JSONObject> traceListener = new DefaultBrowserListener<JSONObject>(){

            @Override
            public void onBrowserEvent(JSONObject event) {
                try {
                    Tracing tracing = (Tracing)this.getTarget();
                    Builder.readProtocolStream(tracing.getClient(), event.getString("stream"), tracing.getPath(), true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        traceListener.setTarget(this);
        traceListener.setMethod("Tracing.tracingComplete");
        this.client.addListener(traceListener.getMethod(), traceListener, true);
        this.client.send("Tracing.end", null, true);
        this.recording = false;
    }

    public CDPSession getClient() {
        return this.client;
    }

    public void setClient(CDPSession client) {
        this.client = client;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

