/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.kernel.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.aoju.lancia.events.DefaultBrowserListener;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.kernel.page.ConsoleAPI;
import org.aoju.lancia.kernel.page.ExecutionContext;
import org.aoju.lancia.kernel.page.JSHandle;
import org.aoju.lancia.nimble.runtime.ConsoleAPICalledPayload;
import org.aoju.lancia.nimble.runtime.ExceptionDetails;
import org.aoju.lancia.nimble.runtime.ExecutionContextDescription;
import org.aoju.lancia.nimble.runtime.RemoteObject;
import org.aoju.lancia.worker.CDPSession;
import org.aoju.lancia.worker.exception.TimeoutException;

public class Worker
extends EventEmitter {
    private final CDPSession client;
    private final String url;
    private ExecutionContext context;
    private CountDownLatch contextLatch;

    public Worker(final CDPSession client, String url, final ConsoleAPI consoleAPICalled, final Consumer<ExceptionDetails> exceptionThrown) {
        this.client = client;
        this.url = url;
        DefaultBrowserListener<JSONObject> executionContextListener = new DefaultBrowserListener<JSONObject>(){

            @Override
            public void onBrowserEvent(JSONObject event) {
                Worker worker = (Worker)this.getTarget();
                ExecutionContextDescription contextDescription = (ExecutionContextDescription)JSON.parseObject((String)JSON.toJSONString((Object)event.get((Object)"context")), ExecutionContextDescription.class);
                ExecutionContext executionContext = new ExecutionContext(client, contextDescription, null);
                worker.executionContextCallback(executionContext);
            }
        };
        executionContextListener.setMethod("Runtime.executionContextCreated");
        executionContextListener.setTarget(this);
        this.client.addListener(executionContextListener.getMethod(), executionContextListener, true);
        this.client.send("Runtime.enable", null, false);
        DefaultBrowserListener<ConsoleAPICalledPayload> consoleLis = new DefaultBrowserListener<ConsoleAPICalledPayload>(){

            @Override
            public void onBrowserEvent(ConsoleAPICalledPayload event) {
                consoleAPICalled.call(event.getType(), event.getArgs().stream().map(item -> Worker.this.jsHandleFactory((RemoteObject)item)).collect(Collectors.toList()), event.getStackTrace());
            }
        };
        consoleLis.setMethod("Runtime.consoleAPICalled");
        this.client.addListener(consoleLis.getMethod(), consoleLis);
        DefaultBrowserListener<JSONObject> exceptionLis = new DefaultBrowserListener<JSONObject>(){

            @Override
            public void onBrowserEvent(JSONObject event) {
                ExceptionDetails exceptionDetails = (ExceptionDetails)JSON.toJavaObject((JSON)event.getJSONObject("exceptionDetails"), ExceptionDetails.class);
                exceptionThrown.accept(exceptionDetails);
            }
        };
        exceptionLis.setMethod("Runtime.exceptionThrown");
        this.client.addListener(exceptionLis.getMethod(), exceptionLis);
    }

    public JSHandle jsHandleFactory(RemoteObject remoteObject) {
        return new JSHandle(this.context, this.client, remoteObject);
    }

    protected void executionContextCallback(ExecutionContext executionContext) {
        this.setContext(executionContext);
    }

    private ExecutionContext executionContextPromise() throws InterruptedException {
        if (this.context == null) {
            this.setContextLatch(new CountDownLatch(1));
            boolean await = this.getContextLatch().await(30000L, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new TimeoutException("Wait for ExecutionContext timeout");
            }
        }
        return this.context;
    }

    private CountDownLatch getContextLatch() {
        return this.contextLatch;
    }

    private void setContextLatch(CountDownLatch contextLatch) {
        this.contextLatch = contextLatch;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public String url() {
        return this.url;
    }

    public ExecutionContext executionContext() throws InterruptedException {
        return this.executionContextPromise();
    }

    public Object evaluate(String pageFunction, List<Object> args) throws InterruptedException {
        return this.executionContextPromise().evaluate(pageFunction, args);
    }

    public Object evaluateHandle(String pageFunction, List<Object> args) throws InterruptedException {
        return this.executionContextPromise().evaluateHandle(pageFunction, args);
    }
}

