/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.launch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Browser;
import org.aoju.lancia.Builder;
import org.aoju.lancia.Launcher;
import org.aoju.lancia.kernel.browser.Fetcher;
import org.aoju.lancia.kernel.browser.Revision;
import org.aoju.lancia.kernel.browser.Runner;
import org.aoju.lancia.option.BrowserOptions;
import org.aoju.lancia.option.ChromeArgOptions;
import org.aoju.lancia.option.FetcherOptions;
import org.aoju.lancia.option.LaunchOptions;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.Transport;
import org.aoju.lancia.worker.TransportFactory;
import org.aoju.lancia.worker.exception.LaunchException;

public class ChromeLauncher
implements Launcher {
    private boolean isPuppeteerCore;
    private String projectRoot;
    private String preferredRevision;

    public ChromeLauncher() {
    }

    public ChromeLauncher(String projectRoot, String preferredRevision, boolean isPuppeteerCore) {
        this.projectRoot = projectRoot;
        this.preferredRevision = preferredRevision;
        this.isPuppeteerCore = isPuppeteerCore;
    }

    @Override
    public Browser launch(LaunchOptions options) throws IOException {
        String temporaryUserDataDir = null;
        List<String> chromeArguments = this.defaultArgs(options);
        List<String> ignoreDefaultArgs = options.getIgnoreDefaultArgs();
        if (CollKit.isNotEmpty(ignoreDefaultArgs)) {
            chromeArguments.removeAll(ignoreDefaultArgs);
        }
        boolean isCustomUserDir = false;
        boolean isCustomRemoteDebugger = false;
        for (String arg : chromeArguments) {
            if (arg.startsWith("--remote-debugging-")) {
                isCustomRemoteDebugger = true;
                continue;
            }
            if (!arg.startsWith("--user-data-dir")) continue;
            isCustomUserDir = true;
        }
        if (!isCustomUserDir) {
            temporaryUserDataDir = Files.createTempDirectory("puppeteer_dev_chrome_profile-", new FileAttribute[0]).toRealPath(new LinkOption[0]).toString();
            chromeArguments.add("--user-data-dir=" + temporaryUserDataDir);
        }
        if (!isCustomRemoteDebugger) {
            chromeArguments.add(options.getPipe() ? "--remote-debugging-pipe" : "--remote-debugging-port=0");
        }
        String chromeExecutable = this.resolveExecutablePath(options.getExecutablePath());
        boolean usePipe = chromeArguments.contains("--remote-debugging-pipe");
        Logger.trace("Calling " + chromeExecutable + String.join((CharSequence)" ", chromeArguments), new Object[0]);
        Runner runner = new Runner(chromeExecutable, chromeArguments, temporaryUserDataDir);
        try {
            runner.start(options);
            Connection connection = runner.setUpConnection(usePipe, options.getTimeout(), options.getSlowMo(), options.getDumpio(), options.getConnectionOptions());
            Function<Object, Object> closeCallback = s -> {
                runner.closeQuietly();
                return null;
            };
            Browser browser = Browser.create(connection, null, options.getIgnoreHTTPSErrors(), options.getViewport(), runner.getProcess(), closeCallback);
            browser.waitForTarget(t -> "page".equals(t.type()), options);
            return browser;
        }
        catch (IOException | InterruptedException e) {
            runner.kill();
            throw new LaunchException("Failed to launch the browser process:" + e.getMessage(), e);
        }
    }

    @Override
    public List<String> defaultArgs(ChromeArgOptions options) {
        LaunchOptions launchOptions;
        List<String> args;
        ArrayList<String> chromeArguments = new ArrayList<String>();
        if (StringKit.isNotEmpty(options.getUserDataDir())) {
            chromeArguments.add("--user-data-dir=" + options.getUserDataDir());
        }
        boolean devtools = options.getDevtools();
        boolean headless = options.getHeadless();
        if (devtools) {
            chromeArguments.add("--auto-open-devtools-for-tabs");
            headless = false;
        }
        if (headless) {
            chromeArguments.add("--headless");
            chromeArguments.add("--hide-scrollbars");
            chromeArguments.add("--mute-audio");
        }
        if (CollKit.isNotEmpty(args = options.getArgs())) {
            chromeArguments.add("about:blank");
            chromeArguments.addAll(args);
        }
        if (options instanceof LaunchOptions && !(launchOptions = (LaunchOptions)options).getIgnoreAllDefaultArgs()) {
            chromeArguments.addAll(Builder.DEFAULT_ARGS);
        }
        return chromeArguments;
    }

    @Override
    public String resolveExecutablePath(String chromeExecutable) throws IOException {
        Object revision;
        boolean puppeteerCore = this.getIsPuppeteerCore();
        FetcherOptions fetcherOptions = new FetcherOptions();
        fetcherOptions.setProduct(this.product());
        Fetcher fetcher = new Fetcher(this.projectRoot, fetcherOptions);
        if (!puppeteerCore) {
            if (StringKit.isNotEmpty(chromeExecutable)) {
                boolean assertDir = Builder.assertExecutable(Paths.get(chromeExecutable, new String[0]).normalize().toAbsolutePath().toString());
                if (!assertDir) {
                    throw new IllegalArgumentException("given chromeExecutable \"" + chromeExecutable + "\" is not executable");
                }
                return chromeExecutable;
            }
            for (int i = 0; i < Builder.EXECUTABLE_ENV.length; ++i) {
                chromeExecutable = VARIABLES.getEnv(Builder.EXECUTABLE_ENV[i]);
                if (!StringKit.isNotEmpty(chromeExecutable)) continue;
                boolean assertDir = Builder.assertExecutable(chromeExecutable);
                if (!assertDir) {
                    throw new IllegalArgumentException("given chromeExecutable is not is not executable");
                }
                return chromeExecutable;
            }
            revision = VARIABLES.getEnv("PUPPETEER_CHROMIUM_REVISION");
            if (StringKit.isNotEmpty((CharSequence)revision)) {
                Revision revisionInfo = fetcher.revisionInfo((String)revision);
                if (!revisionInfo.isLocal()) {
                    throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo.getExecutablePath());
                }
                return revisionInfo.getExecutablePath();
            }
            List<String> localRevisions = fetcher.localRevisions();
            if (CollKit.isNotEmpty(localRevisions)) {
                localRevisions.sort(Comparator.reverseOrder());
                Revision revisionInfo = fetcher.revisionInfo(localRevisions.get(0));
                if (!revisionInfo.isLocal()) {
                    throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo.getExecutablePath());
                }
                return revisionInfo.getExecutablePath();
            }
            for (int i = 0; i < Builder.PROBABLE_CHROME_EXECUTABLE_PATH.length; ++i) {
                boolean assertDir;
                chromeExecutable = Builder.PROBABLE_CHROME_EXECUTABLE_PATH[i];
                if (!StringKit.isNotEmpty(chromeExecutable) || !(assertDir = Builder.assertExecutable(chromeExecutable))) continue;
                return chromeExecutable;
            }
        }
        if (!((Revision)(revision = fetcher.revisionInfo(this.preferredRevision))).isLocal()) {
            throw new LaunchException(MessageFormat.format("Could not find browser revision {0}. Pleaze download a browser binary.", this.preferredRevision));
        }
        return ((Revision)revision).getExecutablePath();
    }

    @Override
    public Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, Transport transport) {
        try {
            Connection connection;
            if (transport != null) {
                connection = new Connection("", transport, options.getSlowMo(), options.getConnectionOptions());
            } else if (StringKit.isNotEmpty(browserWSEndpoint)) {
                connection = new Connection(browserWSEndpoint, TransportFactory.create(browserWSEndpoint), options.getSlowMo(), options.getConnectionOptions());
            } else if (StringKit.isNotEmpty(browserURL)) {
                String connectionURL = this.getWSEndpoint(browserURL);
                connection = new Connection(connectionURL, TransportFactory.create(connectionURL), options.getSlowMo(), options.getConnectionOptions());
            } else {
                throw new IllegalArgumentException("Exactly one of browserWSEndpoint, browserURL or transport must be passed to puppeteer.connect");
            }
            JSONObject result = connection.send("Target.getBrowserContexts", null, true);
            Function<Object, Object> closeFunction = t -> {
                connection.send("Browser.close", null, false);
                return null;
            };
            List browserContextIds = (List)result.getObject("browserContextIds", TypeReference.LIST_STRING);
            return Browser.create(connection, browserContextIds, options.getIgnoreHTTPSErrors(), options.getViewport(), null, closeFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getWSEndpoint(String browserURL) throws IOException {
        URI uri = URI.create(browserURL).resolve("/json/version");
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("BrowserURL: " + browserURL + ",HTTP " + responseCode);
        }
        String result = Builder.toString(conn.getInputStream());
        JSONObject jsonObject = JSON.parseObject((String)result);
        return jsonObject.getString("webSocketDebuggerUrl");
    }

    public boolean getIsPuppeteerCore() {
        return this.isPuppeteerCore;
    }

    public void setIsPuppeteerCore(boolean isPuppeteerCore) {
        this.isPuppeteerCore = isPuppeteerCore;
    }

    @Override
    public String executablePath() throws IOException {
        return this.resolveExecutablePath(null);
    }

    public String product() {
        return "chrome";
    }
}

