/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.socket;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.socket.Framedata;
import org.aoju.lancia.socket.HandshakeBuilder;
import org.aoju.lancia.socket.SocketBuilder;
import org.aoju.lancia.worker.exception.SocketException;

public class Draft_6455 {
    private static final String SEC_WEB_SOCKET_KEY = "Sec-WebSocket-Key";
    private static final String SEC_WEB_SOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    private static final String SEC_WEB_SOCKET_ACCEPT = "Sec-WebSocket-Accept";
    private static final String UPGRADE = "Upgrade";
    private static final String CONNECTION = "Connection";
    private final SecureRandom reuseableRandom = new SecureRandom();
    private final List<String> knownExtensions;
    private final int maxFrameSize;
    protected String continuousFrameType = null;
    private String negotiatedExtension;
    private ByteBuffer incompleteframe;

    public Draft_6455() {
        this(Collections.emptyList());
    }

    public Draft_6455(List<String> inputExtensions) {
        this(inputExtensions, Integer.MAX_VALUE);
    }

    public Draft_6455(List<String> inputExtensions, int inputMaxFrameSize) {
        if (inputExtensions == null || inputMaxFrameSize < 1) {
            throw new IllegalArgumentException();
        }
        this.knownExtensions = new ArrayList<String>(inputExtensions.size());
        boolean hasDefault = false;
        for (String inputExtension : inputExtensions) {
            if (!inputExtension.getClass().equals(String.class)) continue;
            hasDefault = true;
            break;
        }
        this.knownExtensions.addAll(inputExtensions);
        if (!hasDefault) {
            this.knownExtensions.add(this.knownExtensions.size(), this.negotiatedExtension);
        }
        this.maxFrameSize = inputMaxFrameSize;
    }

    public static ByteBuffer readLine(ByteBuffer buf) {
        ByteBuffer b = ByteBuffer.allocate(buf.remaining());
        byte cur = 48;
        while (buf.hasRemaining()) {
            byte prev = cur;
            cur = buf.get();
            b.put(cur);
            if (prev != 13 || cur != 10) continue;
            b.limit(b.position() - 2);
            b.position(0);
            return b;
        }
        buf.position(buf.position() - b.position());
        return null;
    }

    public static String readStringLine(ByteBuffer buf) {
        ByteBuffer b = Draft_6455.readLine(buf);
        return b == null ? null : new String(b.array(), 0, b.limit(), Charset.US_ASCII);
    }

    public static HandshakeBuilder translateHandshakeHttp(ByteBuffer buf) throws SocketException {
        String line = Draft_6455.readStringLine(buf);
        if (line == null) {
            throw new SocketException(buf.capacity() + 128);
        }
        String[] firstLineTokens = line.split(" ", 3);
        if (firstLineTokens.length != 3) {
            throw new SocketException(1002);
        }
        HandshakeBuilder handshake = Draft_6455.translateHandshakeHttpClient(firstLineTokens, line);
        line = Draft_6455.readStringLine(buf);
        while (line != null && line.length() > 0) {
            String[] pair = line.split(":", 2);
            if (pair.length != 2) {
                throw new SocketException(1002, "not an http header");
            }
            if (handshake.hasFieldValue(pair[0])) {
                handshake.put(pair[0], handshake.getFieldValue(pair[0]) + "; " + pair[1].replaceFirst("^ +", ""));
            } else {
                handshake.put(pair[0], pair[1].replaceFirst("^ +", ""));
            }
            line = Draft_6455.readStringLine(buf);
        }
        if (line == null) {
            throw new SocketException();
        }
        return handshake;
    }

    private static HandshakeBuilder translateHandshakeHttpClient(String[] firstLineTokens, String line) throws SocketException {
        if (!"101".equals(firstLineTokens[1])) {
            throw new SocketException(1002, String.format("Invalid status code received: %s Status line: %s", firstLineTokens[1], line));
        }
        if (!"HTTP/1.1".equalsIgnoreCase(firstLineTokens[0])) {
            throw new SocketException(1002, String.format("Invalid status line received: %s Status line: %s", firstLineTokens[0], line));
        }
        HandshakeBuilder handshake = new HandshakeBuilder();
        handshake.setStatus(Short.parseShort(firstLineTokens[1]));
        handshake.setMessage(firstLineTokens[2]);
        return handshake;
    }

    public static String stringUtf8(ByteBuffer bytes) throws SocketException {
        String s;
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        CharsetDecoder decode = Charset.UTF_8.newDecoder();
        decode.onMalformedInput(codingErrorAction);
        decode.onUnmappableCharacter(codingErrorAction);
        try {
            bytes.mark();
            s = decode.decode(bytes).toString();
            bytes.reset();
        }
        catch (CharacterCodingException e) {
            throw new SocketException(1007, (Throwable)e);
        }
        return s;
    }

    protected boolean basicAccept(HandshakeBuilder handshake) {
        return handshake.getFieldValue(UPGRADE).equalsIgnoreCase("websocket") && handshake.getFieldValue(CONNECTION).toLowerCase(Locale.ENGLISH).contains("upgrade");
    }

    public String acceptHandshakeAsClient(HandshakeBuilder request, HandshakeBuilder response) {
        if (!this.basicAccept(response)) {
            Logger.trace("acceptHandshakeAsClient - Missing/wrong upgrade or connection in handshake.", new Object[0]);
            return "NOT_MATCHED";
        }
        if (!request.hasFieldValue(SEC_WEB_SOCKET_KEY) || !response.hasFieldValue(SEC_WEB_SOCKET_ACCEPT)) {
            Logger.trace("acceptHandshakeAsClient - Missing Sec-WebSocket-Key or Sec-WebSocket-Accept", new Object[0]);
            return "NOT_MATCHED";
        }
        String seckeyAnswer = response.getFieldValue(SEC_WEB_SOCKET_ACCEPT);
        String seckeyChallenge = request.getFieldValue(SEC_WEB_SOCKET_KEY);
        if (!(seckeyChallenge = this.generateFinalKey(seckeyChallenge)).equals(seckeyAnswer)) {
            Logger.trace("acceptHandshakeAsClient - Wrong key for Sec-WebSocket-Key.", new Object[0]);
            return "NOT_MATCHED";
        }
        String extensionState = "NOT_MATCHED";
        Iterator<String> iterator = this.knownExtensions.iterator();
        if (iterator.hasNext()) {
            String knownExtension;
            this.negotiatedExtension = knownExtension = iterator.next();
            extensionState = "MATCHED";
            Logger.trace("acceptHandshakeAsClient - Matching extension found: {}", this.negotiatedExtension);
        }
        if ("MATCHED".equals(extensionState)) {
            return "MATCHED";
        }
        Logger.trace("acceptHandshakeAsClient - No matching extension or socketProtocol found.", new Object[0]);
        return "NOT_MATCHED";
    }

    public HandshakeBuilder postProcessHandshakeRequestAsClient(HandshakeBuilder request) {
        request.put(UPGRADE, "websocket");
        request.put(CONNECTION, UPGRADE);
        byte[] random = new byte[16];
        this.reuseableRandom.nextBytes(random);
        request.put(SEC_WEB_SOCKET_KEY, Base64.encode(random));
        request.put("Sec-WebSocket-Version", "13");
        StringBuilder requestedExtensions = new StringBuilder();
        if (requestedExtensions.length() != 0) {
            request.put(SEC_WEB_SOCKET_EXTENSIONS, requestedExtensions.toString());
        }
        return request;
    }

    public Draft_6455 copyInstance() {
        return new Draft_6455(new ArrayList<String>(), this.maxFrameSize);
    }

    public ByteBuffer createBinaryFrame(Framedata framedata) {
        if (Logger.isTrace()) {
            Logger.trace("afterEnconding({}): {}", framedata.getPayloadData().remaining(), framedata.getPayloadData().remaining() > 1000 ? "too big to display" : new String(framedata.getPayloadData().array()));
        }
        return this.createByteBufferFromFramedata(framedata);
    }

    public HandshakeBuilder translateHandshake(ByteBuffer buf) throws SocketException {
        return Draft_6455.translateHandshakeHttp(buf);
    }

    public List<ByteBuffer> createHandshake(HandshakeBuilder handshake) {
        return this.createHandshake(handshake, true);
    }

    public List<Framedata> continuousFrame(String type, ByteBuffer buffer, boolean fin) {
        if (!"BINARY".equals(type) && !"TEXT".equals(type)) {
            throw new IllegalArgumentException("Only BINARY or TEXT are allowed");
        }
        Framedata bui = null;
        this.continuousFrameType = type;
        if ("TEXT".equals(type)) {
            bui = new Framedata("TEXT");
        }
        bui.setPayload(buffer);
        bui.setFin(fin);
        try {
            bui.isValid();
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
        this.continuousFrameType = fin ? null : type;
        return Collections.singletonList(bui);
    }

    public List<ByteBuffer> createHandshake(HandshakeBuilder handshake, boolean withcontent) {
        StringBuilder bui = new StringBuilder(100);
        bui.append("GET ").append(handshake.getDescriptor()).append(" HTTP/1.1");
        bui.append("\r\n");
        Iterator<String> it = handshake.iterateHttpFields();
        while (it.hasNext()) {
            String fieldname = it.next();
            String fieldvalue = handshake.getFieldValue(fieldname);
            bui.append(fieldname);
            bui.append(": ");
            bui.append(fieldvalue);
            bui.append("\r\n");
        }
        bui.append("\r\n");
        byte[] httpheader = bui.toString().getBytes(Charset.US_ASCII);
        byte[] content = withcontent ? handshake.getContent() : null;
        ByteBuffer bytebuffer = ByteBuffer.allocate((content == null ? 0 : content.length) + httpheader.length);
        bytebuffer.put(httpheader);
        if (content != null) {
            bytebuffer.put(content);
        }
        bytebuffer.flip();
        return Collections.singletonList(bytebuffer);
    }

    private ByteBuffer createByteBufferFromFramedata(Framedata framedata) {
        ByteBuffer mes = framedata.getPayloadData();
        boolean mask = true;
        int sizebytes = this.getSizeBytes(mes);
        ByteBuffer buf = ByteBuffer.allocate(1 + (sizebytes > 1 ? sizebytes + 1 : sizebytes) + (mask ? 4 : 0) + mes.remaining());
        byte optcode = this.fromOpcode(framedata.getOpcode());
        byte one = (byte)(framedata.isFin() ? -128 : 0);
        one = (byte)(one | optcode);
        if (framedata.isRSV1()) {
            one = (byte)(one | this.getRSVByte(1));
        }
        if (framedata.isRSV2()) {
            one = (byte)(one | this.getRSVByte(2));
        }
        if (framedata.isRSV3()) {
            one = (byte)(one | this.getRSVByte(3));
        }
        buf.put(one);
        byte[] payloadlengthbytes = this.toByteArray(mes.remaining(), sizebytes);
        assert (payloadlengthbytes.length == sizebytes);
        if (sizebytes == 1) {
            buf.put((byte)(payloadlengthbytes[0] | this.getMaskByte(mask)));
        } else if (sizebytes == 2) {
            buf.put((byte)(0x7E | this.getMaskByte(mask)));
            buf.put(payloadlengthbytes);
        } else if (sizebytes == 8) {
            buf.put((byte)(0x7F | this.getMaskByte(mask)));
            buf.put(payloadlengthbytes);
        } else {
            throw new IllegalStateException("Size representation not supported/specified");
        }
        if (mask) {
            ByteBuffer maskkey = ByteBuffer.allocate(4);
            maskkey.putInt(this.reuseableRandom.nextInt());
            buf.put(maskkey.array());
            int i = 0;
            while (mes.hasRemaining()) {
                buf.put((byte)(mes.get() ^ maskkey.get(i % 4)));
                ++i;
            }
        } else {
            buf.put(mes);
            mes.flip();
        }
        assert (buf.remaining() == 0) : buf.remaining();
        buf.flip();
        return buf;
    }

    private Framedata translateSingleFrame(ByteBuffer buffer) throws SocketException {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        int maxpacketsize = buffer.remaining();
        int realpacketsize = 2;
        this.translateSingleFrameCheckPacketSize(maxpacketsize, realpacketsize);
        byte b1 = buffer.get();
        boolean fin = b1 >> 8 != 0;
        boolean rsv1 = (b1 & 0x40) != 0;
        boolean rsv2 = (b1 & 0x20) != 0;
        boolean rsv3 = (b1 & 0x10) != 0;
        byte b2 = buffer.get();
        boolean mask = (b2 & 0xFFFFFF80) != 0;
        int payloadlength = b2 & 0x7F;
        String optcode = this.toOpcode((byte)(b1 & 0xF));
        if (payloadlength < 0 || payloadlength > 125) {
            TranslatedPayloadMetaData payloadData = this.translateSingleFramePayloadLength(buffer, optcode, payloadlength, maxpacketsize, realpacketsize);
            payloadlength = payloadData.getPayloadLength();
            realpacketsize = payloadData.getRealPackageSize();
        }
        this.translateSingleFrameCheckLengthLimit(payloadlength);
        realpacketsize += mask ? 4 : 0;
        this.translateSingleFrameCheckPacketSize(maxpacketsize, realpacketsize += payloadlength);
        ByteBuffer payload = ByteBuffer.allocate(this.checkAlloc(payloadlength));
        if (mask) {
            byte[] maskskey = new byte[4];
            buffer.get(maskskey);
            for (int i = 0; i < payloadlength; ++i) {
                payload.put((byte)(buffer.get() ^ maskskey[i % 4]));
            }
        } else {
            payload.put(buffer.array(), buffer.position(), payload.limit());
            buffer.position(buffer.position() + payload.limit());
        }
        Framedata frame = Framedata.get(optcode);
        frame.setFin(fin);
        frame.setRSV1(rsv1);
        frame.setRSV2(rsv2);
        frame.setRSV3(rsv3);
        payload.flip();
        frame.setPayload(payload);
        if (Logger.isTrace()) {
            Logger.trace("afterDecoding({}): {}", frame.getPayloadData().remaining(), frame.getPayloadData().remaining() > 1000 ? "too big to display" : new String(frame.getPayloadData().array()));
        }
        frame.isValid();
        return frame;
    }

    public int checkAlloc(int bytecount) throws SocketException {
        if (bytecount < 0) {
            throw new SocketException(1002, "Negative count");
        }
        return bytecount;
    }

    private TranslatedPayloadMetaData translateSingleFramePayloadLength(ByteBuffer buffer, String optcode, int oldPayloadlength, int maxpacketsize, int oldRealpacketsize) throws SocketException {
        int payloadlength = oldPayloadlength;
        int realpacketsize = oldRealpacketsize;
        if ("PING".equals(optcode) || "PONG".equals(optcode) || "CLOSING".equals(optcode)) {
            Logger.trace("Invalid frame: more than 125 octets", new Object[0]);
            throw new SocketException(1002, "more than 125 octets");
        }
        if (payloadlength == 126) {
            this.translateSingleFrameCheckPacketSize(maxpacketsize, realpacketsize += 2);
            byte[] sizebytes = new byte[3];
            sizebytes[1] = buffer.get();
            sizebytes[2] = buffer.get();
            payloadlength = new BigInteger(sizebytes).intValue();
        } else {
            this.translateSingleFrameCheckPacketSize(maxpacketsize, realpacketsize += 8);
            byte[] bytes = new byte[8];
            for (int i = 0; i < 8; ++i) {
                bytes[i] = buffer.get();
            }
            long length = new BigInteger(bytes).longValue();
            this.translateSingleFrameCheckLengthLimit(length);
            payloadlength = (int)length;
        }
        return new TranslatedPayloadMetaData(payloadlength, realpacketsize);
    }

    private void translateSingleFrameCheckLengthLimit(long length) throws SocketException {
        if (length > Integer.MAX_VALUE) {
            Logger.trace("Limit exedeed: Payloadsize is to big...", new Object[0]);
            throw new SocketException(Integer.MAX_VALUE, "Payloadsize is to big...");
        }
        if (length > (long)this.maxFrameSize) {
            Logger.trace("Payload limit reached. Allowed: {} Current: {}", this.maxFrameSize, length);
            throw new SocketException("Payload limit reached.", this.maxFrameSize);
        }
        if (length < 0L) {
            Logger.trace("Limit underflow: Payloadsize is to little...", new Object[0]);
            throw new SocketException(Integer.MAX_VALUE, "Payloadsize is to little...");
        }
    }

    private void translateSingleFrameCheckPacketSize(int maxpacketsize, int realpacketsize) throws SocketException {
        if (maxpacketsize < realpacketsize) {
            Logger.trace("Incomplete frame: maxpacketsize < realpacketsize", new Object[0]);
            throw new SocketException(realpacketsize);
        }
    }

    private byte getRSVByte(int rsv) {
        switch (rsv) {
            case 1: {
                return 64;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    private byte getMaskByte(boolean mask) {
        return mask ? (byte)-128 : 0;
    }

    private int getSizeBytes(ByteBuffer mes) {
        if (mes.remaining() <= 125) {
            return 1;
        }
        if (mes.remaining() <= 65535) {
            return 2;
        }
        return 8;
    }

    public List<Framedata> translateFrame(ByteBuffer buffer) throws SocketException {
        Framedata cur;
        LinkedList<Framedata> frames;
        while (true) {
            frames = new LinkedList<Framedata>();
            if (this.incompleteframe == null) break;
            try {
                buffer.mark();
                int availableNextByteCount = buffer.remaining();
                int expectedNextByteCount = this.incompleteframe.remaining();
                if (expectedNextByteCount > availableNextByteCount) {
                    this.incompleteframe.put(buffer.array(), buffer.position(), availableNextByteCount);
                    buffer.position(buffer.position() + availableNextByteCount);
                    return Collections.emptyList();
                }
                this.incompleteframe.put(buffer.array(), buffer.position(), expectedNextByteCount);
                buffer.position(buffer.position() + expectedNextByteCount);
                cur = this.translateSingleFrame(this.incompleteframe.duplicate().position(0));
                frames.add(cur);
                this.incompleteframe = null;
            }
            catch (SocketException e) {
                ByteBuffer extendedframe = ByteBuffer.allocate(this.checkAlloc(e.getValue()));
                assert (extendedframe.limit() > this.incompleteframe.limit());
                this.incompleteframe.rewind();
                extendedframe.put(this.incompleteframe);
                this.incompleteframe = extendedframe;
                continue;
            }
            break;
        }
        while (buffer.hasRemaining()) {
            buffer.mark();
            try {
                cur = this.translateSingleFrame(buffer);
                frames.add(cur);
            }
            catch (SocketException e) {
                buffer.reset();
                int pref = e.getValue();
                this.incompleteframe = ByteBuffer.allocate(this.checkAlloc(pref));
                this.incompleteframe.put(buffer);
                break;
            }
        }
        return frames;
    }

    public List<Framedata> createFrames(String text) {
        Framedata curframe = new Framedata("TEXT");
        curframe.setPayload(ByteBuffer.wrap(text.getBytes(Charset.UTF_8)));
        try {
            curframe.isValid();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonList(curframe);
    }

    public void reset() {
        this.incompleteframe = null;
        this.negotiatedExtension = "";
    }

    private String generateFinalKey(String in) {
        MessageDigest sh1;
        String seckey = in.trim();
        String acc = seckey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            sh1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return Base64.encode(sh1.digest(acc.getBytes()));
    }

    private byte[] toByteArray(long val, int bytecount) {
        byte[] buffer = new byte[bytecount];
        int highest = 8 * bytecount - 8;
        for (int i = 0; i < bytecount; ++i) {
            buffer[i] = (byte)(val >>> highest - 8 * i);
        }
        return buffer;
    }

    private byte fromOpcode(String opcode) {
        if ("CONTINUOUS".equals(opcode)) {
            return 0;
        }
        if ("TEXT".equals(opcode)) {
            return 1;
        }
        if ("BINARY".equals(opcode)) {
            return 2;
        }
        if ("CLOSING".equals(opcode)) {
            return 8;
        }
        if ("PING".equals(opcode)) {
            return 9;
        }
        if ("PONG".equals(opcode)) {
            return 10;
        }
        throw new IllegalArgumentException("Don't know how to handle " + opcode);
    }

    private String toOpcode(byte opcode) throws SocketException {
        switch (opcode) {
            case 0: {
                return "CONTINUOUS";
            }
            case 1: {
                return "TEXT";
            }
            case 2: {
                return "BINARY";
            }
            case 8: {
                return "CLOSING";
            }
            case 9: {
                return "PING";
            }
            case 10: {
                return "PONG";
            }
        }
        throw new SocketException(1002, "Unknown opcode " + (short)opcode);
    }

    public void processFrame(SocketBuilder socketBuilder, Framedata frame) throws SocketException {
        if (!"TEXT".equals(frame.getOpcode())) {
            Logger.error("non control or continious frame expected", new Object[0]);
            throw new SocketException(1002, "non control or continious frame expected");
        }
        this.processFrameText(socketBuilder, frame);
    }

    private void processFrameText(SocketBuilder socketBuilder, Framedata frame) throws SocketException {
        try {
            socketBuilder.getListener().onWebsocketMessage(socketBuilder, Draft_6455.stringUtf8(frame.getPayloadData()));
        }
        catch (RuntimeException e) {
            socketBuilder.getListener().onWebsocketError(socketBuilder, new Exception(e.getMessage()));
        }
    }

    public String getCloseHandshakeType() {
        return "TWOWAY";
    }

    private class TranslatedPayloadMetaData {
        private final int payloadLength;
        private final int realPackageSize;

        TranslatedPayloadMetaData(int newPayloadLength, int newRealPackageSize) {
            this.payloadLength = newPayloadLength;
            this.realPackageSize = newRealPackageSize;
        }

        private int getPayloadLength() {
            return this.payloadLength;
        }

        private int getRealPackageSize() {
            return this.realPackageSize;
        }
    }
}

