/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.socket;

import java.nio.ByteBuffer;
import org.aoju.bus.core.lang.Charset;
import org.aoju.lancia.worker.exception.SocketException;

public class Framedata {
    public static final int NORMAL = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1002;
    public static final int REFUSE = 1003;
    public static final int NOCODE = 1005;
    public static final int ABNORMAL_CLOSE = 1006;
    public static final int NO_UTF8 = 1007;
    public static final int POLICY_VALIDATION = 1008;
    public static final int TOOBIG = 1009;
    public static final int EXTENSION = 1010;
    public static final int UNEXPECTED_CONDITION = 1011;
    public static final int SERVICE_RESTART = 1012;
    public static final int TRY_AGAIN_LATER = 1013;
    public static final int BAD_GATEWAY = 1014;
    public static final int TLS_ERROR = 1015;
    public static final int NEVER_CONNECTED = -1;
    public static final int BUGGYCLOSE = -2;
    public static final int FLASHPOLICY = -3;
    private final String optcode;
    private boolean fin;
    private ByteBuffer unmaskedpayload;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;
    private int code;
    private String reason;

    public Framedata(String op) {
        this.optcode = op;
        this.unmaskedpayload = ByteBuffer.allocate(0);
        this.fin = true;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
    }

    public static Framedata get(String opcode) {
        if (opcode == null) {
            throw new IllegalArgumentException("Supplied opcode cannot be null");
        }
        if ("TEXT".equals(opcode)) {
            return new Framedata("TEXT");
        }
        throw new IllegalArgumentException("Supplied opcode is invalid");
    }

    public void setCode(int code) {
        this.code = code;
        if (code == 1015) {
            this.code = 1005;
            this.reason = "";
        }
        this.updatePayload();
    }

    public void setReason(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.reason = reason;
        this.updatePayload();
    }

    private void updatePayload() {
        byte[] by = this.reason.getBytes(Charset.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.code);
        buf.position(2);
        ByteBuffer pay = ByteBuffer.allocate(2 + by.length);
        pay.put(buf);
        pay.put(by);
        pay.rewind();
        this.setPayload(pay);
    }

    public void isValid() throws SocketException {
        if (!this.isFin()) {
            throw new SocketException(1002, "Control frame can't have fin==false set");
        }
        if (this.isRSV1()) {
            throw new SocketException(1002, "Control frame can't have rsv1==true set");
        }
        if (this.isRSV2()) {
            throw new SocketException(1002, "Control frame can't have rsv2==true set");
        }
        if (this.isRSV3()) {
            throw new SocketException(1002, "Control frame can't have rsv3==true set");
        }
    }

    public boolean isRSV1() {
        return this.rsv1;
    }

    public void setRSV1(boolean rsv1) {
        this.rsv1 = rsv1;
    }

    public boolean isRSV2() {
        return this.rsv2;
    }

    public void setRSV2(boolean rsv2) {
        this.rsv2 = rsv2;
    }

    public boolean isRSV3() {
        return this.rsv3;
    }

    public void setRSV3(boolean rsv3) {
        this.rsv3 = rsv3;
    }

    public boolean isFin() {
        return this.fin;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public String getOpcode() {
        return this.optcode;
    }

    public ByteBuffer getPayloadData() {
        if (this.code == 1005) {
            return ByteBuffer.allocate(0);
        }
        return this.unmaskedpayload;
    }

    public void setPayload(ByteBuffer payload) {
        this.unmaskedpayload = payload;
    }
}

