/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.socket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.thread.NamedThreadFactory;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.socket.HandshakeBuilder;
import org.aoju.lancia.socket.SocketBuilder;
import org.aoju.lancia.socket.SocketListener;
import org.aoju.lancia.socket.WebSocket;

public abstract class ListenerBuilder
implements SocketListener {
    private final Object syncConnectionLost = new Object();
    private boolean tcpNoDelay;
    private boolean reuseAddr;
    private ScheduledExecutorService connectionLostCheckerService;
    private ScheduledFuture<?> connectionLostCheckerFuture;
    private long connectionLostTimeout = TimeUnit.SECONDS.toNanos(60L);
    private boolean websocketRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionLostTimeout() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            return (int)TimeUnit.NANOSECONDS.toSeconds(this.connectionLostTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionLostTimeout(int connectionLostTimeout) {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            this.connectionLostTimeout = TimeUnit.SECONDS.toNanos(connectionLostTimeout);
            if (this.connectionLostTimeout <= 0L) {
                Logger.trace("Connection lost timer stopped", new Object[0]);
                this.cancelConnectionLostTimer();
                return;
            }
            if (this.websocketRunning) {
                Logger.trace("Connection lost timer restarted", new Object[0]);
                try {
                    ArrayList<WebSocket> connections = new ArrayList<WebSocket>(this.getConnections());
                    for (WebSocket conn : connections) {
                        if (!(conn instanceof SocketBuilder)) continue;
                        SocketBuilder socketBuilder = (SocketBuilder)conn;
                        socketBuilder.updateLastPong();
                    }
                }
                catch (Exception e) {
                    Logger.error("Exception during connection lost restart", e);
                }
                this.restartConnectionLostTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostCheckerService != null || this.connectionLostCheckerFuture != null) {
                this.websocketRunning = false;
                Logger.trace("Connection lost timer stopped", new Object[0]);
                this.cancelConnectionLostTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startConnectionLostTimer() {
        Object object = this.syncConnectionLost;
        synchronized (object) {
            if (this.connectionLostTimeout <= 0L) {
                Logger.trace("Connection lost timer deactivated", new Object[0]);
                return;
            }
            Logger.trace("Connection lost timer started", new Object[0]);
            this.websocketRunning = true;
            this.restartConnectionLostTimer();
        }
    }

    private void restartConnectionLostTimer() {
        this.cancelConnectionLostTimer();
        this.connectionLostCheckerService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("connectionLostChecker"));
        Runnable connectionLostChecker = new Runnable(){
            private final ArrayList<WebSocket> connections = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.connections.clear();
                try {
                    long minimumPongTime;
                    this.connections.addAll(ListenerBuilder.this.getConnections());
                    Iterator<WebSocket> iterator = ListenerBuilder.this.syncConnectionLost;
                    synchronized (iterator) {
                        minimumPongTime = (long)((double)System.nanoTime() - (double)ListenerBuilder.this.connectionLostTimeout * 1.5);
                    }
                    for (WebSocket conn : this.connections) {
                        ListenerBuilder.this.executeConnectionLostDetection(conn, minimumPongTime);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connections.clear();
            }
        };
        this.connectionLostCheckerFuture = this.connectionLostCheckerService.scheduleAtFixedRate(connectionLostChecker, this.connectionLostTimeout, this.connectionLostTimeout, TimeUnit.NANOSECONDS);
    }

    private void executeConnectionLostDetection(WebSocket webSocket, long minimumPongTime) {
        if (!(webSocket instanceof SocketBuilder)) {
            return;
        }
        SocketBuilder socketBuilder = (SocketBuilder)webSocket;
        if (socketBuilder.getLastPong() < minimumPongTime) {
            Logger.trace("Closing connection due to no pong received: {}", socketBuilder);
            socketBuilder.closeConnection(1006, "The connection was closed because the other endpoint did not respond with a pong in time. For more information check: https://github.com/TooTallNate/Java-WebSocket/wiki/Lost-connection-detection");
        } else if (socketBuilder.isOpen()) {
            socketBuilder.sendPing();
        } else {
            Logger.trace("Trying to ping a non open connection: {}", socketBuilder);
        }
    }

    protected abstract Collection<WebSocket> getConnections();

    private void cancelConnectionLostTimer() {
        if (this.connectionLostCheckerService != null) {
            this.connectionLostCheckerService.shutdownNow();
            this.connectionLostCheckerService = null;
        }
        if (this.connectionLostCheckerFuture != null) {
            this.connectionLostCheckerFuture.cancel(false);
            this.connectionLostCheckerFuture = null;
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, HandshakeBuilder request, HandshakeBuilder response) {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, HandshakeBuilder request) {
    }
}

