/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.socket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.socket.Draft_6455;
import org.aoju.lancia.socket.Framedata;
import org.aoju.lancia.socket.HandshakeBuilder;
import org.aoju.lancia.socket.ReadyState;
import org.aoju.lancia.socket.SocketListener;
import org.aoju.lancia.socket.WebSocket;
import org.aoju.lancia.worker.exception.SocketException;

public class SocketBuilder
implements WebSocket {
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_WSS_PORT = 443;
    public static final int RCVBUF = 16384;
    public final BlockingQueue<ByteBuffer> outQueue;
    public final BlockingQueue<ByteBuffer> inQueue;
    private final SocketListener listener;
    private final Object synchronizeWriteObject = new Object();
    private boolean flushandclosestate = false;
    private volatile ReadyState readyState = ReadyState.NOT_YET_CONNECTED;
    private Draft_6455 draft = null;
    private ByteBuffer tmpHandshakeBytes = ByteBuffer.allocate(0);
    private HandshakeBuilder handshakeRequest = null;
    private Integer closeCode = null;
    private Boolean closeRemote = null;
    private String closeMessage = null;
    private String descriptor = null;
    private long lastPong = System.nanoTime();
    private Object attachment;

    public SocketBuilder(SocketListener listener, Draft_6455 draft) {
        if (draft == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        this.outQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.inQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.listener = listener;
        if (draft != null) {
            this.draft = draft.copyInstance();
        }
    }

    public void decode(ByteBuffer socketBuffer) {
        assert (socketBuffer.hasRemaining());
        Logger.trace("process({}): ({})", socketBuffer.remaining(), socketBuffer.remaining() > 1000 ? "too big to display" : new String(socketBuffer.array(), socketBuffer.position(), socketBuffer.remaining()));
        if (this.readyState != ReadyState.NOT_YET_CONNECTED) {
            if (this.readyState == ReadyState.OPEN) {
                this.decodeFrames(socketBuffer);
            }
        } else if (this.decodeHandshake(socketBuffer) && !this.isClosing() && !this.isClosed()) {
            assert (this.tmpHandshakeBytes.hasRemaining() != socketBuffer.hasRemaining() || !socketBuffer.hasRemaining());
            if (socketBuffer.hasRemaining()) {
                this.decodeFrames(socketBuffer);
            } else if (this.tmpHandshakeBytes.hasRemaining()) {
                this.decodeFrames(this.tmpHandshakeBytes);
            }
        }
    }

    private boolean decodeHandshake(ByteBuffer socketBufferNew) {
        ByteBuffer socketBuffer;
        if (this.tmpHandshakeBytes.capacity() == 0) {
            socketBuffer = socketBufferNew;
        } else {
            if (this.tmpHandshakeBytes.remaining() < socketBufferNew.remaining()) {
                ByteBuffer buf = ByteBuffer.allocate(this.tmpHandshakeBytes.capacity() + socketBufferNew.remaining());
                this.tmpHandshakeBytes.flip();
                buf.put(this.tmpHandshakeBytes);
                this.tmpHandshakeBytes = buf;
            }
            this.tmpHandshakeBytes.put(socketBufferNew);
            this.tmpHandshakeBytes.flip();
            socketBuffer = this.tmpHandshakeBytes;
        }
        socketBuffer.mark();
        try {
            HandshakeBuilder tmphandshake = this.draft.translateHandshake(socketBuffer);
            if ("MATCHED" == this.draft.acceptHandshakeAsClient(this.handshakeRequest, tmphandshake)) {
                try {
                    this.listener.onWebsocketHandshakeReceivedAsClient(this, this.handshakeRequest, tmphandshake);
                }
                catch (SocketException e) {
                    Logger.trace("Closing due to invalid data exception. Possible handshake rejection", e);
                    this.flushAndClose(e.getValue(), e.getMessage(), false);
                    return false;
                }
                catch (RuntimeException e) {
                    Logger.error("Closing since client was never connected", e);
                    this.listener.onWebsocketError(this, e);
                    this.flushAndClose(-1, e.getMessage(), false);
                    return false;
                }
                this.open(tmphandshake);
                return true;
            }
            Logger.trace("Closing due to protocol error: draft {} refuses handshake", this.draft);
            this.close(1002, "draft " + String.valueOf(this.draft) + " refuses handshake");
        }
        catch (SocketException e) {
            Logger.trace("Closing due to invalid handshake", e);
            this.close(e);
        }
        return false;
    }

    private void decodeFrames(ByteBuffer socketBuffer) {
        try {
            List<Framedata> frames = this.draft.translateFrame(socketBuffer);
            for (Framedata f : frames) {
                Logger.trace("matched frame: {}", f);
                this.draft.processFrame(this, f);
            }
        }
        catch (SocketException e) {
            Logger.error("Closing due to invalid data in frame", e);
            this.listener.onWebsocketError(this, e);
            this.close(e);
        }
        catch (LinkageError | ThreadDeath | VirtualMachineError e) {
            Logger.error("Got fatal error during frame processing", new Object[0]);
            throw e;
        }
        catch (Error e) {
            Logger.error("Closing web org.aoju.lancia.socket due to an error during frame processing", new Object[0]);
            Exception exception = new Exception(e);
            this.listener.onWebsocketError(this, exception);
            String errorMessage = "Got error " + e.getClass().getName();
            this.close(1011, errorMessage);
        }
    }

    @Override
    public void close(int code) {
        this.close(code, "", false);
    }

    public void close(SocketException e) {
        this.close(e.getValue(), e.getMessage(), false);
    }

    @Override
    public void close(int code, String message) {
        this.close(code, message, false);
    }

    public synchronized void close(int code, String message, boolean remote) {
        if (this.readyState != ReadyState.CLOSING && this.readyState != ReadyState.CLOSED) {
            if (this.readyState == ReadyState.OPEN) {
                if (code == 1006) {
                    assert (!remote);
                    this.readyState = ReadyState.CLOSING;
                    this.flushAndClose(code, message, false);
                    return;
                }
                if (!"NONE".equals(this.draft.getCloseHandshakeType())) {
                    try {
                        if (!remote) {
                            try {
                                this.listener.onWebsocketCloseInitiated(this, code, message);
                            }
                            catch (RuntimeException e) {
                                this.listener.onWebsocketError(this, e);
                            }
                        }
                        if (this.isOpen()) {
                            Framedata closeFrame = new Framedata("CLOSING");
                            closeFrame.setReason(message);
                            closeFrame.setCode(code);
                            closeFrame.isValid();
                            this.sendFrame(closeFrame);
                        }
                    }
                    catch (SocketException e) {
                        Logger.error("generated frame is invalid", e);
                        this.listener.onWebsocketError(this, e);
                        this.flushAndClose(1006, "generated frame is invalid", false);
                    }
                }
                this.flushAndClose(code, message, remote);
            } else if (code == -3) {
                assert (remote);
                this.flushAndClose(-3, message, true);
            } else if (code == 1002) {
                this.flushAndClose(code, message, remote);
            } else {
                this.flushAndClose(-1, message, false);
            }
            this.readyState = ReadyState.CLOSING;
            this.tmpHandshakeBytes = null;
        }
    }

    public void closeConnection() {
        if (this.closeRemote == null) {
            throw new IllegalStateException("this method must be used in conjunction with flushAndClose");
        }
        this.closeConnection(this.closeCode, this.closeMessage, this.closeRemote);
    }

    protected void closeConnection(int code, boolean remote) {
        this.closeConnection(code, "", remote);
    }

    @Override
    public void closeConnection(int code, String message) {
        this.closeConnection(code, message, false);
    }

    public synchronized void closeConnection(int code, String message, boolean remote) {
        if (this.readyState == ReadyState.CLOSED) {
            return;
        }
        if (this.readyState == ReadyState.OPEN && code == 1006) {
            this.readyState = ReadyState.CLOSING;
        }
        try {
            this.listener.onWebsocketClose(this, code, message, remote);
        }
        catch (RuntimeException e) {
            this.listener.onWebsocketError(this, e);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakeRequest = null;
        this.readyState = ReadyState.CLOSED;
    }

    public synchronized void flushAndClose(int code, String message, boolean remote) {
        if (this.flushandclosestate) {
            return;
        }
        this.closeCode = code;
        this.closeMessage = message;
        this.closeRemote = remote;
        this.flushandclosestate = true;
        this.listener.onWriteDemand(this);
        try {
            this.listener.onWebsocketClosing(this, code, message, remote);
        }
        catch (RuntimeException e) {
            Logger.error("Exception in onWebsocketClosing", e);
            this.listener.onWebsocketError(this, e);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakeRequest = null;
    }

    public void eot() {
        if (this.readyState == ReadyState.NOT_YET_CONNECTED) {
            this.closeConnection(-1, true);
        } else if (this.flushandclosestate) {
            this.closeConnection(this.closeCode, this.closeMessage, this.closeRemote);
        } else if ("NONE".equals(this.draft.getCloseHandshakeType())) {
            this.closeConnection(1000, true);
        } else if ("ONEWAY".equals(this.draft.getCloseHandshakeType())) {
            this.closeConnection(1000, true);
        } else {
            this.closeConnection(1006, true);
        }
    }

    @Override
    public void send(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a SocketBuilder.");
        }
        this.send(this.draft.createFrames(text));
    }

    private void send(Collection<Framedata> frames) {
        if (!this.isOpen()) {
            throw new RuntimeException("readyState is close");
        }
        if (frames == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ByteBuffer> outgoingFrames = new ArrayList<ByteBuffer>();
        for (Framedata f : frames) {
            Logger.trace("send frame: {}", f);
            outgoingFrames.add(this.draft.createBinaryFrame(f));
        }
        this.write(outgoingFrames);
    }

    @Override
    public void sendFragmentedFrame(String op, ByteBuffer buffer, boolean fin) {
        this.send(this.draft.continuousFrame(op, buffer, fin));
    }

    @Override
    public void sendFrame(Collection<Framedata> frames) {
        this.send(frames);
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.send(Collections.singletonList(framedata));
    }

    @Override
    public void sendPing() throws NullPointerException {
    }

    @Override
    public boolean hasBufferedData() {
        return !this.outQueue.isEmpty();
    }

    public void startHandshake(HandshakeBuilder handshake) throws SocketException {
        this.handshakeRequest = this.draft.postProcessHandshakeRequestAsClient(handshake);
        this.descriptor = handshake.getDescriptor();
        assert (this.descriptor != null);
        try {
            this.listener.onWebsocketHandshakeSentAsClient(this, this.handshakeRequest);
        }
        catch (SocketException e) {
            throw new SocketException(1002, "HandshakeBuilder data rejected by client.");
        }
        catch (RuntimeException e) {
            Logger.error("Exception in startHandshake", e);
            this.listener.onWebsocketError(this, e);
            throw new SocketException(1002, "rejected because of " + String.valueOf(e));
        }
        this.write(this.draft.createHandshake(this.handshakeRequest));
    }

    private void write(ByteBuffer buf) {
        Logger.trace("write({}): {}", buf.remaining(), buf.remaining() > 1000 ? "too big to display" : new String(buf.array()));
        this.outQueue.add(buf);
        this.listener.onWriteDemand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<ByteBuffer> bufs) {
        Object object = this.synchronizeWriteObject;
        synchronized (object) {
            for (ByteBuffer b : bufs) {
                this.write(b);
            }
        }
    }

    private void open(HandshakeBuilder d) {
        Logger.trace("open using draft: {}", this.draft);
        this.readyState = ReadyState.OPEN;
        this.updateLastPong();
        try {
            this.listener.onWebsocketOpen(this, d);
        }
        catch (RuntimeException e) {
            this.listener.onWebsocketError(this, e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.readyState == ReadyState.OPEN;
    }

    @Override
    public boolean isClosing() {
        return this.readyState == ReadyState.CLOSING;
    }

    @Override
    public boolean isFlushAndClose() {
        return this.flushandclosestate;
    }

    @Override
    public boolean isClosed() {
        return this.readyState == ReadyState.CLOSED;
    }

    @Override
    public ReadyState getReadyState() {
        return this.readyState;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.listener.getRemoteSocketAddress(this);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.listener.getLocalSocketAddress(this);
    }

    @Override
    public void close() {
        this.close(1000);
    }

    long getLastPong() {
        return this.lastPong;
    }

    public void updateLastPong() {
        this.lastPong = System.nanoTime();
    }

    public SocketListener getListener() {
        return this.listener;
    }

    @Override
    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    @Override
    public <T> void setAttachment(T attachment) {
        this.attachment = attachment;
    }
}

