/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.worker;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.Messages;
import org.aoju.lancia.worker.exception.ProtocolException;
import org.aoju.lancia.worker.exception.TimeoutException;

public class CDPSession
extends EventEmitter {
    private final Map<Long, Messages> callbacks = new ConcurrentHashMap<Long, Messages>();
    private final String targetType;
    private final String sessionId;
    private Connection connection;

    public CDPSession(Connection connection, String targetType, String sessionId) {
        this.targetType = targetType;
        this.sessionId = sessionId;
        this.connection = connection;
    }

    public void onClosed() {
        for (Messages callback : this.callbacks.values()) {
            callback.setErrorText("Protocol error " + callback.getMethod() + " Target closed.");
            if (callback.getCountDownLatch() == null) continue;
            callback.getCountDownLatch().countDown();
        }
        this.connection = null;
        this.callbacks.clear();
        this.emit(Events.CDPSESSION_DISCONNECTED.getName(), null);
    }

    public JSONObject send(String method, Map<String, Object> params, boolean isBlock, CountDownLatch outLatch, int timeout) {
        if (this.connection == null) {
            throw new ProtocolException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        Messages message = new Messages();
        message.setMethod(method);
        message.setParams(params);
        message.setSessionId(this.sessionId);
        try {
            if (isBlock) {
                if (outLatch != null) {
                    message.setCountDownLatch(outLatch);
                } else {
                    CountDownLatch latch = new CountDownLatch(1);
                    message.setCountDownLatch(latch);
                }
                long id = this.connection.rawSend(message, true, this.callbacks);
                boolean hasResult = message.waitForResult(timeout > 0 ? (long)timeout : 30000L, TimeUnit.MILLISECONDS);
                if (!hasResult) {
                    throw new TimeoutException("Wait " + method + " for " + (timeout > 0 ? timeout : 30000) + " MILLISECONDS with no response");
                }
                if (StringKit.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            if (outLatch != null) {
                message.setNeedRemove(true);
                message.setCountDownLatch(outLatch);
                this.connection.rawSend(message, true, this.callbacks);
            } else {
                this.connection.rawSend(message, false, this.callbacks);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public JSONObject send(String method, Map<String, Object> params, boolean isBlock) {
        if (this.connection == null) {
            throw new ProtocolException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        Messages message = new Messages();
        message.setMethod(method);
        message.setParams(params);
        message.setSessionId(this.sessionId);
        try {
            if (isBlock) {
                CountDownLatch latch = new CountDownLatch(1);
                message.setCountDownLatch(latch);
                long id = this.connection.rawSend(message, true, this.callbacks);
                boolean hasResult = message.waitForResult(this.connection.getConnectionOptions().getSessionWaitingResultTimeout(), TimeUnit.MILLISECONDS);
                if (!hasResult) {
                    throw new TimeoutException("Wait " + method + " for sessionWaitingResultTimeout:" + this.connection.getConnectionOptions().getSessionWaitingResultTimeout() + " MILLISECONDS with no response");
                }
                if (StringKit.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            this.connection.rawSend(message, false, this.callbacks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void detach() {
        if (this.connection == null) {
            throw new RuntimeException("Session already detached. Most likely the" + this.targetType + "has been closed.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionId", this.sessionId);
        this.connection.send("Target.detachFromTarget", params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(JSONObject node) {
        Long id = node.getLong("id");
        if (id != null) {
            Messages callback = this.callbacks.get(id);
            if (callback == null) return;
            try {
                JSONObject errNode = node.getJSONObject("error");
                if (errNode != null) {
                    if (callback.getCountDownLatch() == null) return;
                    callback.setErrorText(Builder.createProtocolError(node));
                    return;
                }
                JSONObject result = node.getJSONObject("result");
                callback.setResult(result);
                return;
            }
            finally {
                if (callback.getNeedRemove()) {
                    this.callbacks.remove(id);
                }
                if (callback.getCountDownLatch() != null) {
                    callback.getCountDownLatch().countDown();
                    callback.setCountDownLatch(null);
                }
            }
        } else {
            JSONObject paramsNode = node.getJSONObject("params");
            String method = node.getString("method");
            if (method == null) return;
            this.emit(method, paramsNode);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

