/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.worker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.Builder;
import org.aoju.lancia.events.EventEmitter;
import org.aoju.lancia.events.Events;
import org.aoju.lancia.kernel.page.TargetInfo;
import org.aoju.lancia.option.ConnectionOptions;
import org.aoju.lancia.worker.CDPSession;
import org.aoju.lancia.worker.Messages;
import org.aoju.lancia.worker.SocketTransport;
import org.aoju.lancia.worker.Transport;
import org.aoju.lancia.worker.exception.ProtocolException;

public class Connection
extends EventEmitter
implements Consumer<String> {
    private static final AtomicLong lastId = new AtomicLong(0L);
    private final String url;
    private final Transport transport;
    private final int delay;
    private final Map<Long, Messages> callbacks = new ConcurrentHashMap<Long, Messages>();
    private final Map<String, CDPSession> sessions = new ConcurrentHashMap<String, CDPSession>();
    private boolean closed;
    private ConnectionOptions connectionOptions;

    public Connection(String url, Transport transport, int delay) {
        this.url = url;
        this.transport = transport;
        this.delay = delay;
        if (this.transport instanceof SocketTransport) {
            ((SocketTransport)this.transport).addConsumer(this);
            ((SocketTransport)this.transport).addConnection(this);
        }
        this.connectionOptions = new ConnectionOptions();
    }

    public Connection(String url, Transport transport, int delay, ConnectionOptions connectionOptions) {
        this(url, transport, delay);
        this.connectionOptions = connectionOptions == null ? new ConnectionOptions() : connectionOptions;
    }

    public static Connection fromSession(CDPSession client) {
        return client.getConnection();
    }

    public JSONObject send(String method, Map<String, Object> params, boolean isWait) {
        Messages message = new Messages();
        message.setMethod(method);
        message.setParams(params);
        try {
            if (isWait) {
                message.setCountDownLatch(new CountDownLatch(1));
                long id = this.rawSend(message, true, this.callbacks);
                message.waitForResult(0L, TimeUnit.MILLISECONDS);
                if (StringKit.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            this.rawSend(message, false, this.callbacks);
            return null;
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public JSONObject send(String method, Map<String, Object> params, boolean isWait, CountDownLatch outLatch) {
        Messages message = new Messages();
        message.setMethod(method);
        message.setParams(params);
        try {
            if (isWait) {
                if (outLatch != null) {
                    message.setCountDownLatch(outLatch);
                } else {
                    message.setCountDownLatch(new CountDownLatch(1));
                }
                long id = this.rawSend(message, true, this.callbacks);
                message.waitForResult(0L, TimeUnit.MILLISECONDS);
                if (StringKit.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            if (outLatch != null) {
                message.setNeedRemove(true);
                message.setCountDownLatch(outLatch);
                this.rawSend(message, true, this.callbacks);
            } else {
                this.rawSend(message, false, this.callbacks);
            }
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
        return null;
    }

    public long rawSend(Messages message, boolean putCallback, Map<Long, Messages> callbacks) {
        long id = lastId.incrementAndGet();
        message.setId(id);
        if (putCallback) {
            callbacks.put(id, message);
        }
        String sendMsg = JSON.toJSONString((Object)message);
        this.transport.send(sendMsg);
        Logger.trace("SEND -> " + sendMsg, new Object[0]);
        return id;
    }

    public void onMessage(String message) {
        CDPSession cdpSession;
        String sessionId;
        JSONObject paramsNode;
        if (this.delay > 0) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                Logger.error("slowMo browser Fail:", e);
            }
        }
        Logger.trace("<- RECV " + message, new Object[0]);
        if (StringKit.isEmpty(message)) {
            return;
        }
        JSONObject readTree = JSON.parseObject((String)message);
        String methodNode = readTree.getString("method");
        String method = null;
        if (methodNode != null) {
            method = methodNode;
        }
        if ("Target.attachedToTarget".equals(method)) {
            paramsNode = readTree.getJSONObject("params");
            sessionId = paramsNode.getString("sessionId");
            String typeNode = paramsNode.getJSONObject("targetInfo").getString("type");
            CDPSession cdpSession2 = new CDPSession(this, typeNode, sessionId);
            this.sessions.put(sessionId, cdpSession2);
        } else if ("Target.detachedFromTarget".equals(method) && (cdpSession = this.sessions.get(sessionId = (paramsNode = readTree.getJSONObject("params")).getString("sessionId"))) != null) {
            cdpSession.onClosed();
            this.sessions.remove(sessionId);
        }
        String objectSessionId = readTree.getString("sessionId");
        Long objectId = readTree.getLong("id");
        if (objectSessionId != null) {
            cdpSession = this.sessions.get(objectSessionId);
            if (cdpSession != null) {
                cdpSession.onMessage(readTree);
            }
        } else if (objectId != null) {
            long id = objectId;
            Messages callback = this.callbacks.get(id);
            if (callback != null) {
                JSONObject error = readTree.getJSONObject("error");
                if (error != null) {
                    if (callback.getCountDownLatch() != null) {
                        callback.setErrorText(Builder.createProtocolError(readTree));
                    }
                } else {
                    JSONObject result = readTree.getJSONObject("result");
                    callback.setResult(result);
                }
                if (callback.getNeedRemove()) {
                    this.callbacks.remove(id);
                }
                if (callback.getCountDownLatch() != null) {
                    callback.getCountDownLatch().countDown();
                    callback.setCountDownLatch(null);
                }
            }
        } else {
            JSONObject paramsNode2 = readTree.getJSONObject("params");
            this.emit(method, paramsNode2);
        }
    }

    public CDPSession createSession(TargetInfo targetInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", targetInfo.getTargetId());
        params.put("flatten", true);
        JSONObject result = this.send("Target.attachToTarget", params, true);
        return this.sessions.get(result.getString("sessionId"));
    }

    public String url() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public CDPSession session(String sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public void accept(String message) {
        this.onMessage(message);
    }

    public void dispose() {
        this.onClose();
        this.transport.close();
    }

    public void onClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Messages callback : this.callbacks.values()) {
            callback.setErrorText("Protocol error " + callback.getMethod() + " Target closed.");
            if (callback.getCountDownLatch() == null) continue;
            callback.getCountDownLatch().countDown();
        }
        this.callbacks.clear();
        for (CDPSession session : this.sessions.values()) {
            session.onClosed();
        }
        this.sessions.clear();
        this.emit(Events.CONNECTION_DISCONNECTED.getName(), null);
    }

    public boolean getClosed() {
        return this.closed;
    }

    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions == null ? new ConnectionOptions() : connectionOptions;
    }
}

