/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.worker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.worker.Transport;

public class PipeTransport
implements Transport {
    private final BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private final StringBuffer pendingMessage = new StringBuffer();
    private InputStream pipeReader;
    private OutputStream pipeWriter;
    private Thread readThread;
    private Thread writerThread;

    public PipeTransport() {
    }

    public PipeTransport(InputStream pipeReader, OutputStream pipeWriter) {
        this.pipeReader = pipeReader;
        this.pipeWriter = pipeWriter;
        this.readThread = new Thread(new PipeReaderThread());
        this.readThread.start();
        this.writerThread = new Thread(new PipeWriterThread());
        this.writerThread.start();
    }

    @Override
    public void send(String message) {
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void close() {
        IoKit.close(this.pipeWriter);
        IoKit.close(this.pipeReader);
    }

    private class PipeReaderThread
    implements Runnable {
        private PipeReaderThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int read;
                        if ((char)(read = PipeTransport.this.pipeReader.read()) != '\u0000') {
                            PipeTransport.this.pendingMessage.append((char)read);
                            continue;
                        }
                        String message = PipeTransport.this.pendingMessage.toString();
                        PipeTransport.this.pendingMessage.delete(0, PipeTransport.this.pendingMessage.length());
                        PipeTransport.this.onMessage(message);
                    }
                }
                catch (IOException e) {
                    Logger.error("read message from chrome error ", e);
                    continue;
                }
                break;
            }
        }
    }

    private class PipeWriterThread
    implements Runnable {
        private PipeWriterThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String message = PipeTransport.this.messageQueue.take();
                        PipeTransport.this.pipeWriter.write(message.getBytes());
                        PipeTransport.this.pipeWriter.write(0);
                        PipeTransport.this.pipeWriter.flush();
                    }
                }
                catch (IOException | InterruptedException e) {
                    Logger.error("pipe transport send message fail ", e);
                    continue;
                }
                break;
            }
        }
    }
}

