/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.worker;

import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.socket.Draft_6455;
import org.aoju.lancia.socket.HandshakeBuilder;
import org.aoju.lancia.socket.SocketClient;
import org.aoju.lancia.worker.Connection;
import org.aoju.lancia.worker.Transport;

public class SocketTransport
extends SocketClient
implements Transport {
    private Consumer<String> messageConsumer = null;
    private Connection connection = null;

    public SocketTransport(URI serverURI) {
        super(serverURI);
    }

    public SocketTransport(URI serverUri, Draft_6455 draft) {
        super(serverUri, draft);
    }

    public SocketTransport(URI serverUri, Map<String, String> httpHeaders) {
        super(serverUri, httpHeaders);
    }

    @Override
    public void send(String text) {
        if (this.connection == null) {
            Logger.warn("Transport connection is null, maybe closed?", new Object[0]);
            return;
        }
        Logger.debug(text, new Object[0]);
        super.send(text);
    }

    @Override
    public void onMessage(String message) {
        Assert.notNull(this.messageConsumer, "MessageConsumer must be initialized", new Object[0]);
        this.messageConsumer.accept(message);
    }

    @Override
    public void onClose() {
        this.close();
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        Logger.info("Connection closed by " + (remote ? "remote peer" : "us") + " Code: " + code, new Object[0]);
        this.onClose();
        if (this.connection != null) {
            this.connection.dispose();
        }
    }

    @Override
    public void onError(Exception e) {
    }

    @Override
    public void onOpen(HandshakeBuilder handshake) {
        Logger.info("Websocket handshake status : " + handshake.getStatus(), new Object[0]);
    }

    public void addConsumer(Consumer<String> consumer) {
        this.messageConsumer = consumer;
    }

    public void addConnection(Connection connection) {
        this.connection = connection;
    }
}

