/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.lancia.worker;

import java.net.URI;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.logger.Logger;
import org.aoju.lancia.worker.PipeTransport;
import org.aoju.lancia.worker.SocketTransport;
import org.aoju.lancia.worker.Transport;

public class TransportFactory {
    public static Transport create(String browserWSEndpoint) {
        try {
            return TransportFactory.socket(browserWSEndpoint);
        }
        catch (InterruptedException | InternalException e) {
            Logger.warn(e.getMessage(), new Object[0]);
            return TransportFactory.pipe();
        }
    }

    public static Transport socket(String browserWSEndpoint) throws InterruptedException {
        SocketTransport client = new SocketTransport(URI.create(browserWSEndpoint));
        client.setConnectionLostTimeout(0);
        client.connectBlocking();
        return client;
    }

    public static Transport pipe() {
        return new PipeTransport();
    }
}

