/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.protocol.client.util.NonOpTrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class ClientAuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private static final String DEFAULT_KMF_FACTORY = "ibmX509";
    private final String protocol;
    private final String kmfFactory;
    private final TrustManager tm;
    private final String keyStorePass;
    private final KeyStore ks;

    public ClientAuthSSLProtocolSocketFactory(KeyStore ks, String keyStorePass) {
        this(ks, keyStorePass, DEFAULT_PROTOCOL, DEFAULT_KMF_FACTORY, null);
    }

    public ClientAuthSSLProtocolSocketFactory(KeyStore ks, String keyStorePass, String protocol, String kmfFactory, TrustManager tm) {
        if (ks == null) {
            throw new IllegalArgumentException(Localizer.get("INVALID.KEYSTORE"));
        }
        this.ks = ks;
        this.keyStorePass = keyStorePass;
        this.protocol = protocol != null ? protocol : DEFAULT_PROTOCOL;
        this.kmfFactory = kmfFactory != null ? kmfFactory : DEFAULT_KMF_FACTORY;
        this.tm = tm;
    }

    public ClientAuthSSLProtocolSocketFactory(String keyStore, String keyStoreType, String keyStorePass, String protocol, String kmfFactory, TrustManager tm) {
        this(ClientAuthSSLProtocolSocketFactory.initKeyStore(keyStore, keyStoreType, keyStorePass), keyStorePass, protocol, kmfFactory, tm);
    }

    private static KeyStore initKeyStore(String keyStore, String keyStoreType, String keyPass) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(keyStoreType);
            ks.load(new FileInputStream(keyStore), keyPass.toCharArray());
        }
        catch (Exception e) {
            // empty catch block
        }
        return ks;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean close) throws IOException, UnknownHostException {
        return this.createSocket(host, port, null, 0, null);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(host, port, null, 0, null);
    }

    public Socket createSocket(String host, int port, InetAddress chost, int cport) throws IOException, UnknownHostException {
        return this.createSocket(host, port, chost, cport, null);
    }

    public Socket createSocket(String host, int port, InetAddress chost, int cport, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocketFactory factory = null;
        SSLSocket socket = null;
        try {
            SSLContext context = SSLContext.getInstance(this.protocol);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.kmfFactory);
            TrustManager tm = this.tm != null ? this.tm : new NonOpTrustManager();
            kmf.init(this.ks, this.keyStorePass.toCharArray());
            context.init(kmf.getKeyManagers(), new TrustManager[]{tm}, null);
            factory = context.getSocketFactory();
            socket = (SSLSocket)factory.createSocket(host, port);
            return socket;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

