/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.i18n.rfc4646.Range;
import org.apache.abdera.i18n.rfc4646.SubtagSet;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalizationHelper {
    private LocalizationHelper() {
    }

    public static Link[] selectAlternate(Source source) {
        return LocalizationHelper.selectAlternate(source, Locale.getDefault());
    }

    public static Link[] selectAlternate(Entry entry) {
        return LocalizationHelper.selectAlternate(entry, Locale.getDefault());
    }

    public static Link[] selectAlternate(Source source, Locale locale) {
        return LocalizationHelper.selectAlternate(source, new Range(Lang.fromLocale((Locale)locale), true));
    }

    public static Link[] selectAlternate(Entry entry, Locale locale) {
        return LocalizationHelper.selectAlternate(entry, new Range(Lang.fromLocale((Locale)locale), true));
    }

    public static Link[] selectAlternate(Entry entry, Locale ... locales) {
        Range[] ranges = new Range[locales.length];
        int n = 0;
        while (n < locales.length) {
            ranges[n] = new Range(Lang.fromLocale((Locale)locales[n]), true);
            ++n;
        }
        return LocalizationHelper.selectAlternate(entry, ranges);
    }

    public static Link[] selectAlternate(Entry entry, Range range) {
        return LocalizationHelper.selectAlternate(entry, new Range[]{range});
    }

    public static Link[] selectAlternate(Entry entry, Range ... ranges) {
        return LocalizationHelper.selectAlternate((List<Link>)entry.getLinks("alternate"), ranges);
    }

    public static Link[] selectAlternate(Entry entry, String range) {
        return LocalizationHelper.selectAlternate(entry, new String[]{range});
    }

    public static Link[] selectAlternate(Entry entry, String ... ranges) {
        Range[] r = new Range[ranges.length];
        int n = 0;
        while (n < ranges.length) {
            r[n] = new Range(ranges[n], true);
            ++n;
        }
        return LocalizationHelper.selectAlternate(entry, r);
    }

    public static Link[] selectAlternate(Source source, Locale ... locales) {
        Range[] ranges = new Range[locales.length];
        int n = 0;
        while (n < locales.length) {
            ranges[n] = new Range(Lang.fromLocale((Locale)locales[n]), true);
            ++n;
        }
        return LocalizationHelper.selectAlternate(source, ranges);
    }

    public static Link[] selectAlternate(Source source, Range range) {
        return LocalizationHelper.selectAlternate(source, new Range[]{range});
    }

    public static Link[] selectAlternate(Source source, Range ... ranges) {
        return LocalizationHelper.selectAlternate((List<Link>)source.getLinks("alternate"), ranges);
    }

    public static Link[] selectAlternate(Source source, String range) {
        return LocalizationHelper.selectAlternate(source, new String[]{range});
    }

    public static Link[] selectAlternate(Source source, String ... ranges) {
        Range[] r = new Range[ranges.length];
        int n = 0;
        while (n < ranges.length) {
            r[n] = new Range(ranges[n], true);
            ++n;
        }
        return LocalizationHelper.selectAlternate(source, r);
    }

    public static Link[] selectAlternate(List<Link> links, String range) {
        return LocalizationHelper.selectAlternate(links, new Range(range, true));
    }

    public static Link[] selectAlternate(List<Link> links, Range range) {
        return LocalizationHelper.selectAlternate(links, new Range[]{range});
    }

    public static Link[] selectAlternate(List<Link> links, Range ... ranges) {
        ArrayList<Link> matching = new ArrayList<Link>();
        Range[] rangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            Range range = rangeArray[n2];
            for (Link link : links) {
                Lang blang;
                String hreflang = link.getHrefLang();
                if (hreflang == null) continue;
                Lang lang = new Lang(hreflang);
                Range basic = range.toBasicRange();
                Lang lang2 = blang = !basic.toString().equals("*") ? new Lang(basic.toString()) : null;
                if (!range.matches(lang) && (blang == null || !lang.isParentOf(blang))) continue;
                matching.add(link);
            }
            Collections.sort(matching, new Comparator<Link>(){

                @Override
                public int compare(Link o1, Link o2) {
                    Lang l1 = new Lang(o1.getHrefLang());
                    Lang l2 = new Lang(o2.getHrefLang());
                    return l1.compareTo((SubtagSet)l2);
                }
            });
            ++n2;
        }
        return matching.toArray(new Link[matching.size()]);
    }
}

