/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    public static Map<String, Object[]> getCacheableHeaders(ClientResponse response) {
        String[] headers;
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        String[] stringArray = headers = response.getHeaderNames();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            if (MethodHelper.isCacheableHeader(header, response)) {
                Object[] list = response.getHeaders(header);
                map.put(header, list);
            }
            ++n2;
        }
        return map;
    }

    public static boolean isCacheableHeader(String header, ClientResponse response) {
        return !MethodHelper.isNoCacheOrPrivate(header, response) && !MethodHelper.isHopByHop(header);
    }

    public static boolean isNoCacheOrPrivate(String header, ClientResponse response) {
        String[] no_cache_headers = response.getNoCacheHeaders();
        String[] private_headers = response.getPrivateHeaders();
        return MethodHelper.contains(no_cache_headers, header) || MethodHelper.contains(private_headers, header);
    }

    private static boolean contains(String[] headers, String header) {
        if (headers != null) {
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String h = stringArray[n2];
                if (h.equals(header)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isHopByHop(String header) {
        try {
            HopByHop.valueOf(header.replaceAll("-", ""));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static EntityEnclosingMethod getMethod(EntityEnclosingMethod method, RequestEntity entity) {
        if (entity != null) {
            method.setRequestEntity(entity);
        }
        return method;
    }

    public static HttpMethod createMethod(String method, String uri, RequestEntity entity, RequestOptions options) {
        if (method == null) {
            return null;
        }
        Method m = Method.fromString(method);
        Method actual = null;
        GetMethod httpMethod = null;
        if (options.isUsePostOverride()) {
            if (m.equals((Object)Method.PUT)) {
                actual = m;
            } else if (m.equals((Object)Method.DELETE)) {
                actual = m;
            }
            if (actual != null) {
                m = Method.POST;
            }
        }
        switch (m) {
            case GET: {
                httpMethod = new GetMethod(uri);
                break;
            }
            case POST: {
                httpMethod = MethodHelper.getMethod((EntityEnclosingMethod)new PostMethod(uri), entity);
                break;
            }
            case PUT: {
                httpMethod = MethodHelper.getMethod((EntityEnclosingMethod)new PutMethod(uri), entity);
                break;
            }
            case DELETE: {
                httpMethod = new DeleteMethod(uri);
                break;
            }
            case HEAD: {
                httpMethod = new HeadMethod(uri);
                break;
            }
            case OPTIONS: {
                httpMethod = new OptionsMethod(uri);
                break;
            }
            case TRACE: {
                httpMethod = new TraceMethod(uri);
                break;
            }
            default: {
                httpMethod = MethodHelper.getMethod(new ExtensionMethod(method, uri), entity);
            }
        }
        if (actual != null) {
            httpMethod.addRequestHeader("X-HTTP-Method-Override", actual.name());
        }
        MethodHelper.initHeaders(options, (HttpMethod)httpMethod);
        if (!options.isUseExpectContinue()) {
            httpMethod.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        }
        if (!(httpMethod instanceof EntityEnclosingMethod)) {
            httpMethod.setFollowRedirects(options.isFollowRedirects());
        }
        return httpMethod;
    }

    private static void initHeaders(RequestOptions options, HttpMethod method) {
        String[] headers;
        String[] stringArray = headers = options.getHeaderNames();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String[] values;
            String header = stringArray[n2];
            String[] stringArray2 = values = options.getHeaders(header);
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                String value = stringArray2[n4];
                method.addRequestHeader(header, value.toString());
                ++n4;
            }
            ++n2;
        }
        String cc = options.getCacheControl();
        if (cc != null && cc.length() != 0) {
            method.setRequestHeader("Cache-Control", cc);
        }
        if (options.getAuthorization() != null) {
            method.setDoAuthentication(false);
        }
    }

    public static RequestOptions createDefaultRequestOptions() {
        RequestOptions options = new RequestOptions();
        options.setAcceptEncoding("gzip", "deflate");
        options.setAccept("application/atom+xml;type=entry", "application/atom+xml;type=feed", "application/atom+xml", "application/atomsvc+xml", "application/atomcat+xml", "application/xml", "text/xml", "*/*");
        options.setAcceptCharset("utf-8", "*;q=0.5");
        return options;
    }

    public static final class ExtensionMethod
    extends EntityEnclosingMethod {
        private String method = null;

        public ExtensionMethod(String method, String uri) {
            super(method);
            try {
                this.setURI(new URI(uri, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.method = method;
        }

        public String getName() {
            return this.method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HopByHop {
        Connection,
        KeepAlive,
        ProxyAuthenticate,
        ProxyAuthorization,
        TE,
        Trailers,
        TransferEncoding,
        Upgrade;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        TRACE,
        HEAD,
        OTHER;


        public static Method fromString(String method) {
            try {
                return Method.valueOf(method.toUpperCase());
            }
            catch (Exception e) {
                return OTHER;
            }
        }
    }
}

