/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.protocol.EntityProvider;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.CommonsResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.abdera.protocol.client.cache.Cache;
import org.apache.abdera.protocol.client.cache.CacheFactory;
import org.apache.abdera.protocol.client.cache.CachedResponse;
import org.apache.abdera.protocol.client.cache.LRUCache;
import org.apache.abdera.protocol.client.cache.LRUCacheFactory;
import org.apache.abdera.protocol.client.util.BaseRequestEntity;
import org.apache.abdera.protocol.client.util.EntityProviderRequestEntity;
import org.apache.abdera.protocol.client.util.MethodHelper;
import org.apache.abdera.protocol.client.util.MultipartRelatedRequestEntity;
import org.apache.abdera.protocol.client.util.SimpleSSLProtocolSocketFactory;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.error.ProtocolException;
import org.apache.abdera.protocol.util.CacheControlUtil;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.ServiceUtil;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbderaClient {
    public static final String DEFAULT_USER_AGENT = "Abdera/v1.0-SNAPSHOT";
    public static int DEFAULT_MAX_REDIRECTS = 10;
    protected final Abdera abdera;
    protected final Cache cache;
    private final HttpClient client;

    public AbderaClient() {
        this(new Abdera(), DEFAULT_USER_AGENT);
    }

    public AbderaClient(String useragent) {
        this(new Abdera(), useragent);
    }

    public AbderaClient(Abdera abdera, String useragent) {
        this.abdera = abdera;
        this.cache = this.initCache(this.initCacheFactory());
        MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
        this.client = new HttpClient((HttpConnectionManager)connManager);
        this.client.getParams().setParameter("http.useragent", (Object)useragent);
        this.client.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        this.client.getParams().setCookiePolicy("compatibility");
        this.setAuthenticationSchemeDefaults();
        this.setMaximumRedirects(DEFAULT_MAX_REDIRECTS);
    }

    public AbderaClient(Abdera abdera) {
        this(abdera, DEFAULT_USER_AGENT);
    }

    private CacheFactory initCacheFactory() {
        CacheFactory cacheFactory = (CacheFactory)ServiceUtil.newInstance((String)CacheFactory.class.getName(), (String)LRUCacheFactory.class.getName(), (Abdera)this.abdera);
        return cacheFactory;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Cache initCache(CacheFactory factory) {
        Cache cache = null;
        if (factory != null) {
            cache = factory.getCache(this.abdera);
        }
        return cache != null ? cache : new LRUCache(this.abdera);
    }

    public ClientResponse head(String uri, RequestOptions options) {
        return this.execute("HEAD", uri, (RequestEntity)null, options);
    }

    public ClientResponse get(String uri, RequestOptions options) {
        return this.execute("GET", uri, (RequestEntity)null, options);
    }

    public ClientResponse post(String uri, EntityProvider provider, RequestOptions options) {
        return this.post(uri, new EntityProviderRequestEntity(this.abdera, provider, options.isUseChunked()), options);
    }

    public ClientResponse post(String uri, RequestEntity entity, RequestOptions options) {
        return this.execute("POST", uri, entity, options);
    }

    public ClientResponse post(String uri, InputStream in, RequestOptions options) {
        return this.execute("POST", uri, (RequestEntity)new InputStreamRequestEntity(in), options);
    }

    public ClientResponse post(String uri, Base base, RequestOptions options) {
        if (base instanceof Document) {
            Document d = (Document)base;
            if (options.getSlug() == null && d.getSlug() != null) {
                options.setSlug(d.getSlug());
            }
        }
        return this.execute("POST", uri, new BaseRequestEntity(base, options.isUseChunked()), options);
    }

    public ClientResponse post(String uri, Entry entry, InputStream media) {
        return this.post(uri, entry, media, this.getDefaultRequestOptions());
    }

    public ClientResponse post(String uri, Entry entry, InputStream media, RequestOptions options) {
        return this.post(uri, entry, media, null, options);
    }

    public ClientResponse post(String uri, Entry entry, InputStream media, String contentType, RequestOptions options) {
        return this.execute("POST", uri, new MultipartRelatedRequestEntity(entry, media, contentType), options);
    }

    public ClientResponse put(String uri, EntityProvider provider, RequestOptions options) {
        if (options == null) {
            options = this.getDefaultRequestOptions();
        }
        if (options.isConditionalPut()) {
            EntityTag etag = provider.getEntityTag();
            if (etag != null) {
                options.setIfMatch(etag);
            } else {
                Date lm = provider.getLastModified();
                if (lm != null) {
                    options.setIfUnmodifiedSince(lm);
                }
            }
        }
        return this.put(uri, new EntityProviderRequestEntity(this.abdera, provider, options.isUseChunked()), options);
    }

    public ClientResponse put(String uri, RequestEntity entity, RequestOptions options) {
        return this.execute("PUT", uri, entity, options);
    }

    public ClientResponse put(String uri, InputStream in, RequestOptions options) {
        return this.execute("PUT", uri, (RequestEntity)new InputStreamRequestEntity(in), options);
    }

    public ClientResponse put(String uri, Base base, RequestOptions options) {
        if (options == null) {
            options = this.getDefaultRequestOptions();
        }
        if (base instanceof Document) {
            Document d = (Document)base;
            if (options.getSlug() == null && d.getSlug() != null) {
                options.setSlug(d.getSlug());
            }
            if (options.isConditionalPut()) {
                if (d.getEntityTag() != null) {
                    options.setIfMatch(d.getEntityTag());
                } else if (d.getLastModified() != null) {
                    options.setIfUnmodifiedSince(d.getLastModified());
                }
            }
        }
        return this.execute("PUT", uri, new BaseRequestEntity(base, options.isUseChunked()), options);
    }

    public ClientResponse delete(String uri, RequestOptions options) {
        return this.execute("DELETE", uri, (RequestEntity)null, options);
    }

    public ClientResponse head(String uri) {
        return this.head(uri, this.getDefaultRequestOptions());
    }

    public ClientResponse get(String uri) {
        return this.get(uri, this.getDefaultRequestOptions());
    }

    public ClientResponse post(String uri, EntityProvider provider) {
        return this.post(uri, provider, this.getDefaultRequestOptions());
    }

    public ClientResponse post(String uri, RequestEntity entity) {
        return this.post(uri, entity, this.getDefaultRequestOptions());
    }

    public ClientResponse post(String uri, InputStream in) {
        return this.post(uri, in, this.getDefaultRequestOptions());
    }

    public ClientResponse post(String uri, Base base) {
        return this.post(uri, base, this.getDefaultRequestOptions());
    }

    public ClientResponse put(String uri, EntityProvider provider) {
        return this.put(uri, provider, this.getDefaultRequestOptions());
    }

    public ClientResponse put(String uri, RequestEntity entity) {
        return this.put(uri, entity, this.getDefaultRequestOptions());
    }

    public ClientResponse put(String uri, InputStream in) {
        return this.put(uri, in, this.getDefaultRequestOptions());
    }

    public ClientResponse put(String uri, Base base) {
        return this.put(uri, base, this.getDefaultRequestOptions());
    }

    public ClientResponse delete(String uri) {
        return this.delete(uri, this.getDefaultRequestOptions());
    }

    public static void registerScheme(String name, Class<? extends AuthScheme> scheme) {
        AuthPolicy.registerAuthScheme((String)name, scheme);
    }

    public static void unregisterScheme(String name) {
        AuthPolicy.unregisterAuthScheme((String)name);
    }

    public static void unregisterScheme(String ... names) {
        for (String name : names) {
            AbderaClient.unregisterScheme(name);
        }
    }

    public static void registerTrustManager(TrustManager trustManager) {
        AbderaClient.registerTrustManager(trustManager, 443);
    }

    public static void registerTrustManager() {
        AbderaClient.registerTrustManager(443);
    }

    public static void registerTrustManager(TrustManager trustManager, int port) {
        SimpleSSLProtocolSocketFactory f = new SimpleSSLProtocolSocketFactory(trustManager);
        AbderaClient.registerFactory(f, port);
    }

    public static void registerTrustManager(int port) {
        SimpleSSLProtocolSocketFactory f = new SimpleSSLProtocolSocketFactory();
        AbderaClient.registerFactory(f, port);
    }

    public static void registerFactory(SecureProtocolSocketFactory factory, int port) {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)factory, port));
    }

    public AbderaClient usePreemptiveAuthentication(boolean val) {
        this.client.getParams().setAuthenticationPreemptive(val);
        return this;
    }

    private boolean useCache(String method, RequestOptions options) {
        return CacheControlUtil.isIdempotent((String)method) && !options.isNoCache() && !options.isNoStore() && options.getUseLocalCache();
    }

    private boolean mustRevalidate(RequestOptions options, CachedResponse response) {
        if (options.getRevalidateWithAuth()) {
            if (options.getAuthorization() != null) {
                return true;
            }
            if (this.client.getParams().getBooleanParameter("http.authentication.preemptive", false)) {
                return true;
            }
            if (response != null && response.isPublic()) {
                return false;
            }
        }
        return false;
    }

    public ClientResponse execute(String method, String uri, Base base, RequestOptions options) {
        return this.execute(method, uri, new BaseRequestEntity(base), options);
    }

    public ClientResponse execute(String method, String uri, EntityProvider provider, RequestOptions options) {
        if (options == null) {
            options = this.getDefaultRequestOptions();
        }
        return this.execute(method, uri, new EntityProviderRequestEntity(this.abdera, provider, options.isUseChunked()), options);
    }

    public ClientResponse execute(String method, String uri, InputStream in, RequestOptions options) {
        InputStreamRequestEntity re = null;
        try {
            re = options.getContentType() != null ? new InputStreamRequestEntity(in, options.getContentType().toString()) : new InputStreamRequestEntity(in);
        }
        catch (Exception e) {
            re = new InputStreamRequestEntity(in);
        }
        return this.execute(method, uri, (RequestEntity)re, options);
    }

    private Cache.Disposition getCacheDisposition(boolean usecache, String uri, RequestOptions options, CachedResponse cached_response) {
        Cache.Disposition disp = usecache ? this.cache.disposition(uri, options) : Cache.Disposition.TRANSPARENT;
        disp = !disp.equals((Object)Cache.Disposition.TRANSPARENT) && this.mustRevalidate(options, cached_response) ? Cache.Disposition.STALE : disp;
        return disp;
    }

    public ClientResponse execute(String method, String uri, RequestEntity entity, RequestOptions options) {
        boolean usecache = this.useCache(method, options);
        options = options != null ? options : this.getDefaultRequestOptions();
        try {
            Cache cache = this.getCache();
            CachedResponse cached_response = cache.get(uri);
            switch (this.getCacheDisposition(usecache, uri, options, cached_response)) {
                case FRESH: {
                    if (cached_response != null) {
                        return this.checkRequestException(cached_response, options);
                    }
                }
                case STALE: {
                    if (cached_response == null) break;
                    if (cached_response.getEntityTag() != null) {
                        options.setIfNoneMatch(cached_response.getEntityTag().toString());
                        break;
                    }
                    if (cached_response.getLastModified() != null) {
                        options.setIfModifiedSince(cached_response.getLastModified());
                        break;
                    }
                    options.setNoCache(true);
                }
            }
            HttpMethod httpMethod = MethodHelper.createMethod(method, uri, entity, options);
            this.client.executeMethod(httpMethod);
            if (usecache && (httpMethod.getStatusCode() == 304 || httpMethod.getStatusCode() == 412) && cached_response != null) {
                return cached_response;
            }
            ClientResponse response = new CommonsResponse(this.abdera, httpMethod);
            response = options.getUseLocalCache() ? (response = cache.update(uri, options, response, cached_response)) : response;
            return this.checkRequestException(response, options);
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private ClientResponse checkRequestException(ClientResponse response, RequestOptions options) {
        if (response == null) {
            return response;
        }
        Response.ResponseType type = response.getType();
        if (type.equals((Object)Response.ResponseType.CLIENT_ERROR) && options.is4xxRequestException() || type.equals((Object)Response.ResponseType.SERVER_ERROR) && options.is5xxRequestException()) {
            try {
                Element root;
                Document doc = response.getDocument();
                Error error = null;
                if (doc != null && (root = doc.getRoot()) instanceof Error) {
                    error = (Error)root;
                }
                if (error == null) {
                    error = Error.create((Abdera)this.abdera, (int)response.getStatus(), (String)response.getStatusText());
                }
                error.throwException();
            }
            catch (ProtocolException pe) {
                throw pe;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    public RequestOptions getDefaultRequestOptions() {
        return MethodHelper.createDefaultRequestOptions();
    }

    public AbderaClient addCredentials(String target, String realm, String scheme, Credentials credentials) throws URISyntaxException {
        String host = AuthScope.ANY_HOST;
        int port = -1;
        if (target != null) {
            URI uri = new URI(target);
            host = uri.getHost();
            port = uri.getPort();
        }
        AuthScope scope = new AuthScope(host, port, realm != null ? realm : AuthScope.ANY_REALM, scheme != null ? scheme : AuthScope.ANY_SCHEME);
        this.client.getState().setCredentials(scope, credentials);
        return this;
    }

    public AbderaClient setAuthenticationSchemeDefaults() {
        List authPrefs = AuthPolicy.getDefaultAuthPrefs();
        this.client.getParams().setParameter("http.auth.scheme-priority", (Object)authPrefs);
        return this;
    }

    public AbderaClient setAuthenticationSchemePriority(String ... scheme) {
        List<String> authPrefs = Arrays.asList(scheme);
        this.client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        return this;
    }

    public String[] getAuthenticationSchemePriority() {
        List list = (List)this.client.getParams().getParameter("http.auth.scheme-priority");
        return list.toArray(new String[list.size()]);
    }

    public AbderaClient teardown() {
        ((MultiThreadedHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        return this;
    }

    public AbderaClient setMaxConnectionsPerHost(int max) {
        HashMap<HostConfiguration, Integer> m = new HashMap<HostConfiguration, Integer>();
        m.put(HostConfiguration.ANY_HOST_CONFIGURATION, max);
        this.client.getHttpConnectionManager().getParams().setParameter("http.connection-manager.max-per-host", m);
        return this;
    }

    public int getMaxConnectionsPerHost() {
        Map m = (Map)this.client.getHttpConnectionManager().getParams().getParameter("http.connection-manager.max-per-host");
        if (m == null) {
            return 2;
        }
        Integer i = (Integer)m.get(HostConfiguration.ANY_HOST_CONFIGURATION);
        return i != null ? i : 2;
    }

    public AbderaClient setMaxConnectionsTotal(int max) {
        this.client.getHttpConnectionManager().getParams().setIntParameter("http.connection-manager.max-total", max);
        return this;
    }

    public int getMaxConnectionsTotal() {
        return this.client.getHttpConnectionManager().getParams().getIntParameter("http.connection-manager.max-total", 20);
    }

    public AbderaClient setProxy(String host, int port) {
        this.client.getHostConfiguration().setProxy(host, port);
        return this;
    }

    public AbderaClient setProxyCredentials(String host, int port, Credentials credentials) {
        this.setProxyCredentials(host, port, null, null, credentials);
        return this;
    }

    public AbderaClient setProxyCredentials(String host, int port, String realm, String scheme, Credentials credentials) {
        host = host != null ? host : AuthScope.ANY_HOST;
        port = port > -1 ? port : -1;
        AuthScope scope = new AuthScope(host, port, realm != null ? realm : AuthScope.ANY_REALM, scheme != null ? scheme : AuthScope.ANY_SCHEME);
        this.client.getState().setProxyCredentials(scope, credentials);
        return this;
    }

    public AbderaClient addCookie(String domain, String name, String value) {
        Cookie cookie = new Cookie(domain, name, value);
        this.client.getState().addCookie(cookie);
        return this;
    }

    public AbderaClient addCookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        Cookie cookie = new Cookie(domain, name, value, path, expires, secure);
        this.client.getState().addCookie(cookie);
        return this;
    }

    public AbderaClient addCookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        Cookie cookie = new Cookie(domain, name, value, path, maxAge, secure);
        this.client.getState().addCookie(cookie);
        return this;
    }

    public AbderaClient addCookies(Cookie cookie) {
        this.client.getState().addCookie(cookie);
        return this;
    }

    public AbderaClient addCookies(Cookie ... cookies) {
        this.client.getState().addCookies(cookies);
        return this;
    }

    public Cookie[] getCookies() {
        return this.client.getState().getCookies();
    }

    public Cookie[] getCookies(String domain, String path) {
        Cookie[] cookies = this.getCookies();
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            String test = cookie.getDomain();
            if (test.startsWith(".")) {
                test = test.substring(1);
            }
            if (!domain.endsWith(test) && !test.endsWith(domain) || path != null && !cookie.getPath().startsWith(path)) continue;
            list.add(cookie);
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public Cookie[] getCookies(String domain) {
        return this.getCookies(domain, null);
    }

    public AbderaClient clearCookies() {
        this.client.getState().clearCookies();
        return this;
    }

    public AbderaClient setConnectionTimeout(int timeout) {
        this.client.getHttpConnectionManager().getParams().setIntParameter("http.connection.timeout", timeout);
        return this;
    }

    public AbderaClient setSocketTimeout(int timeout) {
        this.client.getParams().setSoTimeout(timeout);
        return this;
    }

    public void setConnectionManagerTimeout(long timeout) {
        this.client.getParams().setLongParameter("http.connection-manager.timeout", timeout);
    }

    public int getConnectionTimeout() {
        return this.client.getHttpConnectionManager().getParams().getIntParameter("http.connection.timeout", 0);
    }

    public int getSocketTimeout() {
        return this.client.getParams().getSoTimeout();
    }

    public long getConnectionManagerTimeout() {
        return this.client.getParams().getLongParameter("http.connection-manager.timeout", 0L);
    }

    public void setTcpNoDelay(boolean enable) {
        this.client.getHttpConnectionManager().getParams().setBooleanParameter("http.tcp.nodelay", enable);
    }

    public boolean getTcpNoDelay() {
        return this.client.getHttpConnectionManager().getParams().getBooleanParameter("http.tcp.nodelay", false);
    }

    public HttpConnectionManagerParams getHttpConnectionManagerParams() {
        return this.client.getHttpConnectionManager().getParams();
    }

    public HttpClientParams getHttpClientParams() {
        return this.client.getParams();
    }

    public AbderaClient setMaximumRedirects(int redirects) {
        this.client.getParams().setIntParameter("http.protocol.max-redirects", redirects);
        return this;
    }

    public int getMaximumRedirects() {
        return this.client.getParams().getIntParameter("http.protocol.max-redirects", DEFAULT_MAX_REDIRECTS);
    }

    public AbderaClient clearCredentials() {
        this.client.getState().clearCredentials();
        this.clearProxyCredentials();
        return this;
    }

    public AbderaClient clearProxyCredentials() {
        this.client.getState().clearProxyCredentials();
        return this;
    }

    public AbderaClient clearState() {
        this.client.getState().clear();
        return this;
    }
}

