/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appclient;

import java.util.Date;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Service;
import org.apache.abdera.protocol.client.AbderaClient;

public class Main {
    public static void main(String[] args) throws Exception {
        Abdera abdera = new Abdera();
        AbderaClient abderaClient = new AbderaClient(abdera);
        Factory factory = abdera.getFactory();
        Document introspection = abderaClient.get(args[0]).getDocument();
        Service service = (Service)introspection.getRoot();
        Collection collection = service.getCollection(args[1], args[2]);
        Main.report("The Collection Element", collection.toString());
        Entry entry = factory.newEntry();
        entry.setId("tag:example.org,2006:foo");
        entry.setTitle("This is the title");
        entry.setUpdated(new Date());
        entry.addAuthor("James");
        entry.setContent("This is the content");
        Main.report("The Entry to Post", entry.toString());
        Document doc = abderaClient.post(collection.getResolvedHref().toString(), (Base)entry).getDocument();
        IRI entryUri = doc.getBaseUri();
        Main.report("The Created Entry", ((Entry)doc.getRoot()).toString());
        IRI editUri = Main.getEditUri((Entry)doc.getRoot());
        if (editUri != null) {
            doc = abderaClient.get(editUri.toString()).getDocument();
            ((Entry)doc.getRoot()).getTitleElement().setValue("This is the changed title");
            abderaClient.put(editUri.toString(), (Base)doc.getRoot());
            doc = abderaClient.get(entryUri.toString()).getDocument();
            Main.report("The Modified Entry", ((Entry)doc.getRoot()).toString());
        } else {
            Main.report("The Entry cannot be modified", null);
        }
        doc = abderaClient.get(entryUri.toString()).getDocument();
        editUri = Main.getEditUri((Entry)doc.getRoot());
        if (editUri != null) {
            abderaClient.delete(editUri.toString());
            Main.report("The Enry has been deleted", null);
        } else {
            Main.report("The Entry cannot be deleted", null);
        }
    }

    private static IRI getEditUri(Entry entry) throws Exception {
        IRI editUri = null;
        List editLinks = entry.getLinks("edit");
        for (Link link : editLinks) {
            if (link.getMimeType() != null) {
                if (!link.getMimeType().match("application/atom+xml")) continue;
                editUri = link.getResolvedHref();
                break;
            }
            editUri = link.getResolvedHref();
            break;
        }
        return editUri;
    }

    private static void report(String title, String message) {
        System.out.println("== " + title + " ==");
        if (message != null) {
            System.out.println(message);
        }
        System.out.println();
    }
}

